/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.VaultKubernetesAuthService;
import io.quarkus.vault.auth.VaultKubernetesAuthConfig;
import io.quarkus.vault.auth.VaultKubernetesAuthRole;
import io.quarkus.vault.runtime.VaultAuthManager;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.quarkus.vault.runtime.client.authmethod.VaultInternalKubernetesAuthMethod;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthConfigData;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthListRolesData;
import io.quarkus.vault.runtime.client.dto.auth.VaultKubernetesAuthRoleData;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class VaultKubernetesAuthManager
implements VaultKubernetesAuthService {
    @Inject
    private VaultAuthManager vaultAuthManager;
    @Inject
    private VaultInternalKubernetesAuthMethod vaultInternalKubernetesAuthMethod;

    @Override
    public void configure(VaultKubernetesAuthConfig config) {
        String token = this.vaultAuthManager.getClientToken();
        this.vaultInternalKubernetesAuthMethod.configureAuth(token, new VaultKubernetesAuthConfigData().setIssuer(config.issuer).setKubernetesCaCert(config.kubernetesCaCert).setKubernetesHost(config.kubernetesHost).setPemKeys(config.pemKeys).setTokenReviewerJwt(config.tokenReviewerJwt));
    }

    @Override
    public VaultKubernetesAuthConfig getConfig() {
        String token = this.vaultAuthManager.getClientToken();
        VaultKubernetesAuthConfigData data = (VaultKubernetesAuthConfigData)this.vaultInternalKubernetesAuthMethod.readAuthConfig((String)token).data;
        return new VaultKubernetesAuthConfig().setKubernetesCaCert(data.kubernetesCaCert).setKubernetesHost(data.kubernetesHost).setIssuer(data.issuer).setPemKeys(data.pemKeys).setTokenReviewerJwt(data.tokenReviewerJwt);
    }

    @Override
    public VaultKubernetesAuthRole getRole(String name) {
        String token = this.vaultAuthManager.getClientToken();
        VaultKubernetesAuthRoleData role = (VaultKubernetesAuthRoleData)this.vaultInternalKubernetesAuthMethod.getVaultAuthRole((String)token, (String)name).data;
        return new VaultKubernetesAuthRole().setBoundServiceAccountNames(role.boundServiceAccountNames).setBoundServiceAccountNamespaces(role.boundServiceAccountNamespaces).setAudience(role.audience).setTokenTtl(role.tokenTtl).setTokenMaxTtl(role.tokenMaxTtl).setTokenPolicies(role.tokenPolicies).setTokenBoundCidrs(role.tokenBoundCidrs).setTokenExplicitMaxTtl(role.tokenExplicitMaxTtl).setTokenNoDefaultPolicy(role.tokenNoDefaultPolicy).setTokenNumUses(role.tokenNumUses).setTokenPeriod(role.tokenPeriod).setTokenType(role.tokenType);
    }

    @Override
    public void createRole(String name, VaultKubernetesAuthRole role) {
        String token = this.vaultAuthManager.getClientToken();
        VaultKubernetesAuthRoleData body = new VaultKubernetesAuthRoleData().setBoundServiceAccountNames(role.boundServiceAccountNames).setBoundServiceAccountNamespaces(role.boundServiceAccountNamespaces).setAudience(role.audience).setTokenTtl(role.tokenTtl).setTokenMaxTtl(role.tokenMaxTtl).setTokenPolicies(role.tokenPolicies).setTokenBoundCidrs(role.tokenBoundCidrs).setTokenExplicitMaxTtl(role.tokenExplicitMaxTtl).setTokenNoDefaultPolicy(role.tokenNoDefaultPolicy).setTokenNumUses(role.tokenNumUses).setTokenPeriod(role.tokenPeriod).setTokenType(role.tokenType);
        this.vaultInternalKubernetesAuthMethod.createAuthRole(token, name, body);
    }

    @Override
    public List<String> getRoles() {
        try {
            String token = this.vaultAuthManager.getClientToken();
            return ((VaultKubernetesAuthListRolesData)this.vaultInternalKubernetesAuthMethod.listAuthRoles((String)token).data).keys;
        }
        catch (VaultClientException e) {
            if (e.getStatus() == 404) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Override
    public void deleteRole(String name) {
        String token = this.vaultAuthManager.getClientToken();
        this.vaultInternalKubernetesAuthMethod.deleteAuthRoles(token, name);
    }
}

