/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.vault.VaultException;
import io.quarkus.vault.VaultKVSecretEngine;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.VaultDynamicCredentialsManager;
import io.quarkus.vault.runtime.config.CredentialsProviderConfig;
import io.quarkus.vault.runtime.config.VaultBootstrapConfig;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;

@ApplicationScoped
@Named(value="vault-credentials-provider")
public class VaultCredentialsProvider
implements CredentialsProvider {
    @Inject
    private VaultKVSecretEngine vaultKVSecretEngine;
    @Inject
    private VaultDynamicCredentialsManager vaultDynamicCredentialsManager;
    @Inject
    private VaultConfigHolder vaultConfigHolder;

    public Map<String, String> getCredentials(String credentialsProviderName) {
        VaultBootstrapConfig vaultConfig = this.getConfig();
        if (vaultConfig == null) {
            throw new VaultException("missing Vault configuration required for credentials providers with name " + credentialsProviderName);
        }
        CredentialsProviderConfig config = vaultConfig.credentialsProvider.get(credentialsProviderName);
        if (config == null) {
            throw new VaultException("unknown credentials provider with name " + credentialsProviderName);
        }
        if (config.databaseCredentialsRole.isPresent()) {
            return this.vaultDynamicCredentialsManager.getDynamicCredentials("database", "creds", config.databaseCredentialsRole.get());
        }
        if (config.credentialsRole.isPresent()) {
            return this.vaultDynamicCredentialsManager.getDynamicCredentials(config.credentialsMount, config.credentialsRequestPath, config.credentialsRole.get());
        }
        if (config.kvPath.isPresent()) {
            String password = this.vaultKVSecretEngine.readSecret(config.kvPath.get()).get(config.kvKey);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("password", password);
            return result;
        }
        throw new VaultException("one of database-credentials-role or kv-path is required on credentials provider " + credentialsProviderName);
    }

    private VaultBootstrapConfig getConfig() {
        return this.vaultConfigHolder.getVaultBootstrapConfig();
    }
}

