/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.pki;

import io.quarkus.vault.pki.DataFormat;
import io.quarkus.vault.pki.X509Parsing;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public interface CertificateData {
    public DataFormat getFormat();

    public Object getData();

    public X509Certificate getCertificate() throws CertificateException;

    public static class PEM
    implements CertificateData {
        private final String pemData;

        public PEM(String pemData) {
            this.pemData = pemData;
        }

        @Override
        public DataFormat getFormat() {
            return DataFormat.PEM;
        }

        @Override
        public String getData() {
            return this.pemData;
        }

        @Override
        public X509Certificate getCertificate() throws CertificateException {
            return X509Parsing.parsePEMCertificate(this.pemData);
        }
    }

    public static class DER
    implements CertificateData {
        private final byte[] derData;

        public DER(byte[] derData) {
            this.derData = derData;
        }

        @Override
        public DataFormat getFormat() {
            return DataFormat.DER;
        }

        public byte[] getData() {
            return this.derData;
        }

        @Override
        public X509Certificate getCertificate() throws CertificateException {
            return X509Parsing.parseDERCertificate(this.derData);
        }
    }
}

