/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.pki;

import io.quarkus.vault.pki.DataFormat;
import io.quarkus.vault.pki.X509Parsing;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;

public interface CRLData {
    public DataFormat getFormat();

    public Object getData();

    public X509CRL getCRL() throws CRLException;

    public static class PEM
    implements CRLData {
        private final String pemData;

        public PEM(String pemData) {
            this.pemData = pemData;
        }

        @Override
        public DataFormat getFormat() {
            return DataFormat.PEM;
        }

        @Override
        public String getData() {
            return this.pemData;
        }

        @Override
        public X509CRL getCRL() throws CRLException {
            return X509Parsing.parsePEMCRL(this.pemData);
        }
    }

    public static class DER
    implements CRLData {
        private final byte[] derData;

        public DER(byte[] derData) {
            this.derData = derData;
        }

        @Override
        public DataFormat getFormat() {
            return DataFormat.DER;
        }

        public byte[] getData() {
            return this.derData;
        }

        @Override
        public X509CRL getCRL() throws CRLException {
            return X509Parsing.parseDERCRL(this.derData);
        }
    }
}

