/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.utils.StringUtil;

public class GroupsResource {
    @Context
    private KeycloakSession session;
    private RealmModel realm;
    private AdminPermissionEvaluator auth;

    public GroupsResource(RealmModel realm, AdminPermissionEvaluator auth) {
        this.realm = realm;
        this.auth = auth;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all groups with fine grained authorisation", description="This endpoint returns a list of groups with fine grained authorisation")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=GroupRepresentation.class, type=SchemaType.ARRAY))})
    public final Stream<GroupRepresentation> listGroups(@QueryParam(value="search") @DefaultValue(value="") String search, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="10") int max) {
        this.auth.groups().requireList();
        Stream stream = "".equals(search) ? this.realm.searchForGroupByNameStream(search, Integer.valueOf(first), Integer.valueOf(max)) : this.realm.getTopLevelGroupsStream(Integer.valueOf(first), Integer.valueOf(max));
        return stream.map(g -> this.toGroupHierarchy((GroupModel)g, search));
    }

    private GroupRepresentation toGroupHierarchy(GroupModel group, String search) {
        GroupRepresentation rep = ModelToRepresentation.toRepresentation((GroupModel)group, (boolean)true);
        rep.setAccess(this.auth.groups().getAccess(group));
        rep.setSubGroups(group.getSubGroupsStream().filter(g -> GroupsResource.groupMatchesSearchOrIsPathElement(g, search)).map(subGroup -> ModelToRepresentation.toGroupHierarchy((GroupModel)subGroup, (boolean)true, (String)search)).collect(Collectors.toList()));
        return rep;
    }

    private static boolean groupMatchesSearchOrIsPathElement(GroupModel group, String search) {
        if (StringUtil.isBlank((String)search)) {
            return true;
        }
        if (group.getName().contains(search)) {
            return true;
        }
        return group.getSubGroupsStream().findAny().isPresent();
    }
}

