/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.oidc.AuthChallenge;
import org.wildfly.security.http.oidc.AuthenticatedActionsHandler;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.NodesRegistrationManagement;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcClientContext;
import org.wildfly.security.http.oidc.OidcHttpFacade;
import org.wildfly.security.http.oidc.RequestAuthenticator;

final class OidcAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    private final Map<String, ?> properties;
    private final CallbackHandler callbackHandler;
    private final OidcClientContext oidcClientContext;

    OidcAuthenticationMechanism(Map<String, ?> properties, CallbackHandler callbackHandler, OidcClientContext oidcClientContext) {
        this.properties = properties;
        this.callbackHandler = callbackHandler;
        this.oidcClientContext = oidcClientContext;
    }

    @Override
    public String getMechanismName() {
        return "OIDC";
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        OidcClientContext oidcClientContext = this.getOidcClientContext(request);
        if (oidcClientContext == null) {
            ElytronMessages.log.debugf("Ignoring request for path [%s] from mechanism [%s]. No client configuration context found.", (Object)request.getRequestURI(), (Object)this.getMechanismName());
            request.noAuthenticationInProgress();
            return;
        }
        OidcHttpFacade httpFacade = new OidcHttpFacade(request, oidcClientContext, this.callbackHandler);
        OidcClientConfiguration oidcClientConfiguration = httpFacade.getOidcClientConfiguration();
        if (!oidcClientConfiguration.isConfigured()) {
            request.noAuthenticationInProgress();
            return;
        }
        RequestAuthenticator authenticator = this.createRequestAuthenticator(httpFacade, oidcClientConfiguration);
        httpFacade.getTokenStore().checkCurrentToken();
        if (oidcClientConfiguration.getAuthServerBaseUrl() != null && this.keycloakPreActions(httpFacade, oidcClientContext)) {
            ElytronMessages.log.debugf("Pre-actions has aborted the evaluation of [%s]", (Object)request.getRequestURI());
            httpFacade.authenticationInProgress();
            return;
        }
        Oidc.AuthOutcome outcome = authenticator.authenticate();
        if (Oidc.AuthOutcome.AUTHENTICATED.equals((Object)outcome)) {
            if (new AuthenticatedActionsHandler(oidcClientConfiguration, httpFacade).handledRequest()) {
                httpFacade.authenticationInProgress();
            } else {
                httpFacade.authenticationComplete();
            }
            return;
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            httpFacade.noAuthenticationInProgress(challenge);
            return;
        }
        if (Oidc.AuthOutcome.FAILED.equals((Object)outcome)) {
            httpFacade.getResponse().setStatus(403);
            httpFacade.authenticationFailed();
            return;
        }
        httpFacade.noAuthenticationInProgress();
    }

    private RequestAuthenticator createRequestAuthenticator(OidcHttpFacade httpFacade, OidcClientConfiguration deployment) {
        return new RequestAuthenticator(httpFacade, deployment, this.getConfidentialPort());
    }

    private OidcClientContext getOidcClientContext(HttpServerRequest request) {
        if (this.oidcClientContext == null) {
            return (OidcClientContext)request.getScope(Scope.APPLICATION).getAttachment(Oidc.OIDC_CLIENT_CONTEXT_KEY);
        }
        return this.oidcClientContext;
    }

    private int getConfidentialPort() {
        return 8443;
    }

    private boolean keycloakPreActions(OidcHttpFacade httpFacade, OidcClientContext deploymentContext) {
        NodesRegistrationManagement nodesRegistrationManagement = new NodesRegistrationManagement();
        nodesRegistrationManagement.tryRegister(httpFacade.getOidcClientConfiguration());
        return false;
    }
}

