/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.smiles.SmilesRing;
import org.jmol.smiles.SmilesRingSet;
import org.jmol.smiles.VTemp;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.SimpleNode;

public class SmilesAromatic {
    private static final int[][] OS_PI_COUNTS = new int[][]{{-2, 1, 0}, {1, 2, 1, -1}, {2, 1, 2, 1, 1}, {2, 1}, {-2, 1, 2, 1, -2}, {2, 1, 2, 2}};

    static void setAromatic(int n, Node[] jmolAtoms, BS bsSelected, Lst<Object> vR, BS bsAromatic, int strictness, boolean isOpenSMILES, boolean justCheckBonding, boolean checkExplicit, VTemp v, Lst<BS> vOK, Lst<SmilesRing> lstSP2, int[] eCounts, boolean doTestAromatic) {
        boolean doCheck;
        boolean bl = doCheck = isOpenSMILES || strictness > 0;
        if (!doTestAromatic) {
            int r = vR.size();
            while (--r >= 0) {
                BS bs = BSUtil.copy((BS)vR.get(r));
                bs.and(bsAromatic);
                if (bs.cardinality() != n) continue;
                vOK.addLast(bs);
            }
            return;
        }
        int r = vR.size();
        block6: while (--r >= 0) {
            BS bs = (BS)vR.get(r);
            boolean isOK = SmilesAromatic.isSp2Ring(n, jmolAtoms, bsSelected, bs, justCheckBonding ? Float.MAX_VALUE : (strictness > 0 ? 0.1f : 0.01f), checkExplicit, strictness == 0);
            if (!isOK) continue;
            bsAromatic.or(bs);
            if (doCheck) {
                Lst<Edge> edges = new Lst<Edge>();
                int i = bs.nextSetBit(0);
                while (i >= 0) {
                    Node a = jmolAtoms[i];
                    Edge[] aedges = a.getEdges();
                    int ai = a.getIndex();
                    int j = aedges.length;
                    while (--j >= 0) {
                        SimpleNode a2 = aedges[j].getOtherNode(a);
                        int a2i = a2.getIndex();
                        if (a2i <= ai || !bs.get(a2i)) continue;
                        edges.addLast(aedges[j]);
                    }
                    i = bs.nextSetBit(i + 1);
                }
                switch (SmilesAromatic.checkHueckelAromatic(n, jmolAtoms, bsAromatic, bs, strictness, eCounts)) {
                    case -1: {
                        continue block6;
                    }
                    case 0: {
                        isOK = false;
                    }
                    case 1: {
                        if (lstSP2 != null) {
                            lstSP2.addLast(new SmilesRing(n, bs, edges, isOK));
                        }
                        if (isOK) break;
                        continue block6;
                    }
                }
            }
            vOK.addLast(bs);
        }
    }

    static void checkAromaticDefined(Node[] jmolAtoms, BS bsSelected, BS bsAromatic) {
        int i = bsSelected.nextSetBit(0);
        while (i >= 0) {
            Edge[] bonds = jmolAtoms[i].getEdges();
            for (int j = 0; j < bonds.length; ++j) {
                switch (bonds[j].getBondType()) {
                    case 513: 
                    case 514: 
                    case 515: {
                        bsAromatic.set(bonds[j].getAtomIndex1());
                        bsAromatic.set(bonds[j].getAtomIndex2());
                    }
                }
            }
            i = bsSelected.nextSetBit(i + 1);
        }
    }

    private static final boolean isSp2Ring(int n, Node[] atoms, BS bsSelected, BS bs, float cutoff, boolean checkExplicit, boolean allowSOxide) {
        int i;
        if (checkExplicit) {
            i = bs.nextSetBit(0);
            while (i >= 0) {
                if (atoms[i].getCovalentBondCount() > 3) {
                    return false;
                }
                i = bs.nextSetBit(i + 1);
            }
        } else {
            i = bs.nextSetBit(0);
            while (i >= 0) {
                if (atoms[i].getCovalentBondCountPlusMissingH() > 3) {
                    return false;
                }
                i = bs.nextSetBit(i + 1);
            }
        }
        if (cutoff == Float.MAX_VALUE) {
            return true;
        }
        if (cutoff <= 0.0f) {
            cutoff = 0.01f;
        }
        V3 vNorm = null;
        V3 vTemp = null;
        V3 vMean = null;
        int nPoints = bs.cardinality();
        V3[] vNorms = new V3[nPoints * 2];
        int nNorms = 0;
        float maxDev = 1.0f - cutoff * 5.0f;
        int i2 = bs.nextSetBit(0);
        while (i2 >= 0) {
            Node ringAtom = atoms[i2];
            Edge[] bonds = ringAtom.getEdges();
            int iSub = -1;
            int r1 = -1;
            int r2 = -1;
            int k = bonds.length;
            while (--k >= 0) {
                int iAtom = ringAtom.getBondedAtomIndex(k);
                if (!bsSelected.get(iAtom)) continue;
                if (!bs.get(iAtom)) {
                    if (ringAtom.getElementNumber() == 16) {
                        if (!allowSOxide) {
                            return false;
                        }
                        iAtom = -1;
                    }
                    iSub = iAtom;
                    continue;
                }
                if (r1 < 0) {
                    r1 = iAtom;
                    continue;
                }
                r2 = iAtom;
            }
            if (vMean == null) {
                vMean = new V3();
                vNorm = new V3();
                vTemp = new V3();
            }
            int j = i2;
            for (k = 0; k < 2; ++k) {
                Measure.getNormalThroughPoints((P3)((Object)atoms[r1]), (P3)((Object)atoms[j]), (P3)((Object)atoms[r2]), vNorm, vTemp);
                if (!SmilesAromatic.addNormal(vNorm, vMean, maxDev)) {
                    return false;
                }
                vNorms[nNorms++] = V3.newV(vNorm);
                j = iSub;
                if (j < 0) break;
            }
            i2 = bs.nextSetBit(i2 + 1);
        }
        return SmilesAromatic.checkStandardDeviation(vNorms, vMean, nNorms, cutoff);
    }

    private static final boolean addNormal(V3 vTemp, V3 vMean, float maxDev) {
        float similarity = vMean.dot(vTemp);
        if (similarity != 0.0f && Math.abs(similarity) < maxDev) {
            return false;
        }
        if (similarity < 0.0f) {
            vTemp.scale(-1.0f);
        }
        vMean.add(vTemp);
        vMean.normalize();
        return true;
    }

    private static final boolean checkStandardDeviation(V3[] vNorms, V3 vMean, int n, float cutoff) {
        double sum = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < n; ++i) {
            float v = vNorms[i].dot(vMean);
            sum += (double)v;
            sum2 += (double)v * (double)v;
        }
        return (sum = Math.sqrt((sum2 - sum * sum / (double)n) / (double)(n - 1))) < (double)cutoff;
    }

    private static int checkHueckelAromatic(int nAtoms, Node[] jmolAtoms, BS bsAromatic, BS bsRing, int strictness, int[] eCounts) {
        int npi = 0;
        int n1 = 0;
        int i = bsRing.nextSetBit(0);
        while (i >= 0 && npi >= 0) {
            int pt;
            int fc;
            Node atom = jmolAtoms[i];
            int z = atom.getElementNumber();
            int n = atom.getCovalentBondCountPlusMissingH();
            n += atom.getValence();
            n -= 4;
            if (z == 6 && (fc = atom.getFormalCharge()) != Integer.MIN_VALUE) {
                n += fc;
            }
            int n2 = z >= 5 && z <= 8 ? z - 5 : (z == 15 ? 2 : (z == 34 ? 3 : (z == 33 ? 4 : (pt = z == 16 ? 5 : -1))));
            if (pt >= 0) {
                int[] a = OS_PI_COUNTS[pt];
                if (n < 0 || n >= a.length) {
                    return -1;
                }
                n = a[n];
                block0 : switch (n) {
                    case -2: {
                        return -1;
                    }
                    case -1: {
                        Edge[] bonds = atom.getEdges();
                        n = 0;
                        int j = bonds.length;
                        while (--j >= 0) {
                            Edge b = bonds[j];
                            if (b.getCovalentOrder() != 2) continue;
                            SimpleNode het = b.getOtherNode(atom);
                            n = het.getElementNumber() == 6 || bsAromatic.get(het.getIndex()) ? 1 : (strictness > 0 ? -100 : 0);
                            break block0;
                        }
                        break;
                    }
                }
                if (n < 0) {
                    return -1;
                }
                if (eCounts != null) {
                    eCounts[i] = n;
                }
                npi += n;
                if (n == 1) {
                    ++n1;
                }
                if (Logger.debuggingHigh) {
                    Logger.info("atom " + atom + " pi=" + n + " npi=" + npi);
                }
            }
            i = bsRing.nextSetBit(i + 1);
        }
        return (npi - 2) % 4 == 0 && (strictness < 2 || nAtoms == 5 || n1 == 6) ? 1 : 0;
    }

    static void finalizeAromatic(Node[] jmolAtoms, BS bsAromatic, Lst<BS> lstAromatic, Lst<SmilesRing> lstSP2, int[] eCounts, boolean isOpenNotStrict, boolean isStrict) {
        if (isStrict) {
            SmilesAromatic.removeBridgingRings(lstAromatic, lstSP2);
        }
        SmilesAromatic.checkFusedRings(lstSP2, eCounts, lstAromatic);
        bsAromatic.clearAll();
        int i = lstAromatic.size();
        while (--i >= 0) {
            bsAromatic.or((BS)lstAromatic.get(i));
        }
        if (isStrict || isOpenNotStrict) {
            i = bsAromatic.nextSetBit(0);
            while (i >= 0) {
                Edge[] bonds = jmolAtoms[i].getEdges();
                int naro = 0;
                int j = bonds.length;
                while (--j >= 0) {
                    SimpleNode otherAtom = bonds[j].getOtherNode(jmolAtoms[i]);
                    int order = bonds[j].getCovalentOrder();
                    int ai2 = otherAtom.getIndex();
                    boolean isJAro = bsAromatic.get(ai2);
                    if (isJAro) {
                        if (order == 2) {
                            boolean isOK = false;
                            int k = lstSP2.size();
                            while (--k >= 0) {
                                SmilesRing r = (SmilesRing)lstSP2.get(k);
                                if (!r.get(i) || !r.get(ai2)) continue;
                                isOK = true;
                                break;
                            }
                            if (!isOK) {
                                naro = -1;
                                break;
                            }
                        }
                        ++naro;
                        continue;
                    }
                    if (!isStrict || otherAtom.getElementNumber() != 6 || order != 2) continue;
                    naro = -1;
                    break;
                }
                if (naro < 2) {
                    bsAromatic.clear(i);
                    i = -1;
                }
                i = bsAromatic.nextSetBit(i + 1);
            }
        }
    }

    private static void removeBridgingRings(Lst<BS> lstAromatic, Lst<SmilesRing> lstSP2) {
        BS bs = new BS();
        BS bsBad = new BS();
        BS bsBad2 = new BS();
        SmilesAromatic.checkBridges(lstAromatic, bsBad, lstAromatic, bsBad, bs);
        SmilesAromatic.checkBridges(lstSP2, bsBad2, lstSP2, bsBad2, bs);
        SmilesAromatic.checkBridges(lstAromatic, bsBad, lstSP2, bsBad2, bs);
        int i = lstAromatic.size();
        while (--i >= 0) {
            if (!bsBad.get(i)) continue;
            lstAromatic.removeItemAt(i);
        }
        i = lstSP2.size();
        while (--i >= 0) {
            if (!bsBad2.get(i)) continue;
            lstSP2.removeItemAt(i);
        }
    }

    private static void checkBridges(Lst<?> lst, BS bsBad, Lst<?> lst2, BS bsBad2, BS bs) {
        boolean isSameList = lst == lst2;
        int i = lst.size();
        while (--i >= 0) {
            BS bs1 = (BS)lst.get(i);
            int j0 = isSameList ? i + 1 : 0;
            int j = lst2.size();
            while (--j >= j0) {
                BS bs2 = (BS)lst2.get(j);
                if (bs2.equals(bs1)) continue;
                bs.clearAll();
                bs.or(bs1);
                bs.and(bs2);
                int n = bs.cardinality();
                if (n <= 2) continue;
                bsBad.set(i);
                bsBad2.set(j);
            }
        }
    }

    private static void checkFusedRings(Lst<SmilesRing> rings, int[] eCounts, Lst<BS> lstAromatic) {
        int j;
        SmilesRing r;
        Hashtable<String, SmilesRingSet> htEdgeMap = new Hashtable<String, SmilesRingSet>();
        int i = rings.size();
        while (--i >= 0) {
            SmilesRingSet smilesRingSet;
            r = (SmilesRing)rings.get(i);
            Lst<Edge> edges = r.edges;
            j = edges.size();
            while (--j >= 0) {
                SmilesRingSet set = SmilesRing.getSetByEdge((Edge)edges.get(j), htEdgeMap);
                if (set == null || set == r.set) continue;
                if (r.set != null) {
                    set.addSet(r.set, htEdgeMap);
                    continue;
                }
                set.addRing(r);
            }
            if (r.set == null) {
                smilesRingSet = new SmilesRingSet();
                r.set = r.set;
            } else {
                smilesRingSet = r.set;
            }
            smilesRingSet.addRing(r);
            r.addEdges(htEdgeMap);
        }
        int i2 = rings.size();
        while (--i2 >= 0) {
            SmilesRingSet set;
            r = (SmilesRing)rings.get(i2);
            if (r.isOK || (set = r.set) == null || set.isEmpty()) continue;
            if (set.getElectronCount(eCounts) % 4 == 2) {
                j = set.size();
                while (--j >= 0) {
                    r = (SmilesRing)set.get(j);
                    if (r.isOK) continue;
                    lstAromatic.addLast(r);
                }
            }
            set.clear();
        }
    }
}

