/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.JavaVariable;
import jadx.api.data.ICodeRename;
import jadx.api.data.IJavaCodeRef;
import jadx.api.data.IJavaNodeRef;
import jadx.api.data.impl.JadxCodeData;
import jadx.api.data.impl.JadxCodeRef;
import jadx.api.data.impl.JadxCodeRename;
import jadx.api.data.impl.JadxNodeRef;
import jadx.core.deobf.NameMapper;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.jobs.TaskStatus;
import jadx.gui.settings.JadxProject;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JField;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JPackage;
import jadx.gui.treemodel.JVariable;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.TabbedPane;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.DocumentUpdateListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameDialog
extends JDialog {
    private static final long serialVersionUID = -3269715644416902410L;
    private static final Logger LOG = LoggerFactory.getLogger(RenameDialog.class);
    private final transient MainWindow mainWindow;
    private final transient CacheObject cache;
    private final transient JNode source;
    private final transient JNode node;
    private transient JTextField renameField;
    private transient JButton renameBtn;

    public static boolean rename(MainWindow mainWindow, JNode node) {
        return RenameDialog.rename(mainWindow, node, node);
    }

    public static boolean rename(MainWindow mainWindow, JNode source, JNode node) {
        RenameDialog renameDialog = new RenameDialog(mainWindow, source, node);
        UiUtils.uiRun(() -> renameDialog.setVisible(true));
        UiUtils.uiRun(renameDialog::initRenameField);
        return true;
    }

    private RenameDialog(MainWindow mainWindow, JNode source, JNode node) {
        super(mainWindow);
        this.mainWindow = mainWindow;
        this.cache = mainWindow.getCacheObject();
        this.source = source;
        this.node = this.replaceNode(node);
        this.initUI();
    }

    private void initRenameField() {
        this.renameField.setText(this.node.getName());
        this.renameField.selectAll();
    }

    private JNode replaceNode(JNode node) {
        if (node instanceof JMethod) {
            JavaMethod javaMethod = ((JMethod)node).getJavaMethod();
            if (javaMethod.isClassInit()) {
                throw new JadxRuntimeException("Can't rename class init method: " + node);
            }
            if (javaMethod.isConstructor()) {
                return node.getJParent();
            }
        }
        return node;
    }

    private boolean checkNewName() {
        String newName = this.renameField.getText();
        if (newName.isEmpty()) {
            return true;
        }
        boolean valid = NameMapper.isValidIdentifier((String)newName);
        if (this.renameBtn.isEnabled() != valid) {
            this.renameBtn.setEnabled(valid);
            this.renameField.putClientProperty("JComponent.outline", valid ? "" : "error");
        }
        return valid;
    }

    private void rename() {
        if (!this.checkNewName()) {
            return;
        }
        try {
            this.updateCodeRenames(set -> this.processRename(this.node, this.renameField.getText(), (Set<ICodeRename>)set));
            this.refreshState();
        }
        catch (Exception e) {
            LOG.error("Rename failed", (Throwable)e);
            UiUtils.errorMessage(this, "Rename failed:\n" + Utils.getStackTrace((Throwable)e));
        }
        this.dispose();
    }

    private void processRename(JNode node, String newName, Set<ICodeRename> renames) {
        JadxCodeRename rename = this.buildRename(node, newName, renames);
        renames.remove(rename);
        JavaNode javaNode = node.getJavaNode();
        if (javaNode != null) {
            javaNode.removeAlias();
        }
        if (!newName.isEmpty()) {
            renames.add((ICodeRename)rename);
        }
    }

    @NotNull
    private JadxCodeRename buildRename(JNode node, String newName, Set<ICodeRename> renames) {
        if (node instanceof JMethod) {
            JavaMethod javaMethod = ((JMethod)node).getJavaMethod();
            List relatedMethods = javaMethod.getOverrideRelatedMethods();
            if (!relatedMethods.isEmpty()) {
                for (JavaMethod relatedMethod : relatedMethods) {
                    renames.remove(new JadxCodeRename((IJavaNodeRef)JadxNodeRef.forMth((JavaMethod)relatedMethod), ""));
                }
            }
            return new JadxCodeRename((IJavaNodeRef)JadxNodeRef.forMth((JavaMethod)javaMethod), newName);
        }
        if (node instanceof JField) {
            return new JadxCodeRename((IJavaNodeRef)JadxNodeRef.forFld((JavaField)((JField)node).getJavaField()), newName);
        }
        if (node instanceof JClass) {
            return new JadxCodeRename((IJavaNodeRef)JadxNodeRef.forCls((JavaClass)((JClass)node).getCls()), newName);
        }
        if (node instanceof JPackage) {
            return new JadxCodeRename((IJavaNodeRef)JadxNodeRef.forPkg((String)((JPackage)node).getFullName()), newName);
        }
        if (node instanceof JVariable) {
            JavaVariable javaVar = ((JVariable)node).getJavaVarNode();
            return new JadxCodeRename((IJavaNodeRef)JadxNodeRef.forMth((JavaMethod)javaVar.getMth()), (IJavaCodeRef)JadxCodeRef.forVar((JavaVariable)javaVar), newName);
        }
        throw new JadxRuntimeException("Failed to build rename node for: " + node);
    }

    private void updateCodeRenames(Consumer<Set<ICodeRename>> updater) {
        JadxProject project = this.mainWindow.getProject();
        JadxCodeData codeData = project.getCodeData();
        if (codeData == null) {
            codeData = new JadxCodeData();
        }
        HashSet set = new HashSet(codeData.getRenames());
        updater.accept(set);
        ArrayList list = new ArrayList(set);
        Collections.sort(list);
        codeData.setRenames(list);
        project.setCodeData(codeData);
        this.mainWindow.getWrapper().reloadCodeData();
    }

    private void refreshState() {
        this.mainWindow.getWrapper().reInitRenameVisitor();
        JNodeCache nodeCache = this.cache.getNodeCache();
        JavaNode javaNode = this.node.getJavaNode();
        ArrayList<JavaNode> toUpdate = new ArrayList<JavaNode>();
        if (this.source != null && this.source != this.node) {
            toUpdate.add(this.source.getJavaNode());
        }
        if (javaNode != null) {
            toUpdate.add(javaNode);
            toUpdate.addAll(javaNode.getUseIn());
            if (this.node instanceof JMethod) {
                toUpdate.addAll(((JMethod)this.node).getJavaMethod().getOverrideRelatedMethods());
            }
        } else if (this.node instanceof JPackage) {
            this.processPackage(toUpdate);
        } else {
            throw new JadxRuntimeException("Unexpected node type: " + this.node);
        }
        Set<JClass> updatedTopClasses = toUpdate.stream().map(JavaNode::getTopParentClass).map(nodeCache::makeFrom).filter(Objects::nonNull).collect(Collectors.toSet());
        LOG.debug("Classes to update: {}", updatedTopClasses);
        this.refreshTabs(this.mainWindow.getTabbedPane(), updatedTopClasses);
        if (!updatedTopClasses.isEmpty()) {
            this.mainWindow.getBackgroundExecutor().execute("Refreshing", () -> this.refreshClasses(updatedTopClasses), status -> {
                if (status == TaskStatus.CANCEL_BY_MEMORY) {
                    this.mainWindow.showHeapUsageBar();
                    UiUtils.errorMessage(this, NLS.str("message.memoryLow"));
                }
                if (this.node instanceof JPackage) {
                    this.mainWindow.getTreeRoot().update();
                }
                this.mainWindow.reloadTree();
            });
        }
    }

    private void processPackage(List<JavaNode> toUpdate) {
        String rawFullPkg = ((JPackage)this.node).getFullName();
        String rawFullPkgDot = rawFullPkg + ".";
        for (JavaClass cls : this.mainWindow.getWrapper().getClasses()) {
            String clsPkg = cls.getClassNode().getClassInfo().getPackage();
            if (!clsPkg.equals(rawFullPkg) && !clsPkg.startsWith(rawFullPkgDot)) continue;
            toUpdate.add((JavaNode)cls);
            toUpdate.addAll(cls.getUseIn());
        }
    }

    private void refreshClasses(Set<JClass> updatedTopClasses) {
        if (updatedTopClasses.size() < 10) {
            LOG.debug("Classes to reload: {}", (Object)updatedTopClasses.size());
            for (JClass cls : updatedTopClasses) {
                try {
                    cls.reload(this.cache);
                }
                catch (Exception e) {
                    LOG.error("Failed to reload class: {}", (Object)cls.getFullName(), (Object)e);
                }
            }
        } else {
            LOG.debug("Classes to unload: {}", (Object)updatedTopClasses.size());
            for (JClass cls : updatedTopClasses) {
                try {
                    cls.unload(this.cache);
                }
                catch (Exception e) {
                    LOG.error("Failed to unload class: {}", (Object)cls.getFullName(), (Object)e);
                }
            }
        }
    }

    private void refreshTabs(TabbedPane tabbedPane, Set<JClass> updatedClasses) {
        for (Map.Entry<JNode, ContentPanel> entry : tabbedPane.getOpenTabs().entrySet()) {
            JClass rootClass = entry.getKey().getRootClass();
            if (!updatedClasses.remove(rootClass)) continue;
            ClassCodeContentPanel contentPanel = (ClassCodeContentPanel)entry.getValue();
            CodeArea codeArea = (CodeArea)contentPanel.getJavaCodePanel().getCodeArea();
            codeArea.refreshClass();
        }
    }

    @NotNull
    protected JPanel initButtonsPanel() {
        JButton cancelButton = new JButton(NLS.str("search_dialog.cancel"));
        cancelButton.addActionListener(event -> this.dispose());
        this.renameBtn = new JButton(NLS.str("common_dialog.ok"));
        this.renameBtn.addActionListener(event -> this.rename());
        this.getRootPane().setDefaultButton(this.renameBtn);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(this.renameBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        return buttonPane;
    }

    private void initUI() {
        JLabel lbl = new JLabel(NLS.str("popup.rename"));
        JLabel nodeLabel = new JLabel(this.node.makeLongStringHtml(), this.node.getIcon(), 2);
        lbl.setLabelFor(nodeLabel);
        this.renameField = new JTextField(40);
        this.renameField.getDocument().addDocumentListener(new DocumentUpdateListener(ev -> this.checkNewName()));
        this.renameField.addActionListener(e -> this.rename());
        new TextStandardActions(this.renameField);
        JPanel renamePane = new JPanel();
        renamePane.setLayout(new FlowLayout(0));
        renamePane.add(lbl);
        renamePane.add(nodeLabel);
        renamePane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel textPane = new JPanel();
        textPane.setLayout(new BoxLayout(textPane, 3));
        textPane.add(Box.createRigidArea(new Dimension(0, 5)));
        textPane.add(this.renameField);
        textPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = this.initButtonsPanel();
        Container contentPane = this.getContentPane();
        contentPane.add((Component)renamePane, "First");
        contentPane.add((Component)textPane, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.setTitle(NLS.str("popup.rename"));
        if (!this.mainWindow.getSettings().loadWindowPos(this)) {
            this.setSize(800, 80);
        }
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        UiUtils.addEscapeShortCutToDispose(this);
    }

    @Override
    public void dispose() {
        this.mainWindow.getSettings().saveWindowPos(this);
        super.dispose();
    }
}

