/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import jadx.api.plugins.utils.CommonFileUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.files.FileUtils;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jetbrains.annotations.Nullable;

public class FileDialog {
    private final MainWindow mainWindow;
    private boolean isOpen;
    private String title;
    private List<String> fileExtList;
    private int selectionMode = 2;
    @Nullable
    private Path currentDir;
    @Nullable
    private Path selectedFile;

    public FileDialog(MainWindow mainWindow, OpenMode mode) {
        this.mainWindow = mainWindow;
        this.initForMode(mode);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setFileExtList(List<String> fileExtList) {
        this.fileExtList = fileExtList;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public void setSelectedFile(Path path) {
        this.selectedFile = path;
    }

    public void setCurrentDir(Path currentDir) {
        this.currentDir = currentDir;
    }

    public List<Path> show() {
        int ret;
        FileChooser fileChooser = this.buildFileChooser();
        int n = ret = this.isOpen ? fileChooser.showOpenDialog(this.mainWindow) : fileChooser.showSaveDialog(this.mainWindow);
        if (ret != 0) {
            return Collections.emptyList();
        }
        this.currentDir = fileChooser.getCurrentDirectory().toPath();
        File[] selectedFiles = fileChooser.getSelectedFiles();
        if (selectedFiles.length != 0) {
            return FileUtils.toPaths((File[])selectedFiles);
        }
        File chosenFile = fileChooser.getSelectedFile();
        if (chosenFile != null) {
            return Collections.singletonList(chosenFile.toPath());
        }
        return Collections.emptyList();
    }

    public Path getCurrentDir() {
        return this.currentDir;
    }

    private void initForMode(OpenMode mode) {
        switch (mode) {
            case OPEN: 
            case OPEN_PROJECT: 
            case ADD: {
                if (mode == OpenMode.OPEN_PROJECT) {
                    this.fileExtList = Collections.singletonList("jadx");
                    this.title = NLS.str("file.open_title");
                } else {
                    this.fileExtList = new ArrayList<String>(Arrays.asList("apk", "dex", "jar", "class", "smali", "zip", "xapk", "aar", "arsc"));
                    if (mode == OpenMode.OPEN) {
                        this.fileExtList.addAll(Arrays.asList("jadx", "aab"));
                        this.title = NLS.str("file.open_title");
                    } else {
                        this.title = NLS.str("file.add_files_action");
                    }
                }
                this.selectionMode = 2;
                this.currentDir = this.mainWindow.getSettings().getLastOpenFilePath();
                this.isOpen = true;
                break;
            }
            case SAVE_PROJECT: {
                this.title = NLS.str("file.save_project");
                this.fileExtList = Collections.singletonList("jadx");
                this.selectionMode = 0;
                this.currentDir = this.mainWindow.getSettings().getLastSaveFilePath();
                this.isOpen = false;
                break;
            }
            case EXPORT: {
                this.title = NLS.str("file.save_all_msg");
                this.fileExtList = Collections.emptyList();
                this.selectionMode = 1;
                this.currentDir = this.mainWindow.getSettings().getLastSaveFilePath();
                this.isOpen = false;
                break;
            }
            case CUSTOM_SAVE: {
                this.isOpen = false;
                break;
            }
            case CUSTOM_OPEN: {
                this.isOpen = true;
            }
        }
    }

    private FileChooser buildFileChooser() {
        FileChooser fileChooser = new FileChooser(this.currentDir);
        fileChooser.setToolTipText(this.title);
        fileChooser.setFileSelectionMode(this.selectionMode);
        fileChooser.setMultiSelectionEnabled(this.isOpen);
        fileChooser.setAcceptAllFileFilterUsed(true);
        if (Utils.notEmpty(this.fileExtList)) {
            String description = NLS.str("file_dialog.supported_files") + ": (" + Utils.listToString(this.fileExtList) + ')';
            fileChooser.setFileFilter(new FileNameExtensionFilter(description, this.fileExtList.toArray(new String[0])));
        }
        if (this.selectedFile != null) {
            fileChooser.setSelectedFile(this.selectedFile.toFile());
        }
        return fileChooser;
    }

    public static enum OpenMode {
        OPEN,
        OPEN_PROJECT,
        ADD,
        SAVE_PROJECT,
        EXPORT,
        CUSTOM_SAVE,
        CUSTOM_OPEN;

    }

    private class FileChooser
    extends JFileChooser {
        public FileChooser(Path currentDirectory) {
            super(currentDirectory == null ? CommonFileUtils.CWD : currentDirectory.toFile());
        }

        @Override
        protected JDialog createDialog(Component parent) throws HeadlessException {
            final JDialog dialog = super.createDialog(parent);
            dialog.setTitle(FileDialog.this.title);
            dialog.setLocationRelativeTo(null);
            FileDialog.this.mainWindow.getSettings().loadWindowPos(dialog);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    FileDialog.this.mainWindow.getSettings().saveWindowPos(dialog);
                    super.windowClosed(e);
                }
            });
            return dialog;
        }

        @Override
        public void approveSelection() {
            int option;
            File currentFile;
            if (FileDialog.this.selectionMode == 2 && (currentFile = this.getSelectedFile()).isDirectory() && (option = JOptionPane.showConfirmDialog(FileDialog.this.mainWindow, NLS.str("file_dialog.load_dir_confirm") + "\n " + currentFile, NLS.str("file_dialog.load_dir_title"), 0)) != 0) {
                this.setCurrentDirectory(currentFile);
                this.updateUI();
                return;
            }
            super.approveSelection();
        }
    }
}

