/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import ch.qos.logback.classic.Level;
import io.reactivex.internal.functions.Functions;
import jadx.api.JadxArgs;
import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.ResourceFile;
import jadx.api.plugins.utils.CommonFileUtils;
import jadx.core.Jadx;
import jadx.core.utils.ListUtils;
import jadx.core.utils.StringUtils;
import jadx.core.utils.files.FileUtils;
import jadx.gui.JadxWrapper;
import jadx.gui.device.debugger.BreakpointManager;
import jadx.gui.jobs.BackgroundExecutor;
import jadx.gui.jobs.DecompileTask;
import jadx.gui.jobs.ExportTask;
import jadx.gui.jobs.ProcessResult;
import jadx.gui.jobs.TaskStatus;
import jadx.gui.plugins.mappings.MappingExporter;
import jadx.gui.plugins.quark.QuarkDialog;
import jadx.gui.settings.JadxProject;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsWindow;
import jadx.gui.treemodel.ApkSignature;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JField;
import jadx.gui.treemodel.JLoadableNode;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JPackage;
import jadx.gui.treemodel.JResource;
import jadx.gui.treemodel.JRoot;
import jadx.gui.ui.ExceptionDialog;
import jadx.gui.ui.HeapUsageBar;
import jadx.gui.ui.MainDropTarget;
import jadx.gui.ui.TabbedPane;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.AbstractCodeContentPanel;
import jadx.gui.ui.codearea.EditorTheme;
import jadx.gui.ui.codearea.EditorViewState;
import jadx.gui.ui.dialog.ADBDialog;
import jadx.gui.ui.dialog.AboutDialog;
import jadx.gui.ui.dialog.FileDialog;
import jadx.gui.ui.dialog.LogViewerDialog;
import jadx.gui.ui.dialog.RenameDialog;
import jadx.gui.ui.dialog.SearchDialog;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.panel.IssuesPanel;
import jadx.gui.ui.panel.JDebuggerPanel;
import jadx.gui.ui.panel.ProgressPanel;
import jadx.gui.ui.popupmenu.JPackagePopupMenu;
import jadx.gui.ui.treenodes.StartPageNode;
import jadx.gui.ui.treenodes.SummaryNode;
import jadx.gui.update.JadxUpdate;
import jadx.gui.update.data.Release;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.FontUtils;
import jadx.gui.utils.ILoadListener;
import jadx.gui.utils.Icons;
import jadx.gui.utils.LafManager;
import jadx.gui.utils.Link;
import jadx.gui.utils.NLS;
import jadx.gui.utils.SystemInfo;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.fileswatcher.LiveReloadWorker;
import jadx.gui.utils.logs.LogCollector;
import jadx.gui.utils.ui.ActionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.fabricmc.mappingio.format.MappingFormat;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainWindow
extends JFrame {
    private static final Logger LOG = LoggerFactory.getLogger(MainWindow.class);
    private static final String DEFAULT_TITLE = "jadx-gui";
    private static final double BORDER_RATIO = 0.15;
    private static final double WINDOW_RATIO = 0.7;
    public static final double SPLIT_PANE_RESIZE_WEIGHT = 0.15;
    private static final ImageIcon ICON_ADD_FILES = UiUtils.openSvgIcon("ui/addFile");
    private static final ImageIcon ICON_SAVE_ALL = UiUtils.openSvgIcon("ui/menu-saveall");
    private static final ImageIcon ICON_RELOAD = UiUtils.openSvgIcon("ui/refresh");
    private static final ImageIcon ICON_EXPORT = UiUtils.openSvgIcon("ui/export");
    private static final ImageIcon ICON_EXIT = UiUtils.openSvgIcon("ui/exit");
    private static final ImageIcon ICON_SYNC = UiUtils.openSvgIcon("ui/pagination");
    private static final ImageIcon ICON_FLAT_PKG = UiUtils.openSvgIcon("ui/moduleGroup");
    private static final ImageIcon ICON_SEARCH = UiUtils.openSvgIcon("ui/find");
    private static final ImageIcon ICON_FIND = UiUtils.openSvgIcon("ui/ejbFinderMethod");
    private static final ImageIcon ICON_COMMENT_SEARCH = UiUtils.openSvgIcon("ui/usagesFinder");
    private static final ImageIcon ICON_BACK = UiUtils.openSvgIcon("ui/left");
    private static final ImageIcon ICON_FORWARD = UiUtils.openSvgIcon("ui/right");
    private static final ImageIcon ICON_QUARK = UiUtils.openSvgIcon("ui/quark");
    private static final ImageIcon ICON_PREF = UiUtils.openSvgIcon("ui/settings");
    private static final ImageIcon ICON_DEOBF = UiUtils.openSvgIcon("ui/helmChartLock");
    private static final ImageIcon ICON_LOG = UiUtils.openSvgIcon("ui/logVerbose");
    private static final ImageIcon ICON_INFO = UiUtils.openSvgIcon("ui/showInfos");
    private static final ImageIcon ICON_DEBUGGER = UiUtils.openSvgIcon("ui/startDebugger");
    private final transient JadxWrapper wrapper;
    private final transient JadxSettings settings;
    private final transient CacheObject cacheObject;
    private final transient BackgroundExecutor backgroundExecutor;
    @NotNull
    private transient JadxProject project;
    private transient Action newProjectAction;
    private transient Action saveProjectAction;
    private transient JMenu exportMappingsMenu;
    private JPanel mainPanel;
    private JSplitPane splitPane;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private JRoot treeRoot;
    private TabbedPane tabbedPane;
    private HeapUsageBar heapUsageBar;
    private transient boolean treeReloading;
    private boolean isFlattenPackage;
    private JToggleButton flatPkgButton;
    private JCheckBoxMenuItem flatPkgMenuItem;
    private JToggleButton deobfToggleBtn;
    private JCheckBoxMenuItem deobfMenuItem;
    private JCheckBoxMenuItem liveReloadMenuItem;
    private final LiveReloadWorker liveReloadWorker;
    private transient Link updateLink;
    private transient ProgressPanel progressPane;
    private transient Theme editorTheme;
    private JDebuggerPanel debuggerPanel;
    private JSplitPane verticalSplitter;
    private List<ILoadListener> loadListeners = new ArrayList<ILoadListener>();
    private boolean loaded;
    private static final Object DECOMPILER_TASK_SYNC = new Object();

    public MainWindow(JadxSettings settings) {
        this.settings = settings;
        this.cacheObject = new CacheObject();
        this.project = new JadxProject(this);
        this.wrapper = new JadxWrapper(this);
        this.liveReloadWorker = new LiveReloadWorker(this);
        this.resetCache();
        FontUtils.registerBundledFonts();
        this.initUI();
        this.backgroundExecutor = new BackgroundExecutor(settings, this.progressPane);
        this.initMenuAndToolbar();
        this.registerMouseNavigationButtons();
        UiUtils.setWindowIcons(this);
        this.loadSettings();
        this.update();
        this.checkForUpdate();
    }

    public void init() {
        this.pack();
        this.setLocationAndPosition();
        this.splitPane.setDividerLocation(this.settings.getTreeWidth());
        this.heapUsageBar.setVisible(this.settings.isShowHeapUsageBar());
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.closeWindow();
            }
        });
        this.processCommandLineArgs();
    }

    private void processCommandLineArgs() {
        if (this.settings.getFiles().isEmpty()) {
            this.tabbedPane.showNode(new StartPageNode());
        } else {
            this.open(FileUtils.fileNamesToPaths((List)this.settings.getFiles()), this::handleSelectClassOption);
        }
    }

    private void handleSelectClassOption() {
        if (this.settings.getCmdSelectClass() != null) {
            JavaClass javaNode = this.wrapper.searchJavaClassByFullAlias(this.settings.getCmdSelectClass());
            if (javaNode == null) {
                javaNode = this.wrapper.searchJavaClassByOrigClassName(this.settings.getCmdSelectClass());
            }
            if (javaNode == null) {
                JOptionPane.showMessageDialog(this, NLS.str("msg.cmd_select_class_error", this.settings.getCmdSelectClass()), NLS.str("error_dialog.title"), 0);
                return;
            }
            this.tabbedPane.codeJump(this.cacheObject.getNodeCache().makeFrom((JavaNode)javaNode));
        }
    }

    private void checkForUpdate() {
        if (!this.settings.isCheckForUpdates()) {
            return;
        }
        JadxUpdate.check(new JadxUpdate.IUpdateCallback(){

            @Override
            public void onUpdate(Release r) {
                SwingUtilities.invokeLater(() -> {
                    MainWindow.this.updateLink.setText(NLS.str("menu.update_label", r.getName()));
                    MainWindow.this.updateLink.setVisible(true);
                });
            }
        });
    }

    public void openFileDialog() {
        this.showOpenDialog(FileDialog.OpenMode.OPEN);
    }

    public void openProjectDialog() {
        this.showOpenDialog(FileDialog.OpenMode.OPEN_PROJECT);
    }

    private void showOpenDialog(FileDialog.OpenMode mode) {
        this.saveAll();
        if (!this.ensureProjectIsSaved()) {
            return;
        }
        FileDialog fileDialog = new FileDialog(this, mode);
        List<Path> openPaths = fileDialog.show();
        if (!openPaths.isEmpty()) {
            this.settings.setLastOpenFilePath(fileDialog.getCurrentDir());
            this.open(openPaths);
        }
    }

    public void addFiles() {
        FileDialog fileDialog = new FileDialog(this, FileDialog.OpenMode.ADD);
        List<Path> addPaths = fileDialog.show();
        if (!addPaths.isEmpty()) {
            this.addFiles(addPaths);
        }
    }

    public void addFiles(List<Path> addPaths) {
        this.project.setFilePaths(ListUtils.distinctMergeSortedLists(addPaths, this.project.getFilePaths()));
        this.reopen();
    }

    private void newProject() {
        this.saveAll();
        if (!this.ensureProjectIsSaved()) {
            return;
        }
        this.closeAll();
        this.exportMappingsMenu.setEnabled(false);
        this.updateProject(new JadxProject(this));
    }

    private void saveProject() {
        if (!this.project.isSaveFileSelected()) {
            this.saveProjectAs();
        } else {
            this.project.save();
            this.update();
        }
    }

    private void saveProjectAs() {
        int res;
        List<Path> saveFiles;
        FileDialog fileDialog = new FileDialog(this, FileDialog.OpenMode.SAVE_PROJECT);
        if (this.project.getFilePaths().size() == 1) {
            Path projectPath = MainWindow.getProjectPathForFile(this.project.getFilePaths().get(0));
            fileDialog.setSelectedFile(projectPath);
        }
        if ((saveFiles = fileDialog.show()).isEmpty()) {
            return;
        }
        this.settings.setLastSaveProjectPath(fileDialog.getCurrentDir());
        Path savePath = saveFiles.get(0);
        if (!savePath.getFileName().toString().toLowerCase(Locale.ROOT).endsWith("jadx")) {
            savePath = savePath.resolveSibling(savePath.getFileName() + "." + "jadx");
        }
        if (Files.exists(savePath, new LinkOption[0]) && (res = JOptionPane.showConfirmDialog(this, NLS.str("confirm.save_as_message", savePath.getFileName()), NLS.str("confirm.save_as_title"), 0)) == 1) {
            return;
        }
        this.project.saveAs(savePath);
        this.settings.addRecentProject(savePath);
        this.update();
    }

    private void exportMappings(MappingFormat mappingFormat) {
        Path baseDir;
        FileDialog fileDialog = new FileDialog(this, FileDialog.OpenMode.CUSTOM_SAVE);
        fileDialog.setTitle(NLS.str("file.export_mappings_as"));
        Path workingDir = this.project.getWorkingDir();
        Path path = baseDir = workingDir != null ? workingDir : this.settings.getLastSaveFilePath();
        if (mappingFormat.hasSingleFile()) {
            fileDialog.setSelectedFile(baseDir.resolve("mappings." + mappingFormat.fileExt));
            fileDialog.setFileExtList(Collections.singletonList(mappingFormat.fileExt));
            fileDialog.setSelectionMode(0);
        } else {
            fileDialog.setCurrentDir(baseDir);
            fileDialog.setSelectionMode(1);
        }
        List<Path> paths = fileDialog.show();
        if (paths.size() != 1) {
            return;
        }
        Path savePath = paths.get(0);
        LOG.info("Export mappings to: {}", (Object)savePath.toAbsolutePath());
        this.backgroundExecutor.execute(NLS.str("progress.export_mappings"), () -> new MappingExporter(this.wrapper.getDecompiler().getRoot()).exportMappings(savePath, this.project.getCodeData(), mappingFormat), s -> this.update());
    }

    public void open(Path path) {
        this.open(Collections.singletonList(path), Functions.EMPTY_RUNNABLE);
    }

    public void open(List<Path> paths) {
        this.open(paths, Functions.EMPTY_RUNNABLE);
    }

    private void open(List<Path> paths, Runnable onFinish) {
        this.saveAll();
        this.closeAll();
        if (paths.size() == 1 && this.openSingleFile(paths.get(0), onFinish)) {
            return;
        }
        this.project = new JadxProject(this);
        this.project.setFilePaths(paths);
        this.loadFiles(onFinish);
    }

    private boolean openSingleFile(Path singleFile, Runnable onFinish) {
        String fileExtension = CommonFileUtils.getFileExtension((String)singleFile.getFileName().toString());
        if (fileExtension != null && fileExtension.equalsIgnoreCase("jadx")) {
            this.openProject(singleFile, onFinish);
            return true;
        }
        Path projectPath = MainWindow.getProjectPathForFile(singleFile);
        if (Files.exists(projectPath, new LinkOption[0])) {
            LOG.info("Loading project {}", (Object)projectPath);
            this.openProject(projectPath, onFinish);
            return true;
        }
        return false;
    }

    private static Path getProjectPathForFile(Path loadedFile) {
        String fileName = loadedFile.getFileName() + "." + "jadx";
        return loadedFile.resolveSibling(fileName);
    }

    public synchronized void reopen() {
        this.saveAll();
        this.closeAll();
        this.loadFiles(Functions.EMPTY_RUNNABLE);
    }

    private void openProject(Path path, Runnable onFinish) {
        JadxProject jadxProject = JadxProject.load(this, path);
        if (jadxProject == null) {
            JOptionPane.showMessageDialog(this, NLS.str("msg.project_error"), NLS.str("msg.project_error_title"), 1);
            jadxProject = new JadxProject(this);
        }
        this.settings.addRecentProject(path);
        this.project = jadxProject;
        this.loadFiles(onFinish);
    }

    private void loadFiles(Runnable onFinish) {
        this.exportMappingsMenu.setEnabled(false);
        if (this.project.getFilePaths().isEmpty()) {
            return;
        }
        this.backgroundExecutor.execute(NLS.str("progress.load"), this.wrapper::open, status -> {
            if (status == TaskStatus.CANCEL_BY_MEMORY) {
                this.showHeapUsageBar();
                UiUtils.errorMessage(this, NLS.str("message.memoryLow"));
                return;
            }
            if (status != TaskStatus.COMPLETE) {
                LOG.warn("Loading task incomplete, status: {}", (Object)status);
                return;
            }
            this.checkLoadedStatus();
            this.onOpen();
            this.exportMappingsMenu.setEnabled(true);
            onFinish.run();
        });
    }

    private void saveAll() {
        this.saveOpenTabs();
        BreakpointManager.saveAndExit();
    }

    private void closeAll() {
        this.notifyLoadListeners(false);
        this.cancelBackgroundJobs();
        this.clearTree();
        this.resetCache();
        LogCollector.getInstance().reset();
        this.wrapper.close();
        this.tabbedPane.closeAllTabs();
        UiUtils.resetClipboardOwner();
        System.gc();
    }

    private void checkLoadedStatus() {
        if (!this.wrapper.getClasses().isEmpty()) {
            return;
        }
        int errors = LogCollector.getInstance().getErrors();
        if (errors > 0) {
            int result = JOptionPane.showConfirmDialog(this, NLS.str("message.load_errors", errors), NLS.str("message.errorTitle"), 2, 0);
            if (result == 0) {
                LogViewerDialog.openWithLevel(this, Level.ERROR);
            }
        } else {
            UiUtils.showMessageBox(this, NLS.str("message.no_classes"));
        }
    }

    private void onOpen() {
        this.deobfToggleBtn.setSelected(this.settings.isDeobfuscationOn());
        this.initTree();
        this.update();
        this.updateLiveReload(this.project.isEnableLiveReload());
        BreakpointManager.init(this.project.getFilePaths().get(0).toAbsolutePath().getParent());
        this.backgroundExecutor.execute(NLS.str("progress.load"), this::restoreOpenTabs, status -> {
            this.runInitialBackgroundJobs();
            this.notifyLoadListeners(true);
        });
    }

    public void updateLiveReload(boolean state) {
        if (this.liveReloadWorker.isStarted() == state) {
            return;
        }
        this.project.setEnableLiveReload(state);
        this.liveReloadMenuItem.setEnabled(false);
        this.backgroundExecutor.execute((state ? "Starting" : "Stopping") + " live reload", () -> this.liveReloadWorker.updateState(state), s -> {
            this.liveReloadMenuItem.setState(state);
            this.liveReloadMenuItem.setEnabled(true);
        });
    }

    private void addTreeCustomNodes() {
        this.treeRoot.replaceCustomNode(ApkSignature.getApkSignature(this.wrapper));
        this.treeRoot.replaceCustomNode(new SummaryNode(this));
    }

    private boolean ensureProjectIsSaved() {
        if (!this.project.isSaved() && !this.project.isInitial()) {
            int res = JOptionPane.showConfirmDialog(this, NLS.str("confirm.not_saved_message"), NLS.str("confirm.not_saved_title"), 1);
            if (res == 2) {
                return false;
            }
            if (res == 0) {
                this.saveProject();
            }
        }
        return true;
    }

    public void updateProject(@NotNull JadxProject jadxProject) {
        this.project = jadxProject;
        this.update();
    }

    private void update() {
        this.newProjectAction.setEnabled(!this.project.isInitial());
        this.saveProjectAction.setEnabled(!this.project.isSaved());
        Path projectPath = this.project.getProjectPath();
        String pathString = projectPath == null ? "" : " [" + projectPath.toAbsolutePath().getParent() + ']';
        this.setTitle((this.project.isSaved() ? "" : Character.valueOf('*')) + this.project.getName() + pathString + " - " + DEFAULT_TITLE);
    }

    protected void resetCache() {
        this.cacheObject.reset();
    }

    synchronized void runInitialBackgroundJobs() {
        if (this.settings.isAutoStartJobs()) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    MainWindow.this.waitDecompileTask();
                }
            }, 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitDecompileTask() {
        Object object = DECOMPILER_TASK_SYNC;
        synchronized (object) {
            try {
                DecompileTask decompileTask = new DecompileTask(this.wrapper);
                this.backgroundExecutor.executeAndWait(decompileTask);
                this.backgroundExecutor.execute(decompileTask.getTitle(), this.wrapper::unloadClasses).get();
                this.processDecompilationResults(decompileTask.getResult());
                System.gc();
            }
            catch (Exception e) {
                LOG.error("Decompile task execution failed", (Throwable)e);
            }
        }
    }

    private void processDecompilationResults(ProcessResult decompile) {
        int skippedCls = decompile.getSkipped();
        if (skippedCls == 0) {
            return;
        }
        TaskStatus status = decompile.getStatus();
        LOG.warn("Decompile and indexing of some classes skipped: {}, status: {}", (Object)skippedCls, (Object)status);
        switch (status) {
            case CANCEL_BY_USER: {
                String reason = NLS.str("message.userCancelTask");
                String message = NLS.str("message.indexIncomplete", reason, skippedCls);
                JOptionPane.showMessageDialog(this, message);
                break;
            }
            case CANCEL_BY_TIMEOUT: {
                String reason = NLS.str("message.taskTimeout", decompile.getTimeLimit());
                String message = NLS.str("message.indexIncomplete", reason, skippedCls);
                JOptionPane.showMessageDialog(this, message);
                break;
            }
            case CANCEL_BY_MEMORY: {
                this.showHeapUsageBar();
                JOptionPane.showMessageDialog(this, NLS.str("message.indexingClassesSkipped", skippedCls));
            }
        }
    }

    public void cancelBackgroundJobs() {
        this.backgroundExecutor.cancelAll();
    }

    private void saveAll(boolean export) {
        FileDialog fileDialog = new FileDialog(this, FileDialog.OpenMode.EXPORT);
        List<Path> saveDirs = fileDialog.show();
        if (saveDirs.isEmpty()) {
            return;
        }
        JadxArgs decompilerArgs = this.wrapper.getArgs();
        decompilerArgs.setExportAsGradleProject(export);
        if (export) {
            decompilerArgs.setSkipSources(false);
            decompilerArgs.setSkipResources(false);
        } else {
            decompilerArgs.setSkipSources(this.settings.isSkipSources());
            decompilerArgs.setSkipResources(this.settings.isSkipResources());
        }
        this.settings.setLastSaveFilePath(fileDialog.getCurrentDir());
        this.backgroundExecutor.execute(new ExportTask(this, this.wrapper, saveDirs.get(0).toFile()));
    }

    public void initTree() {
        this.treeRoot = new JRoot(this.wrapper);
        this.treeRoot.setFlatPackages(this.isFlattenPackage);
        this.treeModel.setRoot(this.treeRoot);
        this.addTreeCustomNodes();
        this.treeRoot.update();
        this.reloadTree();
    }

    private void clearTree() {
        this.tabbedPane.reset();
        this.treeRoot = null;
        this.treeModel.setRoot(null);
        this.treeModel.reload();
    }

    public void reloadTree() {
        this.treeReloading = true;
        this.treeModel.reload();
        List<String[]> treeExpansions = this.project.getTreeExpansions();
        if (!treeExpansions.isEmpty()) {
            this.expand(this.treeRoot, treeExpansions);
        } else {
            this.tree.expandRow(1);
        }
        this.treeReloading = false;
    }

    private void expand(TreeNode node, List<String[]> treeExpansions) {
        Object[] pathNodes = this.treeModel.getPathToRoot(node);
        if (pathNodes == null) {
            return;
        }
        TreePath path = new TreePath(pathNodes);
        for (Object[] objectArray : treeExpansions) {
            if (!Arrays.equals(objectArray, MainWindow.getPathExpansion(path))) continue;
            this.tree.expandPath(path);
            break;
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            this.expand(node.getChildAt(i), treeExpansions);
        }
    }

    private void toggleFlattenPackage() {
        this.setFlattenPackage(!this.isFlattenPackage);
    }

    private void setFlattenPackage(boolean value) {
        this.isFlattenPackage = value;
        this.settings.setFlattenPackage(this.isFlattenPackage);
        this.flatPkgButton.setSelected(this.isFlattenPackage);
        this.flatPkgMenuItem.setState(this.isFlattenPackage);
        Object root = this.treeModel.getRoot();
        if (root instanceof JRoot) {
            JRoot treeRoot = (JRoot)root;
            treeRoot.setFlatPackages(this.isFlattenPackage);
            this.reloadTree();
        }
    }

    private void toggleDeobfuscation() {
        boolean deobfOn = !this.settings.isDeobfuscationOn();
        this.settings.setDeobfuscationOn(deobfOn);
        this.settings.sync();
        this.deobfToggleBtn.setSelected(deobfOn);
        this.deobfMenuItem.setState(deobfOn);
        this.reopen();
    }

    private boolean nodeClickAction(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            if (obj instanceof JResource) {
                JResource res = (JResource)obj;
                ResourceFile resFile = res.getResFile();
                if (resFile != null && JResource.isSupportedForView(resFile.getType())) {
                    return this.tabbedPane.showNode(res);
                }
            } else if (obj instanceof JNode) {
                JNode node = (JNode)obj;
                if (node.getRootClass() != null) {
                    this.tabbedPane.codeJump(node);
                    return true;
                }
                return this.tabbedPane.showNode(node);
            }
        }
        catch (Exception e) {
            LOG.error("Content loading error", (Throwable)e);
        }
        return false;
    }

    private void treeRightClickAction(MouseEvent e) {
        JNode obj = this.getJNodeUnderMouse(e);
        if (obj instanceof JPackage) {
            JPackagePopupMenu menu = new JPackagePopupMenu(this, (JPackage)obj);
            menu.show(e.getComponent(), e.getX(), e.getY());
        } else if (obj instanceof JClass || obj instanceof JField || obj instanceof JMethod) {
            JMenuItem jmi = new JMenuItem(NLS.str("popup.rename"));
            jmi.addActionListener(action -> RenameDialog.rename(this, obj));
            JPopupMenu menu = new JPopupMenu();
            menu.add(jmi);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Nullable
    private JNode getJNodeUnderMouse(MouseEvent mouseEvent) {
        Object obj;
        TreePath path = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (path == null) {
            return null;
        }
        Rectangle pathBounds = this.tree.getPathBounds(path);
        if (pathBounds != null) {
            int y = mouseEvent.getY();
            if (y < pathBounds.y || y > pathBounds.y + pathBounds.height) {
                return null;
            }
            if (mouseEvent.getX() < pathBounds.x) {
                return null;
            }
        }
        if ((obj = path.getLastPathComponent()) instanceof JNode) {
            this.tree.setSelectionPath(path);
            return (JNode)obj;
        }
        return null;
    }

    public void syncWithEditor() {
        ContentPanel selectedContentPanel = this.tabbedPane.getSelectedCodePanel();
        if (selectedContentPanel == null) {
            return;
        }
        JNode node = selectedContentPanel.getNode();
        if (node.getParent() == null && this.treeRoot != null && (node = this.treeRoot.searchNode(node)) == null) {
            LOG.error("Class not found in tree");
            return;
        }
        Object[] pathNodes = this.treeModel.getPathToRoot(node);
        if (pathNodes == null) {
            return;
        }
        TreePath path = new TreePath(pathNodes);
        this.tree.setSelectionPath(path);
        this.tree.makeVisible(path);
        this.tree.scrollPathToVisible(path);
        this.tree.requestFocus();
    }

    private void initMenuAndToolbar() {
        ActionHandler openAction = new ActionHandler(this::openFileDialog);
        openAction.setNameAndDesc(NLS.str("file.open_action"));
        openAction.setIcon(Icons.OPEN);
        openAction.setKeyBinding(KeyStroke.getKeyStroke(79, UiUtils.ctrlButton()));
        ActionHandler openProject = new ActionHandler(this::openProjectDialog);
        openProject.setNameAndDesc(NLS.str("file.open_project"));
        openProject.setIcon(Icons.OPEN_PROJECT);
        openProject.setKeyBinding(KeyStroke.getKeyStroke(79, 0x40 | UiUtils.ctrlButton()));
        AbstractAction addFilesAction = new AbstractAction(NLS.str("file.add_files_action"), ICON_ADD_FILES){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.addFiles();
            }
        };
        addFilesAction.putValue("ShortDescription", NLS.str("file.add_files_action"));
        this.newProjectAction = new AbstractAction(NLS.str("file.new_project"), Icons.NEW_PROJECT){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.newProject();
            }
        };
        this.newProjectAction.putValue("ShortDescription", NLS.str("file.new_project"));
        this.saveProjectAction = new AbstractAction(NLS.str("file.save_project")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveProject();
            }
        };
        this.saveProjectAction.putValue("ShortDescription", NLS.str("file.save_project"));
        AbstractAction saveProjectAsAction = new AbstractAction(NLS.str("file.save_project_as")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveProjectAs();
            }
        };
        saveProjectAsAction.putValue("ShortDescription", NLS.str("file.save_project_as"));
        ActionHandler reload = new ActionHandler(ev -> UiUtils.uiRun(this::reopen));
        reload.setNameAndDesc(NLS.str("file.reload"));
        reload.setIcon(ICON_RELOAD);
        reload.setKeyBinding(KeyStroke.getKeyStroke(116, 0));
        ActionHandler liveReload = new ActionHandler(ev -> this.updateLiveReload(!this.project.isEnableLiveReload()));
        liveReload.setName(NLS.str("file.live_reload"));
        liveReload.setShortDescription(NLS.str("file.live_reload_desc"));
        liveReload.setKeyBinding(KeyStroke.getKeyStroke(116, 64));
        this.liveReloadMenuItem = new JCheckBoxMenuItem(liveReload);
        this.liveReloadMenuItem.setState(this.project.isEnableLiveReload());
        AbstractAction exportMappingsAsTiny2 = new AbstractAction("Tiny v2 file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.exportMappings(MappingFormat.TINY_2);
            }
        };
        exportMappingsAsTiny2.putValue("ShortDescription", "Tiny v2 file");
        AbstractAction exportMappingsAsEnigma = new AbstractAction("Enigma file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.exportMappings(MappingFormat.ENIGMA);
            }
        };
        exportMappingsAsEnigma.putValue("ShortDescription", "Enigma file");
        AbstractAction exportMappingsAsEnigmaDir = new AbstractAction("Enigma directory"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.exportMappings(MappingFormat.ENIGMA_DIR);
            }
        };
        exportMappingsAsEnigmaDir.putValue("ShortDescription", "Enigma directory");
        this.exportMappingsMenu = new JMenu(NLS.str("file.export_mappings_as"));
        this.exportMappingsMenu.add(exportMappingsAsTiny2);
        this.exportMappingsMenu.add(exportMappingsAsEnigma);
        this.exportMappingsMenu.add(exportMappingsAsEnigmaDir);
        this.exportMappingsMenu.setEnabled(false);
        AbstractAction saveAllAction = new AbstractAction(NLS.str("file.save_all"), ICON_SAVE_ALL){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveAll(false);
            }
        };
        saveAllAction.putValue("ShortDescription", NLS.str("file.save_all"));
        saveAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, UiUtils.ctrlButton()));
        AbstractAction exportAction = new AbstractAction(NLS.str("file.export_gradle"), ICON_EXPORT){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.saveAll(true);
            }
        };
        exportAction.putValue("ShortDescription", NLS.str("file.export_gradle"));
        exportAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, UiUtils.ctrlButton()));
        JMenu recentProjects = new JMenu(NLS.str("menu.recent_projects"));
        recentProjects.addMenuListener(new RecentProjectsMenuListener(recentProjects));
        AbstractAction prefsAction = new AbstractAction(NLS.str("menu.preferences"), ICON_PREF){

            @Override
            public void actionPerformed(ActionEvent e) {
                new JadxSettingsWindow(MainWindow.this, MainWindow.this.settings).setVisible(true);
            }
        };
        prefsAction.putValue("ShortDescription", NLS.str("menu.preferences"));
        prefsAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, UiUtils.ctrlButton() | 0x40));
        AbstractAction exitAction = new AbstractAction(NLS.str("file.exit"), ICON_EXIT){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.closeWindow();
            }
        };
        this.isFlattenPackage = this.settings.isFlattenPackage();
        this.flatPkgMenuItem = new JCheckBoxMenuItem(NLS.str("menu.flatten"), ICON_FLAT_PKG);
        this.flatPkgMenuItem.setState(this.isFlattenPackage);
        JCheckBoxMenuItem heapUsageBarMenuItem = new JCheckBoxMenuItem(NLS.str("menu.heapUsageBar"));
        heapUsageBarMenuItem.setState(this.settings.isShowHeapUsageBar());
        heapUsageBarMenuItem.addActionListener(event -> {
            this.settings.setShowHeapUsageBar(!this.settings.isShowHeapUsageBar());
            this.heapUsageBar.setVisible(this.settings.isShowHeapUsageBar());
        });
        JCheckBoxMenuItem alwaysSelectOpened = new JCheckBoxMenuItem(NLS.str("menu.alwaysSelectOpened"));
        alwaysSelectOpened.setState(this.settings.isAlwaysSelectOpened());
        alwaysSelectOpened.addActionListener(event -> {
            this.settings.setAlwaysSelectOpened(!this.settings.isAlwaysSelectOpened());
            if (this.settings.isAlwaysSelectOpened()) {
                this.syncWithEditor();
            }
        });
        AbstractAction syncAction = new AbstractAction(NLS.str("menu.sync"), ICON_SYNC){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.syncWithEditor();
            }
        };
        syncAction.putValue("ShortDescription", NLS.str("menu.sync"));
        syncAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, UiUtils.ctrlButton()));
        AbstractAction textSearchAction = new AbstractAction(NLS.str("menu.text_search"), ICON_SEARCH){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContentPanel panel = MainWindow.this.tabbedPane.getSelectedCodePanel();
                if (panel instanceof AbstractCodeContentPanel) {
                    AbstractCodeArea codeArea = ((AbstractCodeContentPanel)panel).getCodeArea();
                    String preferText = codeArea.getSelectedText();
                    if (StringUtils.isEmpty((String)preferText)) {
                        preferText = codeArea.getWordUnderCaret();
                    }
                    if (!StringUtils.isEmpty((String)preferText)) {
                        SearchDialog.searchText(MainWindow.this, preferText);
                        return;
                    }
                }
                SearchDialog.search(MainWindow.this, SearchDialog.SearchPreset.TEXT);
            }
        };
        textSearchAction.putValue("ShortDescription", NLS.str("menu.text_search"));
        textSearchAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, UiUtils.ctrlButton() | 0x40));
        AbstractAction clsSearchAction = new AbstractAction(NLS.str("menu.class_search"), ICON_FIND){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.search(MainWindow.this, SearchDialog.SearchPreset.CLASS);
            }
        };
        clsSearchAction.putValue("ShortDescription", NLS.str("menu.class_search"));
        clsSearchAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, UiUtils.ctrlButton()));
        AbstractAction commentSearchAction = new AbstractAction(NLS.str("menu.comment_search"), ICON_COMMENT_SEARCH){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.search(MainWindow.this, SearchDialog.SearchPreset.COMMENT);
            }
        };
        commentSearchAction.putValue("ShortDescription", NLS.str("menu.comment_search"));
        commentSearchAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(59, UiUtils.ctrlButton() | 0x40));
        AbstractAction deobfAction = new AbstractAction(NLS.str("menu.deobfuscation"), ICON_DEOBF){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.toggleDeobfuscation();
            }
        };
        deobfAction.putValue("ShortDescription", NLS.str("preferences.deobfuscation"));
        deobfAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, UiUtils.ctrlButton() | 0x200));
        this.deobfToggleBtn = new JToggleButton(deobfAction);
        this.deobfToggleBtn.setSelected(this.settings.isDeobfuscationOn());
        this.deobfToggleBtn.setText("");
        this.deobfMenuItem = new JCheckBoxMenuItem(deobfAction);
        this.deobfMenuItem.setState(this.settings.isDeobfuscationOn());
        AbstractAction logAction = new AbstractAction(NLS.str("menu.log"), ICON_LOG){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogViewerDialog.open(MainWindow.this);
            }
        };
        logAction.putValue("ShortDescription", NLS.str("menu.log"));
        logAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, UiUtils.ctrlButton() | 0x40));
        AbstractAction aboutAction = new AbstractAction(NLS.str("menu.about"), ICON_INFO){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDialog().setVisible(true);
            }
        };
        AbstractAction backAction = new AbstractAction(NLS.str("nav.back"), ICON_BACK){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.tabbedPane.navBack();
            }
        };
        backAction.putValue("ShortDescription", NLS.str("nav.back"));
        backAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
        AbstractAction forwardAction = new AbstractAction(NLS.str("nav.forward"), ICON_FORWARD){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.tabbedPane.navForward();
            }
        };
        forwardAction.putValue("ShortDescription", NLS.str("nav.forward"));
        forwardAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 512, SystemInfo.IS_MAC));
        AbstractAction quarkAction = new AbstractAction("Quark Engine", ICON_QUARK){

            @Override
            public void actionPerformed(ActionEvent e) {
                new QuarkDialog(MainWindow.this).setVisible(true);
            }
        };
        quarkAction.putValue("ShortDescription", "Quark Engine");
        AbstractAction openDeviceAction = new AbstractAction(NLS.str("debugger.process_selector"), ICON_DEBUGGER){

            @Override
            public void actionPerformed(ActionEvent e) {
                ADBDialog dialog = new ADBDialog(MainWindow.this);
                dialog.setVisible(true);
            }
        };
        openDeviceAction.putValue("ShortDescription", NLS.str("debugger.process_selector"));
        JMenu file = new JMenu(NLS.str("menu.file"));
        file.setMnemonic(70);
        file.add(openAction);
        file.add(openProject);
        file.add(addFilesAction);
        file.addSeparator();
        file.add(this.newProjectAction);
        file.add(this.saveProjectAction);
        file.add(saveProjectAsAction);
        file.addSeparator();
        file.add(reload);
        file.add(this.liveReloadMenuItem);
        file.addSeparator();
        file.add(this.exportMappingsMenu);
        file.addSeparator();
        file.add(saveAllAction);
        file.add(exportAction);
        file.addSeparator();
        file.add(recentProjects);
        file.addSeparator();
        file.add(prefsAction);
        file.addSeparator();
        file.add(exitAction);
        JMenu view = new JMenu(NLS.str("menu.view"));
        view.setMnemonic(86);
        view.add(this.flatPkgMenuItem);
        view.add(syncAction);
        view.add(heapUsageBarMenuItem);
        view.add(alwaysSelectOpened);
        JMenu nav = new JMenu(NLS.str("menu.navigation"));
        nav.setMnemonic(78);
        nav.add(textSearchAction);
        nav.add(clsSearchAction);
        nav.add(commentSearchAction);
        nav.addSeparator();
        nav.add(backAction);
        nav.add(forwardAction);
        JMenu tools = new JMenu(NLS.str("menu.tools"));
        tools.setMnemonic(84);
        tools.add(this.deobfMenuItem);
        tools.add(quarkAction);
        tools.add(openDeviceAction);
        JMenu help = new JMenu(NLS.str("menu.help"));
        help.setMnemonic(72);
        help.add(logAction);
        if (Jadx.isDevVersion()) {
            help.add(new AbstractAction("Show sample error report"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionDialog.throwTestException();
                }
            });
        }
        help.add(aboutAction);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(file);
        menuBar.add(view);
        menuBar.add(nav);
        menuBar.add(tools);
        menuBar.add(help);
        this.setJMenuBar(menuBar);
        this.flatPkgButton = new JToggleButton(ICON_FLAT_PKG);
        this.flatPkgButton.setSelected(this.isFlattenPackage);
        ActionListener flatPkgAction = e -> this.toggleFlattenPackage();
        this.flatPkgMenuItem.addActionListener(flatPkgAction);
        this.flatPkgButton.addActionListener(flatPkgAction);
        this.flatPkgButton.setToolTipText(NLS.str("menu.flatten"));
        this.updateLink = new Link("", "https://github.com/skylot/jadx/releases");
        this.updateLink.setVisible(false);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(openAction);
        toolbar.add(addFilesAction);
        toolbar.addSeparator();
        toolbar.add(reload);
        toolbar.addSeparator();
        toolbar.add(saveAllAction);
        toolbar.add(exportAction);
        toolbar.addSeparator();
        toolbar.add(syncAction);
        toolbar.add(this.flatPkgButton);
        toolbar.addSeparator();
        toolbar.add(textSearchAction);
        toolbar.add(clsSearchAction);
        toolbar.add(commentSearchAction);
        toolbar.addSeparator();
        toolbar.add(backAction);
        toolbar.add(forwardAction);
        toolbar.addSeparator();
        toolbar.add(this.deobfToggleBtn);
        toolbar.add(quarkAction);
        toolbar.add(openDeviceAction);
        toolbar.addSeparator();
        toolbar.add(logAction);
        toolbar.addSeparator();
        toolbar.add(prefsAction);
        toolbar.addSeparator();
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.updateLink);
        this.mainPanel.add((Component)toolbar, "North");
        this.addLoadListener(loaded -> {
            textSearchAction.setEnabled(loaded);
            clsSearchAction.setEnabled(loaded);
            commentSearchAction.setEnabled(loaded);
            backAction.setEnabled(loaded);
            forwardAction.setEnabled(loaded);
            syncAction.setEnabled(loaded);
            saveAllAction.setEnabled(loaded);
            exportAction.setEnabled(loaded);
            saveProjectAsAction.setEnabled(loaded);
            reload.setEnabled(loaded);
            deobfAction.setEnabled(loaded);
            quarkAction.setEnabled(loaded);
            return false;
        });
    }

    private void initUI() {
        this.setMinimumSize(new Dimension(200, 150));
        this.mainPanel = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane();
        this.splitPane.setResizeWeight(0.15);
        this.mainPanel.add(this.splitPane);
        DefaultMutableTreeNode treeRootNode = new DefaultMutableTreeNode(NLS.str("msg.open_file"));
        this.treeModel = new DefaultTreeModel(treeRootNode);
        this.tree = new JTree(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setFocusable(false);
        this.tree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                MainWindow.this.tree.setFocusable(false);
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (!MainWindow.this.nodeClickAction(MainWindow.this.getJNodeUnderMouse(e))) {
                        MainWindow.this.tree.setFocusable(true);
                        MainWindow.this.tree.requestFocus();
                    }
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    MainWindow.this.treeRightClickAction(e);
                }
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MainWindow.this.nodeClickAction(MainWindow.this.tree.getLastSelectedPathComponent());
                }
            }
        });
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean focused) {
                Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, focused);
                if (value instanceof JNode) {
                    JNode jNode = (JNode)value;
                    this.setText(jNode.makeStringHtml());
                    this.setIcon(jNode.getIcon());
                    this.setToolTipText(jNode.getTooltip());
                } else {
                    this.setToolTipText(null);
                }
                if (value instanceof JPackage) {
                    this.setEnabled(((JPackage)value).isEnabled());
                }
                return c;
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                Object node = path.getLastPathComponent();
                if (node instanceof JLoadableNode) {
                    ((JLoadableNode)node).loadNode();
                }
                if (!MainWindow.this.treeReloading) {
                    MainWindow.this.project.addTreeExpansion(MainWindow.getPathExpansion(event.getPath()));
                    MainWindow.this.update();
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
                if (!MainWindow.this.treeReloading) {
                    MainWindow.this.project.removeTreeExpansion(MainWindow.getPathExpansion(event.getPath()));
                    MainWindow.this.update();
                }
            }
        });
        this.progressPane = new ProgressPanel(this, true);
        IssuesPanel issuesPanel = new IssuesPanel(this);
        JPanel leftPane = new JPanel(new BorderLayout());
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        treeScrollPane.setMinimumSize(new Dimension(100, 150));
        JPanel bottomPane = new JPanel(new BorderLayout());
        bottomPane.add((Component)issuesPanel, "First");
        bottomPane.add((Component)this.progressPane, "Last");
        leftPane.add((Component)treeScrollPane, "Center");
        leftPane.add((Component)bottomPane, "Last");
        this.splitPane.setLeftComponent(leftPane);
        this.tabbedPane = new TabbedPane(this);
        this.tabbedPane.setMinimumSize(new Dimension(150, 150));
        this.splitPane.setRightComponent(this.tabbedPane);
        new DropTarget(this, 1, new MainDropTarget(this));
        this.heapUsageBar = new HeapUsageBar();
        this.mainPanel.add((Component)this.heapUsageBar, "South");
        this.verticalSplitter = new JSplitPane(0);
        this.verticalSplitter.setTopComponent(this.splitPane);
        this.verticalSplitter.setResizeWeight(0.15);
        this.mainPanel.add((Component)this.verticalSplitter, "Center");
        this.setContentPane(this.mainPanel);
        this.setTitle(DEFAULT_TITLE);
    }

    private void registerMouseNavigationButtons() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.addAWTEventListener(event -> {
            MouseEvent mouseEvent;
            if (event instanceof MouseEvent && (mouseEvent = (MouseEvent)event).getID() == 501) {
                int rawButton = mouseEvent.getButton();
                if (rawButton <= 3) {
                    return;
                }
                int button = MainWindow.remapMouseButton(rawButton);
                switch (button) {
                    case 4: {
                        this.tabbedPane.navBack();
                        break;
                    }
                    case 5: {
                        this.tabbedPane.navForward();
                    }
                }
            }
        }, 16L);
    }

    private static int remapMouseButton(int rawButton) {
        if (SystemInfo.IS_LINUX) {
            if (rawButton == 6) {
                return 4;
            }
            if (rawButton == 7) {
                return 5;
            }
        }
        return rawButton;
    }

    private static String[] getPathExpansion(TreePath path) {
        ArrayList<String> pathList = new ArrayList<String>();
        while (path != null) {
            Object node = path.getLastPathComponent();
            String name = node instanceof JClass ? ((JClass)node).getCls().getClassNode().getClassInfo().getFullName() : node.toString();
            pathList.add(name);
            path = path.getParentPath();
        }
        return pathList.toArray(new String[0]);
    }

    public static void getExpandedPaths(JTree tree, TreePath path, List<TreePath> list) {
        if (tree.isExpanded(path)) {
            list.add(path);
            TreeNode node = (TreeNode)path.getLastPathComponent();
            for (int i = node.getChildCount() - 1; i >= 0; --i) {
                TreeNode n = node.getChildAt(i);
                TreePath child = path.pathByAddingChild(n);
                MainWindow.getExpandedPaths(tree, child, list);
            }
        }
    }

    public void setLocationAndPosition() {
        if (this.settings.loadWindowPos(this)) {
            return;
        }
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        DisplayMode mode = gd.getDisplayMode();
        int w = mode.getWidth();
        int h = mode.getHeight();
        this.setBounds((int)((double)w * 0.15), (int)((double)h * 0.15), (int)((double)w * 0.7), (int)((double)h * 0.7));
        this.setLocationRelativeTo(null);
    }

    private void setEditorTheme(String editorThemePath) {
        try {
            URL themeUrl = this.getClass().getResource(editorThemePath);
            if (themeUrl != null) {
                try (InputStream is = themeUrl.openStream();){
                    this.editorTheme = Theme.load((InputStream)is);
                    return;
                }
            }
            Path themePath = Paths.get(editorThemePath, new String[0]);
            if (Files.isRegularFile(themePath, new LinkOption[0])) {
                try (InputStream is = Files.newInputStream(themePath, new OpenOption[0]);){
                    this.editorTheme = Theme.load((InputStream)is);
                    return;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to load editor theme: {}", (Object)editorThemePath, (Object)e);
        }
        LOG.warn("Falling back to default editor theme: {}", (Object)editorThemePath);
        editorThemePath = EditorTheme.getDefaultTheme().getPath();
        try (InputStream is = this.getClass().getResourceAsStream(editorThemePath);){
            this.editorTheme = Theme.load((InputStream)is);
            return;
        }
        catch (Exception e) {
            LOG.error("Failed to load default editor theme: {}", (Object)editorThemePath, (Object)e);
            this.editorTheme = new Theme(new RSyntaxTextArea());
            return;
        }
    }

    public Theme getEditorTheme() {
        return this.editorTheme;
    }

    public void loadSettings() {
        LafManager.updateLaf(this.settings);
        Font font = this.settings.getFont();
        Font largerFont = font.deriveFont((float)font.getSize() + 2.0f);
        this.setFont(largerFont);
        this.setEditorTheme(this.settings.getEditorThemePath());
        this.tree.setFont(largerFont);
        this.tree.setRowHeight(-1);
        this.tabbedPane.loadSettings();
    }

    private void closeWindow() {
        this.saveAll();
        if (!this.ensureProjectIsSaved()) {
            return;
        }
        this.settings.setTreeWidth(this.splitPane.getDividerLocation());
        this.settings.saveWindowPos(this);
        this.settings.setMainWindowExtendedState(this.getExtendedState());
        if (this.debuggerPanel != null) {
            this.saveSplittersInfo();
        }
        this.heapUsageBar.reset();
        this.closeAll();
        FileUtils.deleteTempRootDir();
        this.dispose();
        System.exit(0);
    }

    private void saveOpenTabs() {
        this.project.saveOpenTabs(this.tabbedPane.getEditorViewStates(), this.tabbedPane.getSelectedIndex());
    }

    private void restoreOpenTabs() {
        List<EditorViewState> openTabs = this.project.getOpenTabs(this);
        if (openTabs.isEmpty()) {
            return;
        }
        for (EditorViewState viewState : openTabs) {
            this.tabbedPane.restoreEditorViewState(viewState);
        }
        try {
            this.tabbedPane.setSelectedIndex(this.project.getActiveTab());
        }
        catch (Exception e) {
            LOG.warn("Failed to restore active tab", (Throwable)e);
        }
    }

    private void saveSplittersInfo() {
        this.settings.setMainWindowVerticalSplitterLoc(this.verticalSplitter.getDividerLocation());
        this.settings.setDebuggerStackFrameSplitterLoc(this.debuggerPanel.getLeftSplitterLocation());
        this.settings.setDebuggerVarTreeSplitterLoc(this.debuggerPanel.getRightSplitterLocation());
    }

    public void addLoadListener(ILoadListener loadListener) {
        this.loadListeners.add(loadListener);
        loadListener.update(this.loaded);
    }

    public void notifyLoadListeners(boolean loaded) {
        this.loaded = loaded;
        this.loadListeners.removeIf(listener -> listener.update(loaded));
    }

    public JadxWrapper getWrapper() {
        return this.wrapper;
    }

    public JadxProject getProject() {
        return this.project;
    }

    public TabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public JadxSettings getSettings() {
        return this.settings;
    }

    public CacheObject getCacheObject() {
        return this.cacheObject;
    }

    public BackgroundExecutor getBackgroundExecutor() {
        return this.backgroundExecutor;
    }

    public JRoot getTreeRoot() {
        return this.treeRoot;
    }

    public JDebuggerPanel getDebuggerPanel() {
        this.initDebuggerPanel();
        return this.debuggerPanel;
    }

    public void showDebuggerPanel() {
        this.initDebuggerPanel();
    }

    public void destroyDebuggerPanel() {
        this.saveSplittersInfo();
        this.debuggerPanel.setVisible(false);
        this.debuggerPanel = null;
    }

    public void showHeapUsageBar() {
        this.settings.setShowHeapUsageBar(true);
        this.heapUsageBar.setVisible(true);
    }

    private void initDebuggerPanel() {
        if (this.debuggerPanel == null) {
            this.debuggerPanel = new JDebuggerPanel(this);
            this.debuggerPanel.loadSettings();
            this.verticalSplitter.setBottomComponent(this.debuggerPanel);
            int loc = this.settings.getMainWindowVerticalSplitterLoc();
            if (loc == 0) {
                loc = 300;
            }
            this.verticalSplitter.setDividerLocation(loc);
        }
    }

    private class RecentProjectsMenuListener
    implements MenuListener {
        private final JMenu menu;

        public RecentProjectsMenuListener(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            HashSet<Path> current = new HashSet<Path>(MainWindow.this.project.getFilePaths());
            List<JMenuItem> items = MainWindow.this.settings.getRecentProjects().stream().filter(path -> !current.contains(path)).map(path -> {
                JMenuItem menuItem = new JMenuItem(path.toAbsolutePath().toString());
                menuItem.addActionListener(e -> MainWindow.this.open(Collections.singletonList(path)));
                return menuItem;
            }).collect(Collectors.toList());
            this.menu.removeAll();
            if (items.isEmpty()) {
                this.menu.add(new JMenuItem(NLS.str("menu.no_recent_projects")));
            } else {
                items.forEach(this.menu::add);
            }
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }
}

