/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.jobs;

import jadx.api.ICodeCache;
import jadx.api.JavaClass;
import jadx.gui.JadxWrapper;
import jadx.gui.jobs.CancelableBackgroundTask;
import jadx.gui.jobs.ITaskInfo;
import jadx.gui.jobs.ProcessResult;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompileTask
extends CancelableBackgroundTask {
    private static final Logger LOG = LoggerFactory.getLogger(DecompileTask.class);
    private static final int CLS_LIMIT = Integer.parseInt(UiUtils.getEnvVar("JADX_CLS_PROCESS_LIMIT", "50"));
    private final JadxWrapper wrapper;
    private final AtomicInteger complete = new AtomicInteger(0);
    private int expectedCompleteCount;
    private ProcessResult result;

    public static int calcDecompileTimeLimit(int classCount) {
        return classCount * CLS_LIMIT + 5000;
    }

    public DecompileTask(JadxWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public String getTitle() {
        return NLS.str("progress.decompile");
    }

    public List<Runnable> scheduleJobs() {
        List<List<JavaClass>> batches;
        List<JavaClass> classes = this.wrapper.getIncludedClasses();
        this.expectedCompleteCount = classes.size();
        this.complete.set(0);
        try {
            batches = this.wrapper.buildDecompileBatches(classes);
        }
        catch (Exception e) {
            LOG.error("Decompile batches build error", (Throwable)e);
            return Collections.emptyList();
        }
        ICodeCache codeCache = this.wrapper.getArgs().getCodeCache();
        ArrayList<Runnable> jobs = new ArrayList<Runnable>(batches.size());
        for (List<JavaClass> batch : batches) {
            jobs.add(() -> {
                for (JavaClass cls : batch) {
                    if (this.isCanceled()) {
                        return;
                    }
                    try {
                        if (codeCache.contains(cls.getRawName())) continue;
                        cls.decompile();
                    }
                    catch (Throwable e) {
                        LOG.error("Failed to decompile class: {}", (Object)cls, (Object)e);
                    }
                    finally {
                        this.complete.incrementAndGet();
                    }
                }
            });
        }
        return jobs;
    }

    @Override
    public void onDone(ITaskInfo taskInfo) {
        long taskTime = taskInfo.getTime();
        long avgPerCls = taskTime / (long)Math.max(this.expectedCompleteCount, 1);
        int timeLimit = this.timeLimit();
        int skippedCls = this.expectedCompleteCount - this.complete.get();
        if (LOG.isInfoEnabled()) {
            LOG.info("Decompile and index task complete in " + taskTime + " ms (avg " + avgPerCls + " ms per class), classes: " + this.expectedCompleteCount + ", skipped: " + skippedCls + ", time limit:{ total: " + timeLimit + "ms, per cls: " + CLS_LIMIT + "ms }, status: " + (Object)((Object)taskInfo.getStatus()));
        }
        this.result = new ProcessResult(skippedCls, taskInfo.getStatus(), timeLimit);
    }

    @Override
    public boolean canBeCanceled() {
        return true;
    }

    @Override
    public int timeLimit() {
        return DecompileTask.calcDecompileTimeLimit(this.expectedCompleteCount);
    }

    @Override
    public boolean checkMemoryUsage() {
        return true;
    }

    public ProcessResult getResult() {
        return this.result;
    }
}

