/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.debugger.smali;

import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.gui.device.debugger.smali.SmaliRegister;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SmaliMethodNode {
    private Map<Long, InsnNode> nodes;
    private List<SmaliRegister> regList;
    private int[] insnPos;
    private int defPos;
    private Map<Integer, Integer> lineMapping = Collections.emptyMap();
    private int paramRegStart;
    private int regCount;

    public int getParamRegStart() {
        return this.paramRegStart;
    }

    public int getRegCount() {
        return this.regCount;
    }

    public Map<Integer, Integer> getLineMapping() {
        return this.lineMapping;
    }

    public void initRegInfoList(int regCount, int insnCount) {
        this.regList = new ArrayList<SmaliRegister>(regCount);
        for (int i = 0; i < regCount; ++i) {
            this.regList.add(new SmaliRegister(i, insnCount));
        }
    }

    public int getInsnPos(long codeOffset) {
        if (this.insnPos != null && codeOffset < (long)this.insnPos.length) {
            return this.insnPos[(int)codeOffset];
        }
        return -1;
    }

    public int getDefPos() {
        return this.defPos;
    }

    public InsnNode getInsnNode(long codeOffset) {
        return this.nodes.get(codeOffset);
    }

    public List<SmaliRegister> getRegList() {
        return this.regList;
    }

    protected SmaliMethodNode() {
    }

    protected void setRegCount(int regCount) {
        this.regCount = regCount;
    }

    protected void attachLine(int line, int codeOffset) {
        if (this.lineMapping.isEmpty()) {
            this.lineMapping = new HashMap<Integer, Integer>();
        }
        this.lineMapping.put(line, codeOffset);
    }

    protected void setInsnInfo(int codeOffset, int pos) {
        InsnNode insn;
        RegisterArg r;
        if (this.insnPos != null && codeOffset < this.insnPos.length) {
            this.insnPos[codeOffset] = pos;
        }
        if ((r = (insn = this.getInsnNode(codeOffset)).getResult()) != null) {
            this.regList.get(r.getRegNum()).setStartOffset(codeOffset);
        }
        for (InsnArg arg : insn.getArguments()) {
            if (!(arg instanceof RegisterArg)) continue;
            this.regList.get(((RegisterArg)arg).getRegNum()).setStartOffset(codeOffset);
        }
    }

    protected void setDefPos(int pos) {
        this.defPos = pos;
    }

    protected void setParamReg(int regNum, String name) {
        SmaliRegister r = this.regList.get(regNum);
        r.setParam(name);
        r.setStartOffset(-1);
    }

    protected void setParamRegStart(int paramRegStart) {
        this.paramRegStart = paramRegStart;
    }

    protected void setInsnNodes(Map<Long, InsnNode> nodes, int insnCount) {
        this.nodes = nodes;
        this.insnPos = new int[insnCount];
    }
}

