/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.impl;

import jadx.api.ICodeCache;
import jadx.api.ICodeInfo;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InMemoryCodeCache
implements ICodeCache {
    private final Map<String, ICodeInfo> storage = new ConcurrentHashMap<String, ICodeInfo>();

    @Override
    public void add(String clsFullName, ICodeInfo codeInfo) {
        this.storage.put(clsFullName, codeInfo);
    }

    @Override
    public void remove(String clsFullName) {
        this.storage.remove(clsFullName);
    }

    @Override
    @NotNull
    public ICodeInfo get(String clsFullName) {
        ICodeInfo codeInfo = this.storage.get(clsFullName);
        if (codeInfo == null) {
            return ICodeInfo.EMPTY;
        }
        return codeInfo;
    }

    @Override
    @Nullable
    public String getCode(String clsFullName) {
        ICodeInfo codeInfo = this.storage.get(clsFullName);
        if (codeInfo == null) {
            return null;
        }
        return codeInfo.getCodeStr();
    }

    @Override
    public boolean contains(String clsFullName) {
        return this.storage.containsKey(clsFullName);
    }

    @Override
    public void close() throws IOException {
        this.storage.clear();
    }

    public String toString() {
        return "InMemoryCodeCache: size=" + this.storage.size();
    }
}

