/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java;

import jadx.api.plugins.JadxPluginInfo;
import jadx.api.plugins.input.JadxInputPlugin;
import jadx.api.plugins.input.data.ILoadResult;
import jadx.api.plugins.input.data.impl.EmptyLoadResult;
import jadx.plugins.input.java.JavaClassReader;
import jadx.plugins.input.java.JavaFileLoader;
import jadx.plugins.input.java.JavaLoadResult;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaInputPlugin
implements JadxInputPlugin {
    public static final JadxPluginInfo PLUGIN_INFO = new JadxPluginInfo("java-input", "JavaInput", "Load .class and .jar files");

    public JadxPluginInfo getPluginInfo() {
        return PLUGIN_INFO;
    }

    public ILoadResult loadFiles(List<Path> inputFiles) {
        return JavaInputPlugin.loadClassFiles(inputFiles, null);
    }

    public static ILoadResult loadClassFiles(List<Path> inputFiles, @Nullable Closeable closeable) {
        List<JavaClassReader> readers = new JavaFileLoader().collectFiles(inputFiles);
        if (readers.isEmpty()) {
            return EmptyLoadResult.INSTANCE;
        }
        return new JavaLoadResult(readers, closeable);
    }
}

