/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins.utils;

import jadx.api.plugins.utils.CommonFileUtils;
import jadx.api.plugins.utils.LimitedInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipSecurity {
    private static final Logger LOG = LoggerFactory.getLogger(ZipSecurity.class);
    private static final int MAX_SIZE_DIFF = 100;
    private static final int MAX_ENTRIES_COUNT = 100000;

    private ZipSecurity() {
    }

    private static boolean isInSubDirectoryInternal(File baseDir, File canonFile) {
        if (canonFile == null) {
            return false;
        }
        if (canonFile.equals(baseDir)) {
            return true;
        }
        return ZipSecurity.isInSubDirectoryInternal(baseDir, canonFile.getParentFile());
    }

    public static boolean isInSubDirectory(File baseDir, File file) {
        try {
            file = file.getCanonicalFile();
            baseDir = baseDir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        return ZipSecurity.isInSubDirectoryInternal(baseDir, file);
    }

    public static boolean isValidZipEntryName(String entryName) {
        try {
            File currentPath = CommonFileUtils.CWD;
            File canonical = new File(currentPath, entryName).getCanonicalFile();
            if (ZipSecurity.isInSubDirectoryInternal(currentPath, canonical)) {
                return true;
            }
            LOG.error("Path traversal attack detected, invalid name: {}", (Object)entryName);
            return false;
        }
        catch (Exception e) {
            LOG.error("Path traversal attack detected, invalid name: {}", (Object)entryName);
            return false;
        }
    }

    public static boolean isZipBomb(ZipEntry entry) {
        long compressedSize = entry.getCompressedSize();
        long uncompressedSize = entry.getSize();
        if (compressedSize < 0L || uncompressedSize < 0L) {
            LOG.error("Zip bomb attack detected, invalid sizes: compressed {}, uncompressed {}, name {}", new Object[]{compressedSize, uncompressedSize, entry.getName()});
            return true;
        }
        if (compressedSize * 100L < uncompressedSize) {
            LOG.error("Zip bomb attack detected, invalid sizes: compressed {}, uncompressed {}, name {}", new Object[]{compressedSize, uncompressedSize, entry.getName()});
            return true;
        }
        return false;
    }

    public static boolean isValidZipEntry(ZipEntry entry) {
        return ZipSecurity.isValidZipEntryName(entry.getName()) && !ZipSecurity.isZipBomb(entry);
    }

    public static InputStream getInputStreamForEntry(ZipFile zipFile, ZipEntry entry) throws IOException {
        InputStream in = zipFile.getInputStream(entry);
        LimitedInputStream limited = new LimitedInputStream(in, entry.getSize());
        return new BufferedInputStream(limited);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <R> R visitZipEntries(File file, BiFunction<ZipFile, ZipEntry, R> visitor) {
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            int entriesProcessed = 0;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!ZipSecurity.isValidZipEntry(entry)) continue;
                R result = visitor.apply(zip, entry);
                if (result != null) {
                    R r = result;
                    return r;
                }
                if (++entriesProcessed > 100000) throw new IllegalStateException("Zip entries count limit exceeded: 100000, last entry: " + entry.getName());
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process zip file: " + file.getAbsolutePath(), e);
        }
    }

    public static void readZipEntries(File file, BiConsumer<ZipEntry, InputStream> visitor) {
        ZipSecurity.visitZipEntries(file, (zip, entry) -> {
            if (!entry.isDirectory()) {
                try (InputStream in = ZipSecurity.getInputStreamForEntry(zip, entry);){
                    visitor.accept((ZipEntry)entry, in);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error process zip entry: " + entry.getName());
                }
            }
            return null;
        });
    }
}

