#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 idris
version:              1.3.4
visibility:           public
id:                   idris-1.3.4-1w6ar1QVJA22WUYfFTQpoa
key:                  idris-1.3.4-1w6ar1QVJA22WUYfFTQpoa
license:              BSD-3-Clause
maintainer:           Niklas Larsson <niklas@mm.st>
author:               Edwin Brady
stability:            Beta
homepage:             https://www.idris-lang.org/
synopsis:             Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <https://www.idris-lang.org/documentation>.
    Features include:

    * Full, first class, dependent types with dependent pattern matching

    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings

    * Interfaces (similar to type classes), monad comprehensions

    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs

    * Totality checking

    * Coinductive types

    * Indentation significant syntax, extensible syntax

    * Cumulative universes

    * Simple foreign function interface (to C)

    * Hugs style interactive environment

category:             Compilers/Interpreters, Dependent Types
abi:                  529a98d71d7c014958e327d66a835cec
exposed:              True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System

hidden-modules:
    Util.Pretty Util.Net Paths_idris Version_idris Tools_idris
    BuildFlags_idris

import-dirs:          /usr/lib/ghc-9.0.2/site-local/idris-1.3.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/idris-1.3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/idris
hs-libraries:         HSidris-1.3.4-1w6ar1QVJA22WUYfFTQpoa
extra-libraries:      gmp
depends:
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    annotated-wl-pprint-0.7.0-6vyiTB7Qv98BkD7hsY3Ewg
    ansi-terminal-0.11.3-4sOL9w5QIphDlJIIpaWFJL
    ansi-wl-pprint-0.6.9-J38Hi5Z6ALfKDwm9oxcbks array-0.5.4.0
    async-2.2.4-9EoKZTgytm43s60GeTAIZR base-4.15.1.0
    base64-bytestring-1.2.1.0-iG6YBGhLkRJagBsFqRAI2 binary-0.8.8.0
    blaze-html-0.9.1.2-AIRGwJuJakcDOfrsYtfKDl
    blaze-markup-0.8.2.8-3wZdN7kDxS97Q5eM0mxELA bytestring-0.10.12.1
    cheapskate-0.1.1.2-CkQBS2Zh8cvHIqLwoFzkXk
    code-page-0.2.1-2yvmeM0b2LT6XlGG4kufG5 containers-0.6.4.1
    deepseq-1.4.5.0 directory-1.3.6.2 filepath-1.4.2.1
    fingertree-0.1.5.0-GuU5MGfdwFs7iiA40OQObo
    fsnotify-0.3.0.1-DBGrOHZB2E63O11ylJVcXs haskeline-0.8.2
    ieee754-0.8.0-8ARR0f1c99A76lnIcdz1Si
    libffi-0.2.1-DP5u3iTN0ykGYSlh8Owdy3
    megaparsec-9.2.2-9J8e8j7w3nJKAXfYAylaYf mtl-2.2.2
    network-3.1.2.7-2x6X3kWddA03AmOITnySLy
    optparse-applicative-0.17.0.0-5RAB8jXJau3LDHQVpRHOkD
    parser-combinators-1.3.0-FL5bcA6sX4a2ejs4tDtkjB pretty-1.1.3.6
    process-1.6.13.2 regex-tdfa-1.3.2-tNtR2SpOBLAbbzDX5vBu9
    safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
    split-0.2.3.5-1ZFbiAR4sQhKaqqBevLjN8
    terminal-size-0.3.3-9JiTHA73QXVH7lW7Leoqqc text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2 uniplate-1.6.13-Bz3m6aJYQrB6IKo2ZbSAY5
    unix-2.7.2.2 unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    utf8-string-1.0.2-Fg3PN5UX3ZfnukMwwaDpj
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf
    vector-binary-instances-0.2.5.2-2krkEey0awz1rfTRut7xIo
    zip-archive-0.4.2.2-E9rdfhhdvGpuXMTfHS9Es

haddock-interfaces:   /usr/share/doc/idris/html/idris.haddock
haddock-html:         /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

