#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-web
version:              1.27.1
visibility:           public
id:                   hledger-web-1.27.1-K0DHfH7N71OH6Sj1tjT7va
key:                  hledger-web-1.27.1-K0DHfH7N71OH6Sj1tjT7va
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web-based user interface for the hledger accounting system
description:
    A simple web-based user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  7abc08114bbf918746cb55531cca7a16
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Foundation
    Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Import Hledger.Web.Main Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Test
    Hledger.Web.WebOptions Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common

hidden-modules:       Paths_hledger_web
import-dirs:          /usr/lib/ghc-9.0.2/site-local/hledger-web-1.27.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hledger-web-1.27.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.27.1-K0DHfH7N71OH6Sj1tjT7va
depends:
    Decimal-0.5.2-5TmJb6Vs4Vl5bvz4dK9QdP
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT base-4.15.1.0
    base64-0.4.2.4-G4e78r5RGs9KhnijZEDeLF
    blaze-html-0.9.1.2-AIRGwJuJakcDOfrsYtfKDl
    blaze-markup-0.8.2.8-3wZdN7kDxS97Q5eM0mxELA
    breakpoint-0.1.0.0-Kyer6t83p0EufYOaIHkOT bytestring-0.10.12.1
    case-insensitive-1.2.1.0-9P0gl8mW2it6Cg0EClpHns
    clientsession-0.9.1.2-COqHnajN18K27dCuNyOg3M
    cmdargs-0.10.21-5dEStss8OK87s5amCxsPTV
    conduit-1.3.4.3-8itn5Qj41ZSLgRSjBhzqyF
    conduit-extra-1.3.6-LDUhnbBFGIILMmOycgbU6i containers-0.6.4.1
    data-default-0.7.1.1-BkZarJ3J3008hHF2JOuYeW directory-1.3.6.2
    extra-1.7.12-DPTGYhuNp118MPDFhQYU8g filepath-1.4.2.1
    hjsmin-0.2.0.4-32AAcbR1R6k7ALtyw47xIp
    hledger-1.27.1-BjTQy2y9J9CHQptIVoGue
    hledger-lib-1.27.1-I6srZPrZvPGDtcWI2Kweqy
    hspec-2.10.3-4Wt0QjTgi686IkH1mEMF4O
    http-client-0.7.13.1-IUPmZAWhHcS7Jd2UKXuikW
    http-conduit-2.3.8-A2ewQB6Xsua8zvxieTH7DQ
    http-types-0.12.3-L4VBkj9wBbpJhmiMCXrA05
    megaparsec-9.2.2-9J8e8j7w3nJKAXfYAylaYf mtl-2.2.2
    network-3.1.2.7-2x6X3kWddA03AmOITnySLy
    shakespeare-2.0.30-48fWCLD0yIaL2YGbQM2B6r template-haskell-2.17.0.0
    text-1.2.5.0 time-1.9.3 transformers-0.5.6.2
    unix-compat-0.6-ItrkFOIKc9mI0qPePSsUjW
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    utf8-string-1.0.2-Fg3PN5UX3ZfnukMwwaDpj
    wai-3.2.3-4BBvzsOByYiKnH9wzG1k6K
    wai-cors-0.2.7-GpfAcJbR0DQ3CKtE5ncD1W
    wai-extra-3.1.12.1-9ZhhaouWVJ9KdcrPtBJdXj
    wai-handler-launch-3.0.3.1-33ExrQnTbwqBEWZtAonMhe
    warp-3.3.23-5zUSWgy73EuKtltSqCMIpH
    yaml-0.11.8.0-EFN1CMgVIdSAIGSdgvEPUP
    yesod-1.6.2.1-5r6xZ1PWvaCBhO7uECJijY
    yesod-core-1.6.24.0-9pIa3K9LIhz7DpUCjvj8VM
    yesod-form-1.7.3-HLljVJeEI8fGsTHBriZl8D
    yesod-static-1.6.1.0-AdA83OdZshjLrm5dMz3xPq
    yesod-test-1.6.15-AtMiMYGaSuo5lci1aHcirq

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

