#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger
version:              1.27.1
visibility:           public
id:                   hledger-1.27.1-BjTQy2y9J9CHQptIVoGue
key:                  hledger-1.27.1-BjTQy2y9J9CHQptIVoGue
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  3629a464760c4e1a589b99bbb45ba5ed
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Descriptions
    Hledger.Cli.Commands.Diff Hledger.Cli.Commands.Files
    Hledger.Cli.Commands.Help Hledger.Cli.Commands.Import
    Hledger.Cli.Commands.Incomestatement Hledger.Cli.Commands.Notes
    Hledger.Cli.Commands.Payees Hledger.Cli.Commands.Prices
    Hledger.Cli.Commands.Print Hledger.Cli.Commands.Printunique
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Registermatch
    Hledger.Cli.Commands.Rewrite Hledger.Cli.Commands.Roi
    Hledger.Cli.Commands.Stats Hledger.Cli.Commands.Tags
    Hledger.Cli.CompoundBalanceCommand Hledger.Cli.DocFiles
    Hledger.Cli.Main Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.0.2/site-local/hledger-1.27.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hledger-1.27.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.27.1-BjTQy2y9J9CHQptIVoGue
depends:
    Decimal-0.5.2-5TmJb6Vs4Vl5bvz4dK9QdP
    Diff-0.4.1-2jMKpzJJQmAHzE6LyB7Qjk
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    ansi-terminal-0.11.3-4sOL9w5QIphDlJIIpaWFJL base-4.15.1.0
    breakpoint-0.1.0.0-Kyer6t83p0EufYOaIHkOT bytestring-0.10.12.1
    cmdargs-0.10.21-5dEStss8OK87s5amCxsPTV containers-0.6.4.1
    data-default-0.7.1.1-BkZarJ3J3008hHF2JOuYeW directory-1.3.6.2
    extra-1.7.12-DPTGYhuNp118MPDFhQYU8g filepath-1.4.2.1
    githash-0.1.6.3-LUU4aE59lPW2hb8tAd17vZ
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F haskeline-0.8.2
    hledger-lib-1.27.1-I6srZPrZvPGDtcWI2Kweqy
    lucid-2.11.1-8zRbazSvRIOLYXnxOABT2H
    math-functions-0.3.4.2-GGMY6h52CV8Ie2OoDHhuQH
    megaparsec-9.2.2-9J8e8j7w3nJKAXfYAylaYf
    microlens-0.4.13.0-8kbZITwqGed8vNsPXOVOwI mtl-2.2.2
    process-1.6.13.2 regex-tdfa-1.3.2-tNtR2SpOBLAbbzDX5vBu9
    safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
    shakespeare-2.0.30-48fWCLD0yIaL2YGbQM2B6r
    split-0.2.3.5-1ZFbiAR4sQhKaqqBevLjN8
    tabular-0.2.2.8-3mznlUNrnmF8EH6LDY9YkX
    tasty-1.4.2.3-5g26BST7AomGP7PDx0otzq
    temporary-1.3-HXIdO020OG29nAlGx7vsUT terminfo-0.4.1.5 text-1.2.5.0
    time-1.9.3 timeit-2.0-13BYXbUXu2MJzbvDZuPEww transformers-0.5.6.2
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    utf8-string-1.0.2-Fg3PN5UX3ZfnukMwwaDpj
    utility-ht-0.0.16-5FkXBpGolEP23gUJLQS5QH
    wizards-1.0.3-1RnzFufEITLBaBp65cnTUp

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

