#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 what4
version:              1.3
visibility:           public
id:                   what4-1.3-H44aCGr872O3wobbsgj10R
key:                  what4-1.3-H44aCGr872O3wobbsgj10R
license:              BSD-3-Clause
copyright:            (c) Galois, Inc 2014-2021
maintainer:           jhendrix@galois.com, rdockins@galois.com
author:               Galois Inc.
homepage:             https://github.com/GaloisInc/what4
synopsis:             Solver-agnostic symbolic values support for issuing queries
description:
    What4 is a generic library for representing values as symbolic formulae which may
    contain references to symbolic values, representing unknown variables.
    It provides support for communicating with a variety of SAT and SMT solvers,
    including Z3, CVC4, Yices, Boolector, STP, and dReal.
    The data representation types make heavy use of GADT-style type indices
    to ensure type-correct manipulation of symbolic values.

category:             Formal Methods, Theorem Provers, Symbolic Computation, SMT
abi:                  b18473015730e1ab6933bcea8e7711ef
exposed:              True
exposed-modules:
    Test.Verification What4.BaseTypes What4.Concrete What4.Config
    What4.Expr What4.Expr.Allocator What4.Expr.App What4.Expr.AppTheory
    What4.Expr.ArrayUpdateMap What4.Expr.BoolMap What4.Expr.Builder
    What4.Expr.GroundEval What4.Expr.MATLAB What4.Expr.Simplify
    What4.Expr.StringSeq What4.Expr.UnaryBV
    What4.Expr.VarIdentification What4.Expr.WeightedSum What4.FloatMode
    What4.FunctionName What4.IndexLit What4.Interface
    What4.InterpretedFloatingPoint What4.LabeledPred What4.Panic
    What4.Partial What4.ProblemFeatures What4.ProgramLoc
    What4.Protocol.Online What4.Protocol.PolyRoot
    What4.Protocol.ReadDecimal What4.Protocol.SExp
    What4.Protocol.SMTLib2 What4.Protocol.SMTLib2.Parse
    What4.Protocol.SMTLib2.Response What4.Protocol.SMTLib2.Syntax
    What4.Protocol.SMTWriter What4.Protocol.VerilogWriter
    What4.Protocol.VerilogWriter.ABCVerilog
    What4.Protocol.VerilogWriter.AST
    What4.Protocol.VerilogWriter.Backend What4.SFloat What4.SWord
    What4.SatResult What4.SemiRing What4.Solver What4.Solver.Adapter
    What4.Solver.Boolector What4.Solver.CVC4 What4.Solver.DReal
    What4.Solver.ExternalABC What4.Solver.STP What4.Solver.Yices
    What4.Solver.Z3 What4.SpecialFunctions What4.Symbol
    What4.Utils.AbstractDomains What4.Utils.AnnotatedMap
    What4.Utils.Arithmetic What4.Utils.BVDomain
    What4.Utils.BVDomain.Arith What4.Utils.BVDomain.Bitwise
    What4.Utils.BVDomain.XOR What4.Utils.Complex What4.Utils.Endian
    What4.Utils.Environment What4.Utils.FloatHelpers
    What4.Utils.HandleReader What4.Utils.IncrHash What4.Utils.LeqMap
    What4.Utils.MonadST What4.Utils.OnlyIntRepr What4.Utils.Process
    What4.Utils.ResolveBounds.BV What4.Utils.Streams
    What4.Utils.StringLiteral What4.Utils.Versions
    What4.Utils.Word16String What4.WordMap

import-dirs:          /usr/lib/ghc-9.0.2/site-local/what4-1.3
library-dirs:         /usr/lib/ghc-9.0.2/site-local/what4-1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-what4
hs-libraries:         HSwhat4-1.3-H44aCGr872O3wobbsgj10R
depends:
    async-2.2.4-9EoKZTgytm43s60GeTAIZR
    attoparsec-0.14.4-9SQv4o2tq0k4n7CegIwza1 base-4.15.1.0
    bifunctors-5.5.13-JsL8XwnIyaF7mMrittTFB9
    bimap-0.5.0-K6wajBmZnvQ3NtPH89yzAZ
    bv-sized-1.0.4-7rtuAEU65piKXRy5usB3fr bytestring-0.10.12.1
    concurrent-extra-0.7.0.12-4sakygAG3FeHHc0pS8SdRl
    config-value-0.8.3-3pmzeYU8Vb25WTAZFoPyxS containers-0.6.4.1
    data-binary-ieee754-0.4.4-6nKeQnWkGoLJGejCHaRaWS deepseq-1.4.5.0
    deriving-compat-0.6.1-4ikVM59GGob1QsvMQOiMoT directory-1.3.6.2
    exceptions-0.10.4 filepath-1.4.2.1
    fingertree-0.1.5.0-GuU5MGfdwFs7iiA40OQObo ghc-prim-0.7.0
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    hashtables-1.3.1-CYzHUQOg5RG9TFA6ECvfn8
    io-streams-1.5.2.2-1rmTTD5GyAiGY9hmphDOxR
    lens-5.1.1-8cVW77ucFRGIbO4yMEfpoM
    libBF-0.6.5.1-KueXYqkJqo9Ae0ncPeIFCk mtl-2.2.2
    panic-0.4.0.1-2wjLiVfd2FlFLaw0kmLA9p
    parameterized-utils-2.1.5.0-CmlKiUF7QEHGJKHwPvS6eP
    prettyprinter-1.7.1-Kh082I8LQyjLFudtJnG2xP process-1.6.13.2
    scientific-0.3.7.0-1l3L5iYBn9JD8GP8kLjgG7 template-haskell-2.17.0.0
    temporary-1.3-HXIdO020OG29nAlGx7vsUT text-1.2.5.0
    th-abstraction-0.4.5.0-CPrpKcr2W2S31K8QsJKgDp
    th-lift-0.8.2-47INKJD6iIF1IlUc8HcOrC
    th-lift-instances-0.1.20-5NHl0zPpjKhEmiENmzVd0c
    transformers-0.5.6.2
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    utf8-string-1.0.2-Fg3PN5UX3ZfnukMwwaDpj
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf
    versions-5.0.4-311z5UF5aIw1ZCaWnETFJs
    zenc-0.1.2-6yWgkCvB1JxEqR3ZIehCBJ

haddock-interfaces:   /usr/share/doc/haskell-what4/html/what4.haddock
haddock-html:         /usr/share/doc/haskell-what4/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

