#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tasty-silver
version:              3.3.1.1
visibility:           public
id:                   tasty-silver-3.3.1.1-L90nK4hY246EIuLImXzhtW
key:                  tasty-silver-3.3.1.1-L90nK4hY246EIuLImXzhtW
license:              MIT
maintainer:           Philipp Hausmann, Andreas Abel
author:               Philipp Hausmann, Roman Cheplyaka and others
homepage:             https://github.com/phile314/tasty-silver
synopsis:             A fancy test runner, including support for golden tests.
description:
    This package provides a fancy test runner and support for «golden testing».

    A golden test is an IO action that writes its result to a file.
    To pass the test, this output file should be identical to the corresponding
    «golden» file, which contains the correct result for the test.

    The test runner allows filtering tests using regexes, and to interactively
    inspect the result of golden tests.

    This package is a heavily extended fork of tasty-golden.

category:             Testing
abi:                  1f9ea9ba5c6e75e434c15d02933f8927
exposed:              True
exposed-modules:
    Test.Tasty.Silver Test.Tasty.Silver.Advanced
    Test.Tasty.Silver.Filter Test.Tasty.Silver.Interactive
    Test.Tasty.Silver.Interactive.Run Test.Tasty.Silver.Internal

import-dirs:          /usr/lib/ghc-9.0.2/site-local/tasty-silver-3.3.1.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/tasty-silver-3.3.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tasty-silver
hs-libraries:         HStasty-silver-3.3.1.1-L90nK4hY246EIuLImXzhtW
depends:
    ansi-terminal-0.11.3-4sOL9w5QIphDlJIIpaWFJL
    async-2.2.4-9EoKZTgytm43s60GeTAIZR base-4.15.1.0
    bytestring-0.10.12.1 containers-0.6.4.1 deepseq-1.4.5.0
    directory-1.3.6.2 filepath-1.4.2.1 mtl-2.2.2
    optparse-applicative-0.17.0.0-5RAB8jXJau3LDHQVpRHOkD
    process-1.6.13.2 process-extras-0.7.4-EVPuBXQWnA46vy17aJ0OvW
    regex-tdfa-1.3.2-tNtR2SpOBLAbbzDX5vBu9
    silently-1.2.5.3-H31j5J4Oc25zA6fMk6qKZ stm-2.5.0.0
    tagged-0.8.6.1-79gYUUazit6EfoPS33FHdR
    tasty-1.4.2.3-5g26BST7AomGP7PDx0otzq
    temporary-1.3-HXIdO020OG29nAlGx7vsUT text-1.2.5.0
    transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-tasty-silver/html/tasty-silver.haddock

haddock-html:         /usr/share/doc/haskell-tasty-silver/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

