#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-theory
version:              1.6.1
visibility:           public
id:                   tamarin-prover-theory-1.6.1-HnDdiU7DkhrHyaG73ac8hg
key:                  tamarin-prover-theory-1.6.1-HnDdiU7DkhrHyaG73ac8hg
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Jannik Dreier, Ralf Sasse, ETH Zurich, 2010-2018

maintainer:
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:
    Security protocol types and constraint solver library for the tamarin prover.

description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

    This library provides the types to represent security
    protocols, and it implements the constraint solver.

category:             Theorem Provers
abi:                  6855a31f45aaacc825636fe82bb9e6d0
exposed:              True
exposed-modules:
    Theory Theory.Constraint.Solver
    Theory.Constraint.Solver.Contradictions
    Theory.Constraint.Solver.Goals Theory.Constraint.Solver.Heuristics
    Theory.Constraint.Solver.ProofMethod
    Theory.Constraint.Solver.Reduction
    Theory.Constraint.Solver.Simplify Theory.Constraint.Solver.Sources
    Theory.Constraint.System Theory.Constraint.System.Constraints
    Theory.Constraint.System.Dot Theory.Constraint.System.Guarded
    Theory.Constraint.System.JSON Theory.Model Theory.Model.Atom
    Theory.Model.Fact Theory.Model.Formula Theory.Model.Restriction
    Theory.Model.Rule Theory.Model.Signature Theory.Proof Theory.Sapic
    Theory.Sapic.Print Theory.Text.Parser
    Theory.Text.Parser.Restriction Theory.Text.Parser.Token
    Theory.Text.Pretty Theory.Tools.AbstractInterpretation
    Theory.Tools.EquationStore Theory.Tools.InjectiveFactInstances
    Theory.Tools.IntruderRules Theory.Tools.LoopBreakers
    Theory.Tools.RuleVariants Theory.Tools.Wellformedness

hidden-modules:
    Theory.Text.Parser.Exceptions Theory.Text.Parser.Fact
    Theory.Text.Parser.Formula Theory.Text.Parser.Lemma
    Theory.Text.Parser.Let Theory.Text.Parser.Proof
    Theory.Text.Parser.Rule Theory.Text.Parser.Sapic
    Theory.Text.Parser.Signature Theory.Text.Parser.Term

import-dirs:          /usr/lib/ghc-9.0.2/site-local/tamarin-prover-theory-1.6.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/tamarin-prover-theory-1.6.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-theory
hs-libraries:         HStamarin-prover-theory-1.6.1-HnDdiU7DkhrHyaG73ac8hg
depends:
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    aeson-pretty-0.8.9-HIKDmSQGmI0DQYiuXhljjd base-4.15.1.0
    binary-0.8.8.0 bytestring-0.10.12.1 containers-0.6.4.1
    deepseq-1.4.5.0 dlist-1.0-ImNlUre2rHgIkuGbqNQCOO exceptions-0.10.4
    fclabels-2.0.5.1-9a5T1hXanLx1UTTIEKz4w4 filepath-1.4.2.1 mtl-2.2.2
    parallel-3.2.2.0-D2aleEa2VnPBr164BdKnms parsec-3.1.14.0
    process-1.6.13.2 safe-0.3.19-2aVM1fCfxX88jnlVeNbd8Q
    tamarin-prover-term-1.6.1-EyEQB5GDUPTH1FqgaxfCpM
    tamarin-prover-utils-1.6.1-HYLrwrfeZg6LwzWSuEs9EF text-1.2.5.0
    transformers-0.5.6.2 uniplate-1.6.13-Bz3m6aJYQrB6IKo2ZbSAY5

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-theory/html/tamarin-prover-theory.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-theory/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

