#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 servant-swagger
version:              1.1.11
visibility:           public
id:                   servant-swagger-1.1.11-3dnMOzFRGrS3Sl4XYO0C8B
key:                  servant-swagger-1.1.11-3dnMOzFRGrS3Sl4XYO0C8B
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           haskell-servant-maintainers@googlegroups.com
author:               Servant Contributors
homepage:
    https://github.com/haskell-servant/servant/tree/master/servant-swagger#readme

synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  64857943fd47ef1d464e074c4d69334b
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-9.0.2/site-local/servant-swagger-1.1.11
library-dirs:         /usr/lib/ghc-9.0.2/site-local/servant-swagger-1.1.11
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-servant-swagger
hs-libraries:         HSservant-swagger-1.1.11-3dnMOzFRGrS3Sl4XYO0C8B
depends:
    QuickCheck-2.14.2-JoFwhdHSVnjCwZaPGQEEzD
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    aeson-pretty-0.8.9-HIKDmSQGmI0DQYiuXhljjd base-4.15.1.0
    base-compat-0.12.2-l1EqrM7Qwu6Pq9d4drKFu bytestring-0.10.12.1
    hspec-2.10.3-4Wt0QjTgi686IkH1mEMF4O
    http-media-0.8.0.0-HXwSdb5ej131khAvPb77zv
    insert-ordered-containers-0.2.5.1-C3ubsjbphwUCYJw9UpPheu
    lens-5.1.1-8cVW77ucFRGIbO4yMEfpoM
    servant-0.19.1-HFHLYn5uUzmHTmiTLf0Pzm
    singleton-bool-0.1.6-Lql30fSVV7u9b8PYuapbsl
    swagger2-2.8.6-Ln8NQuEatBP9UMxP0oeK3e text-1.2.5.0
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

