#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 scotty
version:              0.12
visibility:           public
id:                   scotty-0.12-FgFzqbF4qezC33BsooD7Hf
key:                  scotty-0.12-FgFzqbF4qezC33BsooD7Hf
license:              BSD-3-Clause
copyright:            (c) 2012-Present Andrew Farmer
maintainer:           Andrew Farmer <xichekolas@gmail.com>
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    import Data.Monoid (mconcat)

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- param &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  6a7f351fc1a393920cf20a7486a27e1e
exposed:              True
exposed-modules:      Web.Scotty Web.Scotty.Internal.Types Web.Scotty.Trans
hidden-modules:       Web.Scotty.Action Web.Scotty.Route Web.Scotty.Util
import-dirs:          /usr/lib/ghc-9.0.2/site-local/scotty-0.12
library-dirs:         /usr/lib/ghc-9.0.2/site-local/scotty-0.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-scotty
hs-libraries:         HSscotty-0.12-FgFzqbF4qezC33BsooD7Hf
depends:
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT base-4.15.1.0
    base-compat-batteries-0.12.2-7VhZTWlppOIIx3KQWwGXg0
    blaze-builder-0.4.2.2-2gLNFpRfQ1I6uT3J9lURjU bytestring-0.10.12.1
    case-insensitive-1.2.1.0-9P0gl8mW2it6Cg0EClpHns
    data-default-class-0.1.2.0-IxhEAzgy8931aXcEiJcyZO exceptions-0.10.4
    http-types-0.12.3-L4VBkj9wBbpJhmiMCXrA05
    monad-control-1.0.3.1-21gUZpZbgH5KO3QvMCPaGC mtl-2.2.2
    network-3.1.2.7-2x6X3kWddA03AmOITnySLy
    regex-compat-0.95.2.1-itFB4fXPjn9OuocZGgbix text-1.2.5.0
    transformers-0.5.6.2 transformers-base-0.4.6-2M49J28Ed0L2XQvH4AySxP
    transformers-compat-0.7.2-ZzSHjvD4flB2ChCq5TVbH
    wai-3.2.3-4BBvzsOByYiKnH9wzG1k6K
    wai-extra-3.1.12.1-9ZhhaouWVJ9KdcrPtBJdXj
    warp-3.3.23-5zUSWgy73EuKtltSqCMIpH

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

