#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ral
version:              0.2.1
visibility:           public
id:                   ral-0.2.1-DMwDRH8H3zU35JyBeJCLXC
key:                  ral-0.2.1-DMwDRH8H3zU35JyBeJCLXC
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Random access lists
description:
    This package provides ordinary random access list, '\''RAList'\'', and also
    a length indexed variant, '\''RAVec'\''.

    The data structure allows fast cons-operation (like ordinary list) but also fast random access (like non-functional arrays).

    For @lens@ or @optics@ support see [ral-lens](https://hackage.haskell.org/package/ral-lens) and [ral-optics](https://hackage.haskell.org/package/ral-optics) packages respectively.

    === Similar packages

    These packages don'\''t provide length-indexed variants, and their '\''RAList'\'' has
    opaque structure.

    * https://hackage.haskell.org/package/ralist
    * https://hackage.haskell.org/package/random-access-list

category:             Data, Dependent Types, Singletons
abi:                  a106e79837cc2844d440e702d9c3afbd
exposed:              True
exposed-modules:
    Data.RAList Data.RAList.NonEmpty Data.RAList.Tree Data.RAVec
    Data.RAVec.NonEmpty Data.RAVec.Tree Data.RAVec.Tree.DF

hidden-modules:
    Data.RAList.Internal Data.RAList.NonEmpty.Internal
    Data.RAList.Tree.Internal TrustworthyCompat

import-dirs:          /usr/lib/ghc-9.0.2/site-local/ral-0.2.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/ral-0.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ral
hs-libraries:         HSral-0.2.1-DMwDRH8H3zU35JyBeJCLXC
depends:
    QuickCheck-2.14.2-JoFwhdHSVnjCwZaPGQEEzD
    adjunctions-4.4.2-FP2PwlGlhSkKIPEjgFd7fk base-4.15.1.0
    bin-0.1.2-FRjPlJ4NEQIJfNNnrw2iW3 boring-0.2-AywtoMK07vg9Z9Ocyuk3Wm
    deepseq-1.4.5.0 distributive-0.6.2.1-9wcbdvxUhl373VFDpLmb6H
    fin-0.2.1-3yCsbOiLJWfFM0uVewgSfU
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    indexed-traversable-0.1.2-55rCITp0bj2K4TSTU28RrG
    semigroupoids-5.3.7-HwCM6hSIfxCIEi8aYGOr6m

haddock-interfaces:   /usr/share/doc/haskell-ral/html/ral.haddock
haddock-html:         /usr/share/doc/haskell-ral/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

