#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 non-negative
version:              0.1.2
visibility:           public
id:                   non-negative-0.1.2-J8tV5vWo71E1FvcpGZwAHY
key:                  non-negative-0.1.2-J8tV5vWo71E1FvcpGZwAHY
license:              LicenseRef-GPL
maintainer:           Henning Thielemann <haskell@henning-thielemann.de>
author:               Henning Thielemann <haskell@henning-thielemann.de>
homepage:             http://code.haskell.org/~thielema/non-negative/
synopsis:             Non-negative numbers
description:
    Provides a class for non-negative numbers,
    a wrapper which can turn any ordered numeric type into a member of that class,
    and a lazy number type for non-negative numbers
    (a generalization of Peano numbers).
    This library is used by the @event-list@ package.

category:             Math
abi:                  3a676893eb6022d9dea82a9d384c627c
exposed:              True
exposed-modules:
    Numeric.NonNegative.Chunky Numeric.NonNegative.Class
    Numeric.NonNegative.Wrapper

hidden-modules:       Numeric.NonNegative.ChunkyPrivate
import-dirs:          /usr/lib/ghc-9.0.2/site-local/non-negative-0.1.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/non-negative-0.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-non-negative
hs-libraries:         HSnon-negative-0.1.2-J8tV5vWo71E1FvcpGZwAHY
depends:
    QuickCheck-2.14.2-JoFwhdHSVnjCwZaPGQEEzD base-4.15.1.0
    utility-ht-0.0.16-5FkXBpGolEP23gUJLQS5QH

haddock-interfaces:
    /usr/share/doc/haskell-non-negative/html/non-negative.haddock

haddock-html:         /usr/share/doc/haskell-non-negative/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

