#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 nettle
version:              0.3.0
visibility:           public
id:                   nettle-0.3.0-8qVdvaF51A3AJM581PImaL
key:                  nettle-0.3.0-8qVdvaF51A3AJM581PImaL
license:              MIT
copyright:            Stefan Bühler <stbuehler@web.de>
maintainer:           Stefan Bühler <stbuehler@web.de>
author:               Stefan Bühler <stbuehler@web.de>
homepage:             https://github.com/stbuehler/haskell-nettle
synopsis:             safe nettle binding
description:
    safe binding for the nettle (<http://www.lysator.liu.se/~nisse/nettle/nettle.html>) library.
    Tested with 3.4, might work with 3.2 (but not earlier).

category:             Cryptography
abi:                  83991556e2583def2749818fa27277c2
exposed:              True
exposed-modules:
    Crypto.Nettle.CCM Crypto.Nettle.ChaChaPoly1305
    Crypto.Nettle.Ciphers Crypto.Nettle.HMAC Crypto.Nettle.Hash
    Crypto.Nettle.KeyedHash Crypto.Nettle.UMAC

hidden-modules:
    Crypto.Nettle.Ciphers.Internal Crypto.Nettle.Ciphers.ForeignImports
    Crypto.Nettle.Hash.ForeignImports Crypto.Nettle.Hash.Types
    Nettle.Utils

import-dirs:          /usr/lib/ghc-9.0.2/site-local/nettle-0.3.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/nettle-0.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-nettle
hs-libraries:         HSnettle-0.3.0-8qVdvaF51A3AJM581PImaL
extra-libraries:      nettle
depends:
    base-4.15.1.0 byteable-0.1.1-F5eQFmfGgxkLWRm11Wu8en
    bytestring-0.10.12.1
    crypto-cipher-types-0.0.9-8dNq76lIVvq61pUzJfYm3b
    securemem-0.1.10-IeO5K0X0mzS7xQCiSaDnT0
    tagged-0.8.6.1-79gYUUazit6EfoPS33FHdR

haddock-interfaces:   /usr/share/doc/haskell-nettle/html/nettle.haddock
haddock-html:         /usr/share/doc/haskell-nettle/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

