#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ListLike
version:              4.7.7
visibility:           public
id:                   ListLike-4.7.7-KgqMRE40wAEEVgBcs3oTRH
key:                  ListLike-4.7.7-KgqMRE40wAEEVgBcs3oTRH
license:              BSD-3-Clause
copyright:            Copyright (c) 2007-2008 John Goerzen
maintainer:           David Fox <dsf@seereason.com>, Andreas Abel
author:               John Goerzen
stability:            Stable
homepage:             http://github.com/ddssff/listlike
synopsis:             Generalized support for list-like structures
description:
    Generalized support for list-like structures in Haskell.

    The ListLike module provides a common interface to the various Haskell
    types that are list-like.  Predefined interfaces include standard
    Haskell lists, Arrays, ByteStrings, and lazy ByteStrings.  Custom
    types can easily be made ListLike instances as well.

    ListLike also provides for String-like types, such as String and
    ByteString, for types that support input and output, and for types that can handle
    infinite lists.

category:             list, string, text, bytestring, vector
abi:                  e08ffcc40ebf3602bba1c075415ff5bf
exposed:              True
exposed-modules:
    Data.ListLike Data.ListLike.Base Data.ListLike.CharString
    Data.ListLike.Chars Data.ListLike.DList Data.ListLike.FMList
    Data.ListLike.FoldableLL Data.ListLike.IO Data.ListLike.Instances
    Data.ListLike.String Data.ListLike.Text Data.ListLike.Text.Builder
    Data.ListLike.Text.Text Data.ListLike.Text.TextLazy
    Data.ListLike.UTF8 Data.ListLike.Utils Data.ListLike.Vector
    Data.ListLike.Vector.Generic Data.ListLike.Vector.Storable
    Data.ListLike.Vector.Unboxed Data.ListLike.Vector.Vector

import-dirs:          /usr/lib/ghc-9.0.2/site-local/ListLike-4.7.7
library-dirs:         /usr/lib/ghc-9.0.2/site-local/ListLike-4.7.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-listlike
hs-libraries:         HSListLike-4.7.7-KgqMRE40wAEEVgBcs3oTRH
depends:
    array-0.5.4.0 base-4.15.1.0 bytestring-0.10.12.1 containers-0.6.4.1
    deepseq-1.4.5.0 dlist-1.0-ImNlUre2rHgIkuGbqNQCOO
    fmlist-0.9.4-5YEANFYAIh6LJ1NuRjQBv2 text-1.2.5.0
    utf8-string-1.0.2-Fg3PN5UX3ZfnukMwwaDpj
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:   /usr/share/doc/haskell-listlike/html/ListLike.haddock
haddock-html:         /usr/share/doc/haskell-listlike/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

