#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 leancheck
version:              1.0.0
visibility:           public
id:                   leancheck-1.0.0-8Do1ewYGlbFBiqN8VYgqJz
key:                  leancheck-1.0.0-8Do1ewYGlbFBiqN8VYgqJz
license:              BSD-3-Clause
maintainer:           Rudy Matela <rudy@matela.com.br>
author:               Rudy Matela <rudy@matela.com.br>
homepage:             https://github.com/rudymatela/leancheck#readme
synopsis:             Enumerative property-based testing
description:
    LeanCheck is a simple enumerative property-based testing library.

    Properties are defined as Haskell functions returning a boolean value which
    should be true for all possible choices of argument values.    LeanCheck
    applies enumerated argument values to these properties in search for a
    counterexample.  Properties can be viewed as parameterized unit tests.

    LeanCheck works by producing tiers of test values: a possibly infinite list
    of finite sublists of same-and-increasingly-sized values.

    LeanCheck has lean core with only 200 lines of Haskell code.

category:             Testing
abi:                  62bc3e29e6a2cc86acabbbd87d302b3b
exposed:              True
exposed-modules:
    Test.LeanCheck Test.LeanCheck.Basic Test.LeanCheck.Core
    Test.LeanCheck.Derive Test.LeanCheck.Error Test.LeanCheck.Function
    Test.LeanCheck.Function.Eq Test.LeanCheck.Function.List
    Test.LeanCheck.Function.Listable
    Test.LeanCheck.Function.Listable.ListsOfPairs
    Test.LeanCheck.Function.ListsOfPairs Test.LeanCheck.Function.Ord
    Test.LeanCheck.Function.Show
    Test.LeanCheck.Function.Show.EightLines
    Test.LeanCheck.Function.Show.FourCases
    Test.LeanCheck.Function.ShowFunction Test.LeanCheck.Generic
    Test.LeanCheck.IO Test.LeanCheck.Stats Test.LeanCheck.Tiers
    Test.LeanCheck.Utils Test.LeanCheck.Utils.Operators
    Test.LeanCheck.Utils.TypeBinding Test.LeanCheck.Utils.Types

import-dirs:          /usr/lib/ghc-9.0.2/site-local/leancheck-1.0.0
library-dirs:         /usr/lib/ghc-9.0.2/site-local/leancheck-1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-leancheck
hs-libraries:         HSleancheck-1.0.0-8Do1ewYGlbFBiqN8VYgqJz
depends:              base-4.15.1.0 template-haskell-2.17.0.0
haddock-interfaces:   /usr/share/doc/haskell-leancheck/html/leancheck.haddock
haddock-html:         /usr/share/doc/haskell-leancheck/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

