#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 jose
version:              0.10
visibility:           public
id:                   jose-0.10-9kOJHSpKcVAHBC9N2Efo1m
key:                  jose-0.10-9kOJHSpKcVAHBC9N2Efo1m
license:              Apache-2.0
copyright:            Copyright (C) 2013-2021  Fraser Tweedale
maintainer:           frase@frase.id.au
author:               Fraser Tweedale
homepage:             https://github.com/frasertweedale/hs-jose
synopsis:
    JSON Object Signing and Encryption (JOSE) and JSON Web Token (JWT) library

description:

    Implementation of JSON Object Signing and Encryption
    (JOSE) and JSON Web Token (JWT; RFC 7519).

    The JSON Web Signature (JWS; RFC 7515) implementation is complete.

    EdDSA signatures (RFC 8037) and secp256k1 (RFC 8812) are supported.

    JWK Thumbprint (RFC 7638) is supported.

    JSON Web Encryption (JWE; RFC 7516) is not yet implemented.

    The __ECDSA implementation is vulnerable to timing attacks__ and
    should only be used for verification.

category:             Cryptography
abi:                  111b991f4f21655cbf223e8b00c7cfa3
exposed:              True
exposed-modules:
    Crypto.JOSE Crypto.JOSE.AESKW Crypto.JOSE.Compact Crypto.JOSE.Error
    Crypto.JOSE.Header Crypto.JOSE.JWA.JWE Crypto.JOSE.JWA.JWE.Alg
    Crypto.JOSE.JWA.JWK Crypto.JOSE.JWA.JWS Crypto.JOSE.JWE
    Crypto.JOSE.JWK Crypto.JOSE.JWK.Store Crypto.JOSE.JWS
    Crypto.JOSE.Types Crypto.JWT

hidden-modules:
    Crypto.JOSE.TH Crypto.JOSE.Types.Internal Crypto.JOSE.Types.URI

import-dirs:          /usr/lib/ghc-9.0.2/site-local/jose-0.10
library-dirs:         /usr/lib/ghc-9.0.2/site-local/jose-0.10
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-jose
hs-libraries:         HSjose-0.10-9kOJHSpKcVAHBC9N2Efo1m
depends:
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT base-4.15.1.0
    base64-bytestring-1.2.1.0-iG6YBGhLkRJagBsFqRAI2
    bytestring-0.10.12.1 concise-0.1.0.1-9n6Ri02c17GGbZfOC6c09q
    containers-0.6.4.1 cryptonite-0.30-1Rfjg2UxJ0tAQrwWuK0NlN
    lens-5.1.1-8cVW77ucFRGIbO4yMEfpoM
    memory-0.17.0-3DbDQrj54CLAPAnWUJBJ4b
    monad-time-0.4.0.0-85n5Y4sAC912T5q7IVV2id mtl-2.2.2
    network-uri-2.6.4.1-CJy9K6CUGBYDMBcoIm8TMq
    template-haskell-2.17.0.0 text-1.2.5.0 time-1.9.3
    x509-1.7.7-4RJlLqHhASs8XHm3liUwF0

haddock-interfaces:   /usr/share/doc/haskell-jose/html/jose.haddock
haddock-html:         /usr/share/doc/haskell-jose/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

