#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hslua-packaging
version:              2.2.1
visibility:           public
id:                   hslua-packaging-2.2.1-1zK1XGBqEoD7PjQx9lUfAu
key:                  hslua-packaging-2.2.1-1zK1XGBqEoD7PjQx9lUfAu
license:              MIT
copyright:            © 2019-2022 Albert Krewinkel
maintainer:           albert+hslua@zeitkraut.de
author:               Albert Krewinkel
homepage:             https://hslua.org/
synopsis:             Utilities to build Lua modules.
description:
    Utilities to package up Haskell functions and
    values into a Lua module.

    This package is part of HsLua, a Haskell framework
    built around the embeddable scripting language
    <https://lua.org Lua>.

category:             Foreign
abi:                  eb6a8386e4ebed6f26a80e5e1b440b3f
exposed:              True
exposed-modules:
    HsLua.Packaging HsLua.Packaging.Convenience
    HsLua.Packaging.Documentation HsLua.Packaging.Function
    HsLua.Packaging.Module HsLua.Packaging.Rendering
    HsLua.Packaging.Types HsLua.Packaging.UDType

import-dirs:          /usr/lib/ghc-9.0.2/site-local/hslua-packaging-2.2.1
library-dirs:         /usr/lib/ghc-9.0.2/site-local/hslua-packaging-2.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hslua-packaging
hs-libraries:         HShslua-packaging-2.2.1-1zK1XGBqEoD7PjQx9lUfAu
depends:
    base-4.15.1.0 containers-0.6.4.1
    hslua-core-2.2.1-6WQedKe1YRAomlPNCzRv2
    hslua-marshalling-2.2.1-EeEmfmTmrwkJWLfmnZtave
    hslua-objectorientation-2.2.1-CLyGlRkFiUfKqOEGw5m3mo mtl-2.2.2
    text-1.2.5.0

haddock-interfaces:
    /usr/share/doc/haskell-hslua-packaging/html/hslua-packaging.haddock

haddock-html:         /usr/share/doc/haskell-hslua-packaging/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

