#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 commonmark
version:              0.2.2
visibility:           public
id:                   commonmark-0.2.2-DBus3b9sqSI4PDFIf8KWvt
key:                  commonmark-0.2.2-DBus3b9sqSI4PDFIf8KWvt
license:              BSD-3-Clause
copyright:            2018-2021 John MacFarlane
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
homepage:             https://github.com/jgm/commonmark-hs
synopsis:             Pure Haskell commonmark parser.
description:
    This library provides the core data types and functions
    for parsing commonmark (<https://spec.commonmark.org>).
    The parser is fully commonmark-compliant and passes the test
    suite.  It is designed to be customizable and easily extensible.
    To customize the output, create an AST, or support a new output
    format, one need only define some new typeclass instances.
    It is also easy to add new syntax elements or modify existing ones.

    Accurate information about source positions is available
    for all block and inline elements.  Thus the library can be
    used to create an accurate syntax highlighter or
    an editor with live preview.

    The parser has been designed for robust performance
    even in pathological cases that tend to cause stack overflows or
    exponential slowdowns in other parsers, with parsing speed that
    varies linearly with input length.

    Related packages:

    - commonmark-extensions (which defines a number of syntax extensions)
    - commonmark-pandoc (which allows using this parser to create a Pandoc
    structure)
    - commonmark-cli (a command-line tool for converting and
    syntax-highlighting commonmark documents)

category:             Text
abi:                  2892f8729f5ac378d67f98d328c24899
exposed:              True
exposed-modules:
    Commonmark Commonmark.Blocks Commonmark.Entity Commonmark.Html
    Commonmark.Inlines Commonmark.Parser Commonmark.ReferenceMap
    Commonmark.SourceMap Commonmark.Syntax Commonmark.Tag
    Commonmark.TokParsers Commonmark.Tokens Commonmark.Types

import-dirs:          /usr/lib/ghc-9.0.2/site-local/commonmark-0.2.2
library-dirs:         /usr/lib/ghc-9.0.2/site-local/commonmark-0.2.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-commonmark
hs-libraries:         HScommonmark-0.2.2-DBus3b9sqSI4PDFIf8KWvt
depends:
    base-4.15.1.0 bytestring-0.10.12.1 containers-0.6.4.1
    parsec-3.1.14.0 text-1.2.5.0 transformers-0.5.6.2
    unicode-data-0.4.0-3m78rQMSbts3opZJ5tFoUo
    unicode-transforms-0.4.0.1-BPJclhxoeaPJkCCeQn4Ic

haddock-interfaces:   /usr/share/doc/haskell-commonmark/html/commonmark.haddock
haddock-html:         /usr/share/doc/haskell-commonmark/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

