#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-lib
version:              1.6.4
visibility:           public
id:                   clash-lib-1.6.4-8Fn8uF8fA1sIsIYF5qKydu
key:                  clash-lib-1.6.4-8Fn8uF8fA1sIsIYF5qKydu
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2019, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - As a library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * The CoreHW internal language: SystemF + Letrec + Case-decomposition

    * The normalisation process that brings CoreHW in a normal form that can be
    converted to a netlist

    * Blackbox/Primitive Handling


    Front-ends (for: parsing, typecheck, etc.) are provided by separate packages:

    * <https://hackage.haskell.org/package/clash-ghc GHC/Haskell Frontend>

    * <https://github.com/christiaanb/Idris-dev Idris Frontend>


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  1ab651986f3a49395951ea43b2aa03cb
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation.ClashLib Clash.Backend
    Clash.Backend.SystemVerilog Clash.Backend.VHDL
    Clash.Backend.Verilog Clash.Core.DataCon Clash.Core.EqSolver
    Clash.Core.Evaluator.Types Clash.Core.FreeVars
    Clash.Core.HasFreeVars Clash.Core.HasType Clash.Core.Literal
    Clash.Core.Name Clash.Core.PartialEval
    Clash.Core.PartialEval.AsTerm Clash.Core.PartialEval.Monad
    Clash.Core.PartialEval.NormalForm Clash.Core.Pretty
    Clash.Core.Subst Clash.Core.Term Clash.Core.TermInfo
    Clash.Core.TermLiteral Clash.Core.TermLiteral.TH Clash.Core.TyCon
    Clash.Core.Type Clash.Core.TysPrim Clash.Core.Util Clash.Core.Var
    Clash.Core.VarEnv Clash.Debug Clash.Driver Clash.Driver.Manifest
    Clash.Driver.Types Clash.Edalize.Edam Clash.Netlist
    Clash.Netlist.BlackBox Clash.Netlist.BlackBox.Parser
    Clash.Netlist.BlackBox.Types Clash.Netlist.BlackBox.Util
    Clash.Netlist.Id Clash.Netlist.Id.Common Clash.Netlist.Id.Internal
    Clash.Netlist.Id.SystemVerilog Clash.Netlist.Id.VHDL
    Clash.Netlist.Id.Verilog Clash.Netlist.Types Clash.Netlist.Util
    Clash.Normalize Clash.Normalize.PrimitiveReductions
    Clash.Normalize.Primitives Clash.Normalize.Strategy
    Clash.Normalize.Transformations Clash.Normalize.Transformations.ANF
    Clash.Normalize.Transformations.Case
    Clash.Normalize.Transformations.Cast
    Clash.Normalize.Transformations.DEC
    Clash.Normalize.Transformations.EtaExpand
    Clash.Normalize.Transformations.Inline
    Clash.Normalize.Transformations.Letrec
    Clash.Normalize.Transformations.MultiPrim
    Clash.Normalize.Transformations.Reduce
    Clash.Normalize.Transformations.SeparateArgs
    Clash.Normalize.Transformations.Specialize
    Clash.Normalize.Transformations.XOptimize Clash.Normalize.Types
    Clash.Normalize.Util Clash.Pretty Clash.Primitives.DSL
    Clash.Primitives.GHC.Int Clash.Primitives.GHC.Literal
    Clash.Primitives.GHC.Word Clash.Primitives.Intel.ClockGen
    Clash.Primitives.Sized.Signed Clash.Primitives.Sized.ToInteger
    Clash.Primitives.Sized.Vector Clash.Primitives.Types
    Clash.Primitives.Util Clash.Primitives.Verification
    Clash.Rewrite.Combinators Clash.Rewrite.Types Clash.Rewrite.Util
    Clash.Rewrite.WorkFree Clash.Unique Clash.Util Clash.Util.Eq
    Clash.Util.Graph Clash.Util.Interpolate Clash.Verification.Pretty
    Data.Aeson.Extra Data.Text.Prettyprint.Doc.Extra

hidden-modules:
    Clash.Annotations.TopEntity.Extra Data.IntMap.Extra Data.List.Extra
    Data.Map.Ordered.Extra Data.Monoid.Extra
    Data.Primitive.ByteArray.Extra Data.Set.Ordered.Extra
    Data.Text.Extra GHC.BasicTypes.Extra GHC.SrcLoc.Extra
    Paths_clash_lib

import-dirs:          /usr/lib/ghc-9.0.2/site-local/clash-lib-1.6.4
library-dirs:         /usr/lib/ghc-9.0.2/site-local/clash-lib-1.6.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-clash-lib
hs-libraries:         HSclash-lib-1.6.4-8Fn8uF8fA1sIsIYF5qKydu
depends:
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT
    aeson-pretty-0.8.9-HIKDmSQGmI0DQYiuXhljjd
    ansi-terminal-0.11.3-4sOL9w5QIphDlJIIpaWFJL array-0.5.4.0
    async-2.2.4-9EoKZTgytm43s60GeTAIZR
    attoparsec-0.14.4-9SQv4o2tq0k4n7CegIwza1 base-4.15.1.0
    base16-bytestring-1.0.2.0-JAhsVwuAYUHf0LicTQmUd binary-0.8.8.0
    bytestring-0.10.12.1 clash-prelude-1.6.4-BJJFSzO5uP13RmWNJeGbVN
    concurrent-supply-0.1.8-8KZUWJnJtBN5d4OKnaNBZ6 containers-0.6.4.1
    cryptohash-sha256-0.11.102.1-8ZeO4nK1S0cB7jsEy9ybtK
    data-binary-ieee754-0.4.4-6nKeQnWkGoLJGejCHaRaWS
    data-default-0.7.1.1-BkZarJ3J3008hHF2JOuYeW deepseq-1.4.5.0
    directory-1.3.6.2 dlist-1.0-ImNlUre2rHgIkuGbqNQCOO
    exceptions-0.10.4 extra-1.7.12-DPTGYhuNp118MPDFhQYU8g
    filepath-1.4.2.1 ghc-9.0.2 ghc-bignum-1.1 ghc-boot-th-9.0.2
    hashable-1.4.1.0-LUNCtsUMK7L3ZB2KEKWF7F
    haskell-src-meta-0.8.11-3aFsA14mJI277H97rtizjl
    hint-0.9.0.6-2hnjodGzxxq1kKqbEjvuCA
    interpolate-0.2.1-KADYh7NKAttF853QCIhZPr
    lens-5.1.1-8cVW77ucFRGIbO4yMEfpoM mtl-2.2.2
    ordered-containers-0.2.2-3ZJFCOHv4Xt5NYft4y5Gmm
    pretty-show-1.10-30ddFMLbEm1DQ0GcmAHjnN
    prettyprinter-1.7.1-Kh082I8LQyjLFudtJnG2xP
    primitive-0.7.4.0-CfTIpXUHtu665Ilg6bT1BW template-haskell-2.17.0.0
    temporary-1.3-HXIdO020OG29nAlGx7vsUT
    terminal-size-0.3.3-9JiTHA73QXVH7lW7Leoqqc text-1.2.5.0 time-1.9.3
    transformers-0.5.6.2 trifecta-2.1.2-3aD2Lxwj3TZ8Q7VnrmhIPh
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf
    vector-binary-instances-0.2.5.2-2krkEey0awz1rfTRut7xIo
    yaml-0.11.8.0-EFN1CMgVIdSAIGSdgvEPUP

haddock-interfaces:   /usr/share/doc/haskell-clash-lib/html/clash-lib.haddock
haddock-html:         /usr/share/doc/haskell-clash-lib/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

