#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 aeson-pretty
version:              0.8.9
visibility:           public
id:                   aeson-pretty-0.8.9-HIKDmSQGmI0DQYiuXhljjd
key:                  aeson-pretty-0.8.9-HIKDmSQGmI0DQYiuXhljjd
license:              BSD-3-Clause
copyright:            Copyright 2011 Falko Peters
maintainer:           Martijn Bastiaan <martijn@hmbastiaan.nl>
author:               Falko Peters <falko.peters@gmail.com>
stability:            experimental
homepage:             http://github.com/informatikr/aeson-pretty
synopsis:             JSON pretty-printing library and command-line tool.
description:
    A JSON pretty-printing library compatible with aeson as well as
    a command-line tool to improve readabilty of streams of JSON data.

    The /library/ provides the function "encodePretty". It is a drop-in
    replacement for aeson'\''s "encode" function, producing JSON-ByteStrings for
    human readers.

    The /command-line tool/ reads JSON from stdin and writes prettified JSON
    to stdout. It also offers a complementary "compact"-mode, essentially the
    opposite of pretty-printing. If you specify @-flib-only@ like this

    > cabal install -flib-only aeson-pretty

    the command-line tool will NOT be installed.

category:             Text, Web, JSON, Pretty Printer
abi:                  40f0c233038c894cce54b3dd79fd7b4e
exposed:              True
exposed-modules:      Data.Aeson.Encode.Pretty
import-dirs:          /usr/lib/ghc-9.0.2/site-local/aeson-pretty-0.8.9
library-dirs:         /usr/lib/ghc-9.0.2/site-local/aeson-pretty-0.8.9
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson-pretty
hs-libraries:         HSaeson-pretty-0.8.9-HIKDmSQGmI0DQYiuXhljjd
depends:
    aeson-2.1.0.0-3wSqLBA0fU13NhfXDmBpwT base-4.15.1.0
    base-compat-0.12.2-l1EqrM7Qwu6Pq9d4drKFu bytestring-0.10.12.1
    scientific-0.3.7.0-1l3L5iYBn9JD8GP8kLjgG7 text-1.2.5.0
    unordered-containers-0.2.19.1-1t66PwyRMuzEgWVME6Xx4r
    vector-0.13.0.0-80dNWv5W93FGfZf7Ao5mAf

haddock-interfaces:
    /usr/share/doc/haskell-aeson-pretty/html/aeson-pretty.haddock

haddock-html:         /usr/share/doc/haskell-aeson-pretty/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

