/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.junit.IgnoredTestDescriptorProvider;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitTestEventAdapter
extends RunListener {
    private static final Pattern DESCRIPTOR_PATTERN = Pattern.compile("(.*)\\((.*)\\)(\\[\\d+])?", 32);
    private final IdGenerator<?> idGenerator;
    private final TestResultProcessor resultProcessor;
    private final Clock clock;
    private final Object lock = new Object();
    private final Map<Description, TestDescriptorInternal> executing = new HashMap<Description, TestDescriptorInternal>();
    private final Set<Description> assumptionFailed = new HashSet<Description>();

    public JUnitTestEventAdapter(TestResultProcessor resultProcessor, Clock clock, IdGenerator<?> idGenerator) {
        this.resultProcessor = resultProcessor;
        this.clock = clock;
        this.idGenerator = idGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStarted(Description description) {
        TestDescriptorInternal descriptor = this.nullSafeDescriptor(this.idGenerator.generateId(), description);
        Object object = this.lock;
        synchronized (object) {
            TestDescriptorInternal oldTest = this.executing.put(description, descriptor);
            assert (oldTest == null) : String.format("Unexpected start event for %s", description);
        }
        this.resultProcessor.started(descriptor, this.startEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailure(Failure failure) {
        TestDescriptorInternal testInternal;
        TestDescriptorInternal descriptor = this.nullSafeDescriptor(this.idGenerator.generateId(), failure.getDescription());
        Object object = this.lock;
        synchronized (object) {
            testInternal = this.executing.get(failure.getDescription());
        }
        boolean needEndEvent = false;
        if (testInternal == null) {
            needEndEvent = true;
            testInternal = descriptor;
            this.resultProcessor.started(testInternal, this.startEvent());
        }
        this.resultProcessor.failure(testInternal.getId(), failure.getException());
        if (needEndEvent) {
            this.resultProcessor.completed(testInternal.getId(), new TestCompleteEvent(this.clock.getCurrentTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAssumptionFailure(Failure failure) {
        Object object = this.lock;
        synchronized (object) {
            this.assumptionFailed.add(failure.getDescription());
        }
    }

    public void testIgnored(Description description) throws Exception {
        if (JUnitTestEventAdapter.methodName(description) == null) {
            this.processIgnoredClass(description);
        } else {
            TestDescriptorInternal descriptor = this.descriptor(this.idGenerator.generateId(), description);
            this.resultProcessor.started(descriptor, this.startEvent());
            this.resultProcessor.completed(descriptor.getId(), new TestCompleteEvent(this.clock.getCurrentTime(), TestResult.ResultType.SKIPPED));
        }
    }

    private void processIgnoredClass(Description description) throws Exception {
        IgnoredTestDescriptorProvider provider = new IgnoredTestDescriptorProvider();
        String className = JUnitTestEventAdapter.className(description);
        for (Description childDescription : provider.getAllDescriptions(description, className)) {
            this.testIgnored(childDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFinished(Description description) {
        TestResult.ResultType resultType;
        TestDescriptorInternal testInternal;
        long endTime = this.clock.getCurrentTime();
        Object object = this.lock;
        synchronized (object) {
            testInternal = this.executing.remove(description);
            if (testInternal == null && this.executing.size() == 1) {
                testInternal = this.executing.values().iterator().next();
                this.executing.clear();
            }
            assert (testInternal != null) : String.format("Unexpected end event for %s", description);
            resultType = this.assumptionFailed.remove(description) ? TestResult.ResultType.SKIPPED : null;
        }
        this.resultProcessor.completed(testInternal.getId(), new TestCompleteEvent(endTime, resultType));
    }

    private TestDescriptorInternal descriptor(Object id, Description description) {
        return new DefaultTestDescriptor(id, JUnitTestEventAdapter.className(description), JUnitTestEventAdapter.methodName(description));
    }

    private TestDescriptorInternal nullSafeDescriptor(Object id, Description description) {
        String methodName = JUnitTestEventAdapter.methodName(description);
        if (methodName != null) {
            return new DefaultTestDescriptor(id, JUnitTestEventAdapter.className(description), methodName);
        }
        return new DefaultTestDescriptor(id, JUnitTestEventAdapter.className(description), "classMethod");
    }

    public static String methodName(Description description) {
        return JUnitTestEventAdapter.methodName(description.toString());
    }

    public static String methodName(String description) {
        Matcher matcher = JUnitTestEventAdapter.methodStringMatcher(description);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String className(Description description) {
        return JUnitTestEventAdapter.className(description.toString());
    }

    public static String className(String description) {
        Matcher matcher = JUnitTestEventAdapter.methodStringMatcher(description);
        return matcher.matches() ? matcher.group(2) : description;
    }

    private static Matcher methodStringMatcher(String description) {
        return DESCRIPTOR_PATTERN.matcher(description);
    }

    private TestStartEvent startEvent() {
        return new TestStartEvent(this.clock.getCurrentTime());
    }
}

