/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.lazy;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.internal.lazy.LockingLazy;
import org.gradle.internal.lazy.UnsafeLazy;

public interface Lazy<T>
extends Supplier<T> {
    default public void use(Consumer<? super T> consumer) {
        consumer.accept(this.get());
    }

    default public <V> V apply(Function<? super T, V> function) {
        return function.apply(this.get());
    }

    default public <V> Lazy<V> map(Function<? super T, V> mapper) {
        return Lazy.unsafe().of(() -> mapper.apply((T)this.get()));
    }

    public static Factory unsafe() {
        return UnsafeLazy::new;
    }

    public static Factory locking() {
        return LockingLazy::new;
    }

    public static interface Factory {
        public <T> Lazy<T> of(Supplier<T> var1);
    }
}

