/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.MutableDiagnosticContext;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirExpressionAnnotationChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirExpressionAnnotationChecker INSTANCE = new FirExpressionAnnotationChecker();

    private FirExpressionAnnotationChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        List<FirAnnotation> annotations2;
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                if (expression2 instanceof FirDeclaration || !(expression2 instanceof FirExpression)) break block13;
                if (!(expression2 instanceof FirBlock)) break block14;
                KtSourceElement ktSourceElement = expression2.getSource();
                if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) break block14;
            }
            return;
        }
        if ((annotations2 = expression2.getAnnotations()).isEmpty()) {
            return;
        }
        HashMap annotationsMap = new HashMap();
        for (FirAnnotation annotation2 : annotations2) {
            boolean bl;
            CheckerContext it;
            Object object;
            void $this$getOrPut$iv;
            AnnotationUseSiteTarget annotationUseSiteTarget = annotation2.getUseSiteTarget();
            if (annotationUseSiteTarget == null) {
                annotationUseSiteTarget = FirAnnotationHelpersKt.getDefaultUseSiteTarget(expression2, annotation2, context2);
            }
            AnnotationUseSiteTarget useSiteTarget = annotationUseSiteTarget;
            Map map = annotationsMap;
            ConeKotlinType key$iv = FirTypeUtilsKt.getConeType(annotation2.getAnnotationTypeRef());
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List existingTargetsForAnnotation = (List)object;
            boolean $i$f$withSuppressedDiagnostics = false;
            List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(annotation2);
            if (arguments$iv != null) {
                DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
                if (diagnosticContext == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                }
                it = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                bl = false;
                if (!FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation2, context2.getSession()).contains((Object)KotlinTarget.EXPRESSION)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), (Object)"expression", (DiagnosticContext)context2, null, 16, null);
                }
                FirAnnotationHelpersKt.checkRepeatedAnnotation(useSiteTarget, existingTargetsForAnnotation, annotation2, context2, reporter);
            } else {
                it = (CheckerContext)((MutableDiagnosticContext)context2);
                bl = false;
                if (!FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation2, context2.getSession()).contains((Object)KotlinTarget.EXPRESSION)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), (Object)"expression", (DiagnosticContext)context2, null, 16, null);
                }
                FirAnnotationHelpersKt.checkRepeatedAnnotation(useSiteTarget, existingTargetsForAnnotation, annotation2, context2, reporter);
            }
            existingTargetsForAnnotation.add(useSiteTarget);
        }
    }
}

