/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.general.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gephi.datalab.api.SearchReplaceController;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeFormat;
import org.gephi.utils.HTMLEscape;
import org.joda.time.DateTimeZone;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class SearchReplaceUI
extends JPanel {
    private static final Color invalidRegexColor = new Color(254, 150, 150);
    private Mode mode = Mode.NODES_TABLE;
    private final SearchReplaceController searchReplaceController;
    private final DataTablesController dataTablesController;
    private SearchReplaceController.SearchOptions searchOptions;
    private SearchReplaceController.SearchResult searchResult = null;
    private Pattern regexPattern;
    private boolean active = false;
    private JCheckBox caseSensitiveCheckBox;
    private JComboBox columnsToSearchComboBox;
    private JLabel columnsToSearchLabel;
    private JButton findNextButton;
    private JSeparator jSeparator1;
    private JCheckBox matchWholeValueCheckBox;
    private JRadioButton normalSearchModeRadioButton;
    private JCheckBox regexReplaceCheckBox;
    private JRadioButton regexSearchModeRadioButton;
    private JButton replaceAllButton;
    private JButton replaceButton;
    private JLabel replaceLabel;
    private JTextField replaceText;
    private JLabel resultLabel;
    private JTextPane resultText;
    private JScrollPane scroll;
    private JLabel searchLabel;
    private ButtonGroup searchModeButtonGroup;
    private JTextField searchText;

    public SearchReplaceUI() {
        this.initComponents();
        this.searchReplaceController = (SearchReplaceController)Lookup.getDefault().lookup(SearchReplaceController.class);
        this.dataTablesController = (DataTablesController)Lookup.getDefault().lookup(DataTablesController.class);
        this.createSearchOptions();
        this.refreshSearchOptions();
        this.searchText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchReplaceUI.this.refreshSearchOptions();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchReplaceUI.this.refreshSearchOptions();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchReplaceUI.this.refreshSearchOptions();
            }
        });
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.createSearchOptions();
        this.resultText.setText("");
        this.refreshSearchOptions();
    }

    public void refreshSearchOptions() {
        this.refreshRegexPattern();
        this.searchOptions.setOnlyMatchWholeAttributeValue(this.matchWholeValueCheckBox.isSelected());
        this.searchOptions.setUseRegexReplaceMode(this.regexReplaceCheckBox.isEnabled() && this.regexReplaceCheckBox.isSelected());
        if (this.columnsToSearchComboBox.getSelectedIndex() <= 0) {
            this.searchOptions.setColumnsToSearch(new int[0]);
        } else {
            this.searchOptions.setColumnsToSearch(new int[]{((ColumnWrapper)this.columnsToSearchComboBox.getSelectedItem()).column.getIndex()});
        }
        this.refreshControls();
    }

    private void createSearchOptions() {
        Table table;
        boolean onlyVisibleElements = ((DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)).isShowOnlyVisible();
        this.searchResult = null;
        this.columnsToSearchComboBox.removeAllItems();
        if (this.mode == Mode.NODES_TABLE) {
            Node[] nodes = onlyVisibleElements ? ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraphVisible().getNodes().toArray() : new Node[]{};
            this.searchOptions = new SearchReplaceController.SearchOptions(nodes, null);
            table = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable();
        } else {
            Edge[] edges = onlyVisibleElements ? ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getGraphVisible().getEdges().toArray() : new Edge[]{};
            this.searchOptions = new SearchReplaceController.SearchOptions(edges, null);
            table = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getEdgeTable();
        }
        this.columnsToSearchComboBox.addItem(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.allColumns"));
        for (Column c : table) {
            this.columnsToSearchComboBox.addItem(new ColumnWrapper(c));
        }
    }

    private void refreshRegexPattern() {
        try {
            String text = this.searchText.getText();
            if (this.normalSearchModeRadioButton.isSelected()) {
                text = Pattern.quote(text);
                this.regexReplaceCheckBox.setEnabled(false);
                this.regexReplaceCheckBox.setSelected(false);
            } else {
                this.regexReplaceCheckBox.setEnabled(true);
            }
            this.regexPattern = !this.caseSensitiveCheckBox.isSelected() ? Pattern.compile(text, 2) : Pattern.compile(text);
            this.searchOptions.setRegexPattern(this.regexPattern);
            this.searchText.setBackground(Color.WHITE);
        }
        catch (PatternSyntaxException ex) {
            this.searchText.setBackground(invalidRegexColor);
            this.regexPattern = null;
        }
    }

    private void refreshControls() {
        if (this.searchResult == null) {
            this.replaceButton.setEnabled(false);
            this.replaceAllButton.setEnabled(false);
        } else {
            boolean canReplace = this.searchReplaceController.canReplace(this.searchResult);
            this.replaceButton.setEnabled(canReplace);
            this.replaceAllButton.setEnabled(this.columnsToSearchComboBox.getSelectedIndex() <= 0 || canReplace);
        }
        if (this.regexPattern == null) {
            this.findNextButton.setEnabled(false);
            this.replaceButton.setEnabled(false);
            this.replaceAllButton.setEnabled(false);
        } else {
            this.findNextButton.setEnabled(true);
        }
    }

    private void showSearchResult() {
        if (this.searchResult != null) {
            Object value;
            Table table;
            if (this.mode == Mode.NODES_TABLE) {
                Node node = this.searchResult.getFoundNode();
                this.dataTablesController.setNodeTableSelection(new Node[]{node});
                if (!this.dataTablesController.isNodeTableMode()) {
                    this.dataTablesController.selectNodesTable();
                }
                table = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable();
                value = node.getAttribute(table.getColumn(this.searchResult.getFoundColumnIndex()));
            } else {
                Edge edge = this.searchResult.getFoundEdge();
                this.dataTablesController.setEdgeTableSelection(new Edge[]{edge});
                if (!this.dataTablesController.isEdgeTableMode()) {
                    this.dataTablesController.selectEdgesTable();
                }
                table = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getEdgeTable();
                value = edge.getAttribute(table.getColumn(this.searchResult.getFoundColumnIndex()));
            }
            TimeFormat timeFormat = table.getGraph().getModel().getTimeFormat();
            DateTimeZone timeZone = table.getGraph().getModel().getTimeZone();
            String columnName = this.mode == Mode.NODES_TABLE ? ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable().getColumn(this.searchResult.getFoundColumnIndex()).getTitle() : ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getEdgeTable().getColumn(this.searchResult.getFoundColumnIndex()).getTitle();
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.column", (Object)HTMLEscape.stringToHTMLString((String)columnName)));
            sb.append("<br>");
            if (value != null) {
                String text = AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (DateTimeZone)timeZone);
                sb.append(HTMLEscape.stringToHTMLString((String)text.substring(0, this.searchResult.getStart())));
                sb.append("<font color='blue'>");
                sb.append(HTMLEscape.stringToHTMLString((String)text.substring(this.searchResult.getStart(), this.searchResult.getEnd())));
                sb.append("</font>");
                sb.append(HTMLEscape.stringToHTMLString((String)text.substring(this.searchResult.getEnd())));
            } else {
                sb.append("<font color='blue'>null</font>");
            }
            sb.append("</html>");
            this.resultText.setText(sb.toString());
        } else {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.not.found", (Object)this.searchText.getText()));
            this.resultText.setText("");
        }
    }

    private void nextResult() {
        this.searchResult = this.searchReplaceController.findNext(this.searchOptions);
        this.refreshSearchOptions();
        this.showSearchResult();
    }

    private void showRegexReplaceError() {
        JOptionPane.showMessageDialog(null, NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.regexReplacementError"), NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.dialog.title.error"), 0);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    private void initComponents() {
        this.searchModeButtonGroup = new ButtonGroup();
        this.searchLabel = new JLabel();
        this.replaceLabel = new JLabel();
        this.matchWholeValueCheckBox = new JCheckBox();
        this.normalSearchModeRadioButton = new JRadioButton();
        this.regexSearchModeRadioButton = new JRadioButton();
        this.caseSensitiveCheckBox = new JCheckBox();
        this.findNextButton = new JButton();
        this.replaceButton = new JButton();
        this.replaceAllButton = new JButton();
        this.searchText = new JTextField();
        this.replaceText = new JTextField();
        this.scroll = new JScrollPane();
        this.resultText = new JTextPane();
        this.resultLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.regexReplaceCheckBox = new JCheckBox();
        this.columnsToSearchLabel = new JLabel();
        this.columnsToSearchComboBox = new JComboBox();
        this.searchLabel.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.searchLabel.text"));
        this.replaceLabel.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.replaceLabel.text"));
        this.matchWholeValueCheckBox.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.matchWholeValueCheckBox.text"));
        this.matchWholeValueCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SearchReplaceUI.this.matchWholeValueCheckBoxItemStateChanged(evt);
            }
        });
        this.searchModeButtonGroup.add(this.normalSearchModeRadioButton);
        this.normalSearchModeRadioButton.setSelected(true);
        this.normalSearchModeRadioButton.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.normalSearchModeRadioButton.text"));
        this.normalSearchModeRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SearchReplaceUI.this.normalSearchModeRadioButtonItemStateChanged(evt);
            }
        });
        this.searchModeButtonGroup.add(this.regexSearchModeRadioButton);
        this.regexSearchModeRadioButton.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.regexSearchModeRadioButton.text"));
        this.regexSearchModeRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SearchReplaceUI.this.regexSearchModeRadioButtonItemStateChanged(evt);
            }
        });
        this.caseSensitiveCheckBox.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.caseSensitiveCheckBox.text"));
        this.caseSensitiveCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SearchReplaceUI.this.caseSensitiveCheckBoxItemStateChanged(evt);
            }
        });
        this.findNextButton.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.findNextButton.text"));
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchReplaceUI.this.findNextButtonActionPerformed(evt);
            }
        });
        this.replaceButton.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.replaceButton.text"));
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchReplaceUI.this.replaceButtonActionPerformed(evt);
            }
        });
        this.replaceAllButton.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.replaceAllButton.text"));
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchReplaceUI.this.replaceAllButtonActionPerformed(evt);
            }
        });
        this.searchText.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.searchText.text"));
        this.searchText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SearchReplaceUI.this.searchTextKeyPressed(evt);
            }
        });
        this.replaceText.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.replaceText.text"));
        this.resultText.setContentType(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.resultText.contentType"));
        this.resultText.setEditable(false);
        this.scroll.setViewportView(this.resultText);
        this.resultLabel.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.resultLabel.text"));
        this.regexReplaceCheckBox.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.regexReplaceCheckBox.text"));
        this.regexReplaceCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SearchReplaceUI.this.regexReplaceCheckBoxItemStateChanged(evt);
            }
        });
        this.columnsToSearchLabel.setText(NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.columnsToSearchLabel.text"));
        this.columnsToSearchComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SearchReplaceUI.this.columnsToSearchComboBoxItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 379, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.matchWholeValueCheckBox).addGroup(layout.createSequentialGroup().addComponent(this.normalSearchModeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.regexSearchModeRadioButton)).addGroup(layout.createSequentialGroup().addComponent(this.caseSensitiveCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.regexReplaceCheckBox)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.searchLabel, -1, -1, Short.MAX_VALUE).addComponent(this.replaceLabel, -1, 71, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchText, -1, 160, Short.MAX_VALUE).addComponent(this.replaceText, -1, 160, Short.MAX_VALUE)).addGap(41, 41, 41))).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.replaceAllButton, -1, -1, Short.MAX_VALUE).addComponent(this.replaceButton, -1, -1, Short.MAX_VALUE).addComponent(this.findNextButton, -1, -1, Short.MAX_VALUE))).addComponent(this.scroll, -1, 359, Short.MAX_VALUE).addComponent(this.resultLabel).addGroup(layout.createSequentialGroup().addComponent(this.columnsToSearchLabel, -2, 164, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.columnsToSearchComboBox, 0, 185, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.findNextButton).addGap(35, 35, 35).addComponent(this.replaceButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceAllButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchText, -2, -1, -2).addComponent(this.searchLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.replaceText, -2, -1, -2).addComponent(this.replaceLabel)).addGap(18, 18, 18).addComponent(this.matchWholeValueCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.normalSearchModeRadioButton).addComponent(this.regexSearchModeRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.caseSensitiveCheckBox).addComponent(this.regexReplaceCheckBox)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.columnsToSearchLabel).addComponent(this.columnsToSearchComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroll, -2, 53, -2).addContainerGap()));
    }

    private void normalSearchModeRadioButtonItemStateChanged(ItemEvent evt) {
        this.refreshSearchOptions();
    }

    private void regexSearchModeRadioButtonItemStateChanged(ItemEvent evt) {
        this.refreshSearchOptions();
    }

    private void matchWholeValueCheckBoxItemStateChanged(ItemEvent evt) {
        this.refreshSearchOptions();
    }

    private void caseSensitiveCheckBoxItemStateChanged(ItemEvent evt) {
        this.refreshSearchOptions();
    }

    private void findNextButtonActionPerformed(ActionEvent evt) {
        this.nextResult();
    }

    private void replaceButtonActionPerformed(ActionEvent evt) {
        try {
            this.searchResult = this.searchReplaceController.replace(this.searchResult, this.replaceText.getText());
            this.refreshSearchOptions();
            this.dataTablesController.refreshCurrentTable();
            this.showSearchResult();
        }
        catch (Exception ex) {
            this.showRegexReplaceError();
        }
    }

    private void replaceAllButtonActionPerformed(ActionEvent evt) {
        try {
            int replacementsCount = this.searchReplaceController.replaceAll(this.searchOptions, this.replaceText.getText());
            this.searchResult = null;
            this.refreshSearchOptions();
            this.dataTablesController.refreshCurrentTable();
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(SearchReplaceUI.class, (String)"SearchReplaceUI.replacements.count.message", (Object)replacementsCount));
            this.resultText.setText("");
        }
        catch (Exception ex) {
            this.showRegexReplaceError();
        }
    }

    private void regexReplaceCheckBoxItemStateChanged(ItemEvent evt) {
        this.refreshSearchOptions();
    }

    private void columnsToSearchComboBoxItemStateChanged(ItemEvent evt) {
        this.refreshSearchOptions();
    }

    private void searchTextKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.nextResult();
        }
    }

    class ColumnWrapper {
        Column column;

        public ColumnWrapper(Column column) {
            this.column = column;
        }

        public String toString() {
            return this.column.getTitle();
        }
    }

    public static enum Mode {
        NODES_TABLE,
        EDGES_TABLE;

    }
}

