/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterGraphML;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.AbstractExporterSettings;
import org.gephi.ui.exporter.plugin.UIExporterGraphMLPanel;
import org.openide.util.NbBundle;

public class UIExporterGraphML
implements ExporterUI {
    private final ExporterGraphMLSettings settings = new ExporterGraphMLSettings();
    private UIExporterGraphMLPanel panel;
    private ExporterGraphML exporterGraphML;

    public void setup(Exporter exporter) {
        this.exporterGraphML = (ExporterGraphML)exporter;
        this.settings.load(this.exporterGraphML);
        this.panel.setup(this.exporterGraphML);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterGraphML);
            this.settings.save(this.exporterGraphML);
        }
        this.panel = null;
        this.exporterGraphML = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterGraphMLPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterGraphML;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterGraphML.class, (String)"UIExporterGraphML.name");
    }

    private static class ExporterGraphMLSettings
    extends AbstractExporterSettings {
        private static final String NORMALIZE = "GraphML_normalize";
        private static final String EXPORT_COLORS = "GraphML_exportColors";
        private static final String EXPORT_POSITION = "GraphML_exportPosition";
        private static final String EXPORT_ATTRIBUTES = "GraphML_exportAttributes";
        private static final String EXPORT_SIZE = "GraphML_exportSize";
        private static final ExporterGraphML DEFAULT = new ExporterGraphML();

        private ExporterGraphMLSettings() {
        }

        private void save(ExporterGraphML exporterGraphML) {
            this.put(NORMALIZE, exporterGraphML.isNormalize());
            this.put(EXPORT_COLORS, exporterGraphML.isExportColors());
            this.put(EXPORT_POSITION, exporterGraphML.isExportPosition());
            this.put(EXPORT_SIZE, exporterGraphML.isExportSize());
            this.put(EXPORT_ATTRIBUTES, exporterGraphML.isExportAttributes());
        }

        private void load(ExporterGraphML exporterGraphML) {
            exporterGraphML.setNormalize(this.get(NORMALIZE, DEFAULT.isNormalize()));
            exporterGraphML.setExportColors(this.get(EXPORT_COLORS, DEFAULT.isExportColors()));
            exporterGraphML.setExportAttributes(this.get(EXPORT_ATTRIBUTES, DEFAULT.isExportAttributes()));
            exporterGraphML.setExportPosition(this.get(EXPORT_POSITION, DEFAULT.isExportPosition()));
            exporterGraphML.setExportSize(this.get(EXPORT_SIZE, DEFAULT.isExportSize()));
        }
    }
}

