/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.Validators;
import org.netbeans.validation.api.ui.ComponentDecorator;
import org.netbeans.validation.api.ui.GroupSpecificValidationUI;
import org.netbeans.validation.api.ui.MulticastValidationUI;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationStrategy;
import org.netbeans.validation.api.ui.ValidationUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ValidationGroupImpl {
    final MulticastValidationUI ui;
    private int suspendCount;
    private final List<ValidationListener> all = new ArrayList<ValidationListener>(10);
    private ComponentDecorator decorator = new ComponentDecorator();
    ValidationGroupImpl parent;

    ValidationGroupImpl(ValidationUI ... ui) {
        if (ui == null) {
            throw new NullPointerException("UI null");
        }
        this.ui = new MulticastValidationUI(new ValidationUI[0]);
        for (ValidationUI uis : ui) {
            this.ui.add(uis);
        }
    }

    ValidationGroupImpl() {
        this(new ValidationUI[0]);
    }

    ValidationUI getUI() {
        return this.ui;
    }

    boolean isSuspended() {
        return this.suspendCount > 0 || this.parent != null && this.parent.isSuspended();
    }

    void addUI(ValidationUI real) {
        if (!this.contains(real)) {
            this.ui.add(real);
        }
    }

    void removeUI(ValidationUI ui) {
        if (this.contains(ui)) {
            this.ui.remove(ui);
        }
    }

    boolean contains(ValidationUI ui) {
        return this.ui == ui || this.ui.contains(ui);
    }

    void setParent(ValidationGroupImpl group) {
        if (this.parent != null && group != null) {
            throw new IllegalStateException("Already has parent " + this.parent);
        }
        this.parent = group;
    }

    ComponentDecorator getComponentDecorator() {
        return this.decorator;
    }

    public void setComponentDecorator(ComponentDecorator decorator) {
        assert (EventQueue.isDispatchThread()) : "Not on event thread";
        if (decorator == null) {
            throw new NullPointerException("Null decorator");
        }
        this.decorator = decorator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void modifyComponents(Runnable run) {
        if (this.parent != null) {
            this.parent.modifyComponents(run);
        } else {
            ++this.suspendCount;
            try {
                run.run();
            }
            finally {
                --this.suspendCount;
                if (!this.isSuspended()) {
                    this.validateAll(null);
                }
            }
        }
    }

    static ValidationGroupImpl create(ValidationUI[] ui) {
        if (ui == null) {
            throw new NullPointerException();
        }
        return new ValidationGroupImpl(ui);
    }

    public final void add(JTextComponent comp, Validator<Document> validator) {
        this.add(comp, ValidationStrategy.DEFAULT, validator);
    }

    public final void add(JTextComponent comp, Validator<String> ... builtIns) {
        this.add(comp, ValidationStrategy.DEFAULT, builtIns);
    }

    public final void add(JComboBox box, Validator<ComboBoxModel> validator) {
        this.add(box, ValidationStrategy.DEFAULT, validator);
    }

    public final void add(JComboBox box, Validator<String> ... builtIns) {
        this.add(box, ValidationStrategy.DEFAULT, builtIns);
    }

    public final void add(JTextComponent comp, ValidationStrategy strategy, Validator<String> ... builtIns) {
        Validator<Document> v = Validators.forDocument(true, builtIns);
        this.add(comp, strategy, v);
    }

    public final void add(JComboBox box, ValidationStrategy strategy, Validator<String> ... builtIns) {
        Validator<ComboBoxModel> v = Validators.forComboBox(true, builtIns);
        this.add(box, strategy, v);
    }

    public final void add(AbstractButton[] buttons, Validator<ButtonModel[]> validator) {
        ButtonModel[] mdls = new ButtonModel[buttons.length];
        for (int i = 0; i < mdls.length; ++i) {
            mdls[i] = buttons[i].getModel();
        }
        this.add(mdls, validator);
    }

    public void add(ValidationListener listener) {
        if (this.parent != null) {
            this.parent.add(listener);
        } else {
            listener.setValidationGroup(this);
        }
        this.all.add(listener);
    }

    public void add(final ButtonModel[] buttons, final Validator<ButtonModel[]> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class V
        extends ValidationListener
        implements ItemListener {
            V() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                this.validate();
            }

            @Override
            public boolean validate(Problems problems) {
                if (!this.enabled(buttons)) {
                    return true;
                }
                return validator.validate(problems, null, buttons);
            }

            private boolean enabled(ButtonModel[] b) {
                ButtonModel m;
                boolean result = true;
                ButtonModel[] arr$ = b;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (result = (m = arr$[i$]).isEnabled()); ++i$) {
                }
                return result;
            }
        }
        V v = new V();
        this.add(v);
    }

    public void add(final JComboBox box, ValidationStrategy strategy, final Validator<ComboBoxModel> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        final Border originalBorder = box.getBorder();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class V
        extends ValidationListener
        implements ItemListener,
        FocusListener {
            V() {
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.validate();
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                this.validate();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public boolean validate(Problems problems) {
                if (!box.isEnabled()) {
                    return true;
                }
                boolean result = validator.validate(problems, V.nameForComponent(box), box.getModel());
                if (originalBorder != null) {
                    if (result) {
                        if (box.getBorder() != originalBorder) {
                            box.setBorder(originalBorder);
                        }
                    } else {
                        Problem p = problems.getLeadProblem();
                        box.setBorder(ValidationGroupImpl.this.decorator.createProblemBorder(box, originalBorder, p.severity()));
                    }
                }
                return result;
            }
        }
        V v = new V();
        this.add(v);
        switch (strategy) {
            case DEFAULT: 
            case ON_CHANGE_OR_ACTION: {
                box.addItemListener(v);
                break;
            }
            case ON_FOCUS_LOSS: {
                box.addFocusListener(v);
                break;
            }
            case INPUT_VERIFIER: {
                box.setInputVerifier(v);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void add(final JTextComponent field, ValidationStrategy strategy, final Validator<Document> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        final Border originalBorder = field.getBorder();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class V
        extends ValidationListener
        implements DocumentListener,
        FocusListener,
        Runnable {
            V() {
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.validate();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.removeUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(this);
                } else {
                    this.validate();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.removeUpdate(e);
            }

            @Override
            public void run() {
                this.validate();
            }

            @Override
            public boolean validate(Problems problems) {
                if (!field.isEnabled()) {
                    return true;
                }
                boolean result = validator.validate(problems, V.nameForComponent(field), field.getDocument());
                if (originalBorder != null) {
                    if (result) {
                        if (field.getBorder() != originalBorder) {
                            field.setBorder(originalBorder);
                        }
                    } else {
                        assert (field != null) : "Field null";
                        assert (ValidationGroupImpl.this.decorator != null) : "Decorator null";
                        Problem p = problems.getLeadProblem();
                        assert (p != null) : "A validator has returned false from validate(), but no validator has added anyproblems to the problem set.";
                        Border border = ValidationGroupImpl.this.decorator.createProblemBorder(field, originalBorder, p.severity());
                        field.setBorder(border);
                    }
                }
                return result;
            }
        }
        V v = new V();
        this.add(v);
        switch (strategy) {
            case DEFAULT: 
            case ON_CHANGE_OR_ACTION: {
                field.getDocument().addDocumentListener(v);
                break;
            }
            case INPUT_VERIFIER: {
                field.setInputVerifier(v);
                break;
            }
            case ON_FOCUS_LOSS: {
                field.addFocusListener(v);
            }
        }
    }

    public Problem validateAll(ValidationListener trigger) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        if (this.parent != null) {
            return this.parent.validateAll(trigger);
        }
        if (this.isSuspended()) {
            return null;
        }
        Problems p = new Problems();
        for (ValidationListener a : this.all) {
            if (a == trigger) continue;
            a.validate(p);
            if (!p.hasFatal()) continue;
            break;
        }
        if (!p.isEmpty()) {
            Problem problem = p.getLeadProblem();
            return problem;
        }
        return null;
    }

    public void addValidationGroup(ValidationGroupImpl group, boolean useUI) {
        assert (EventQueue.isDispatchThread()) : "Not in event thread";
        assert (this.noOverlap(this.all, group.all));
        if (group.parent != null) {
            throw new IllegalStateException("Cannot add to a group that has already been added to another group");
        }
        this.all.addAll(group.all);
        for (ValidationListener l : this.all) {
            l.setValidationGroup(this);
        }
        if (useUI) {
            this.addUI(new GroupSpecificValidationUI(group, group.ui));
        } else {
            group.ui.clearProblem();
        }
        group.setParent(this);
        this.validateAll(null);
    }

    public void removeValidationGroup(ValidationGroupImpl group) {
        assert (EventQueue.isDispatchThread()) : "Not in event thread";
        if (group == this) {
            throw new IllegalArgumentException("Removing from self");
        }
        this.all.removeAll(group.all);
        for (ValidationListener l : group.all) {
            l.setValidationGroup(group);
        }
        this.ui.removeUI(group);
        group.setParent(null);
        this.validateAll(null);
    }

    private boolean noOverlap(List<ValidationListener> all, List<ValidationListener> all0) {
        HashSet<ValidationListener> s = new HashSet<ValidationListener>();
        s.addAll(all);
        s.addAll(all0);
        return s.size() == all.size() + all0.size();
    }
}

