/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeMapper;
import com.lightdev.app.shtm.CopiedImageSources;
import com.lightdev.app.shtm.DocumentPane;
import com.lightdev.app.shtm.SHTMLWriter;
import com.lightdev.app.shtm.UnknownDocumentBaseException;
import com.lightdev.app.shtm.Util;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class SHTMLDocument
extends HTMLDocument {
    public static final String SUFFIX = "&nbsp;";
    private static Set paragraphElements;
    private CompoundEdit compoundEdit = null;
    private int compoundEditDepth;
    private boolean inSetParagraphAttributes = false;
    private final boolean keepSpanTag = Util.preferenceIsTrue("keepSpanTag");
    private CopiedImageSources copiedExternalImagesSources = CopiedImageSources.NONE;

    public SHTMLDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleSheet());
    }

    public SHTMLDocument(StyleSheet styles) {
        this((AbstractDocument.Content)new GapContent(4096), styles);
    }

    public SHTMLDocument(AbstractDocument.Content c, StyleSheet styles) {
        super(c, styles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributes(Element e, AttributeSet a) {
        if (e != null && a != null) {
            try {
                this.writeLock();
                int start = e.getStartOffset();
                AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, start, e.getEndOffset() - start, DocumentEvent.EventType.CHANGE);
                AttributeSet sCopy = a.copyAttributes();
                MutableAttributeSet attr = (MutableAttributeSet)e.getAttributes();
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(e, sCopy, false));
                attr.addAttributes(a);
                changes.end();
                this.fireChangedUpdate(changes);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElements(Element element, int index, int count) throws BadLocationException {
        this.writeLock();
        int start = element.getElement(index).getStartOffset();
        int end = element.getElement(index + count - 1).getEndOffset();
        try {
            Element[] removed = new Element[count];
            Element[] added = new Element[]{};
            for (int counter = 0; counter < count; ++counter) {
                removed[counter] = element.getElement(counter + index);
            }
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, start, end - start, DocumentEvent.EventType.REMOVE);
            ((AbstractDocument.BranchElement)element).replace(index, removed.length, added);
            defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(element, index, removed, added));
            UndoableEdit undoableEdit = this.getContent().remove(start, end - start);
            if (undoableEdit != null) {
                defaultDocumentEvent.addEdit(undoableEdit);
            }
            this.postRemoveUpdate(defaultDocumentEvent);
            defaultDocumentEvent.end();
            this.fireRemoveUpdate(defaultDocumentEvent);
            if (undoableEdit != null) {
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOuterHTML(Element paragraphElement, String htmlText) throws BadLocationException, IOException {
        try {
            this.startCompoundEdit();
            if (paragraphElement.getName().equalsIgnoreCase("p-implied")) {
                int i;
                Element parentElement = paragraphElement.getParentElement();
                SHTMLWriter writer = new SHTMLWriter(this);
                int indexOfElement = parentElement.getElementIndex(paragraphElement.getStartOffset());
                writer.writeStartTag(parentElement);
                for (i = 0; i < indexOfElement; ++i) {
                    writer.write(parentElement.getElement(i));
                }
                writer.write(htmlText);
                for (i = indexOfElement + 1; i < parentElement.getElementCount(); ++i) {
                    writer.write(parentElement.getElement(i));
                }
                writer.writeEndTag(parentElement);
                super.setOuterHTML(parentElement, writer.toString());
            } else {
                super.setOuterHTML(paragraphElement, htmlText);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    @Override
    public void insertAfterEnd(Element elem, String htmlText) throws BadLocationException, IOException {
        try {
            this.startCompoundEdit();
            super.insertAfterEnd(elem, htmlText);
        }
        finally {
            this.endCompoundEdit();
        }
    }

    @Override
    public void insertAfterStart(Element elem, String htmlText) throws BadLocationException, IOException {
        try {
            this.startCompoundEdit();
            super.insertAfterStart(elem, htmlText);
        }
        finally {
            this.endCompoundEdit();
        }
    }

    @Override
    public void insertBeforeEnd(Element elem, String htmlText) throws BadLocationException, IOException {
        try {
            this.startCompoundEdit();
            super.insertBeforeEnd(elem, htmlText);
        }
        finally {
            this.endCompoundEdit();
        }
    }

    @Override
    public void insertBeforeStart(Element elem, String htmlText) throws BadLocationException, IOException {
        try {
            this.startCompoundEdit();
            super.insertBeforeStart(elem, htmlText);
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Exception> void copyingExternalImages(CopiedImageSources copiedExternalImagesSources, ThrowingRunnable<T> runnable) throws T {
        CopiedImageSources copiedExternalImagesSourcesBackup = this.copiedExternalImagesSources;
        this.copiedExternalImagesSources = copiedExternalImagesSources;
        try {
            runnable.run();
        }
        finally {
            this.copiedExternalImagesSources = copiedExternalImagesSourcesBackup;
        }
    }

    @Override
    protected void insert(int offset, DefaultStyledDocument.ElementSpec[] data) throws BadLocationException {
        this.copyExternalImages(data);
        super.insert(offset, data);
    }

    private void copyExternalImages(DefaultStyledDocument.ElementSpec[] data) {
        if (this.copiedExternalImagesSources == CopiedImageSources.NONE) {
            return;
        }
        URL base = this.getBase();
        if (base == null || !base.getProtocol().equalsIgnoreCase("file")) {
            return;
        }
        try {
            Stream.of(data).forEach(this::copyExternalImagesForElementSpec);
        }
        catch (UnknownDocumentBaseException e) {
            Util.errMsg(null, e.getMessage(), null);
        }
    }

    private void copyExternalImagesForElementSpec(DefaultStyledDocument.ElementSpec data) {
        AttributeSet attributes = data.getAttributes();
        if (!(attributes instanceof MutableAttributeSet) || !HTML.Tag.IMG.equals(attributes.getAttribute(StyleConstants.NameAttribute))) {
            return;
        }
        String source = (String)attributes.getAttribute(HTML.Attribute.SRC);
        if (!this.copiedExternalImagesSources.includes(source)) {
            return;
        }
        int extensionIndex = source.lastIndexOf(46);
        if (extensionIndex == -1) {
            return;
        }
        try {
            URL sourceUrl = new URL(this.getBase(), source);
            File imageDirectory = this.getImageDirectory().getCanonicalFile();
            if (sourceUrl.getProtocol().equalsIgnoreCase("file")) {
                File sourceFile = new File(sourceUrl.getPath()).getCanonicalFile();
                String basePath = imageDirectory.getPath() + File.separatorChar;
                if (sourceFile.getPath().startsWith(basePath)) {
                    String updatedSource = sourceFile.getPath().substring(basePath.length()).replace(File.separatorChar, '/');
                    if (!updatedSource.equals(source)) {
                        ((MutableAttributeSet)attributes).addAttribute(HTML.Attribute.SRC, updatedSource);
                    }
                    return;
                }
            }
            String imageExtension = source.substring(extensionIndex);
            imageDirectory.mkdirs();
            File imageCopy = File.createTempFile("image-", imageExtension, imageDirectory);
            try (ReadableByteChannel rbc = Channels.newChannel(sourceUrl.openStream());
                 FileOutputStream fos = new FileOutputStream(imageCopy);){
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                ((MutableAttributeSet)attributes).addAttribute(HTML.Attribute.SRC, imageDirectory.getName() + '/' + imageCopy.getName());
            }
        }
        catch (UnknownDocumentBaseException e) {
            ((MutableAttributeSet)attributes).addAttribute(HTML.Attribute.SRC, "");
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceHTML(Element firstElement, int number, String htmlText) throws BadLocationException, IOException {
        if (number > 1) {
            if (firstElement != null && firstElement.getParentElement() != null && htmlText != null) {
                int start = firstElement.getStartOffset();
                Element parent = firstElement.getParentElement();
                int removeIndex = parent.getElementIndex(start);
                try {
                    this.startCompoundEdit();
                    this.removeElements(parent, removeIndex, number - 1);
                    this.setOuterHTML(parent.getElement(removeIndex), htmlText);
                }
                finally {
                    this.endCompoundEdit();
                }
            }
        } else if (number == 1) {
            this.setOuterHTML(firstElement, htmlText);
        }
    }

    public void startCompoundEdit() {
        ++this.compoundEditDepth;
    }

    public void endCompoundEdit() {
        if (this.compoundEditDepth != 0) {
            --this.compoundEditDepth;
            if (this.compoundEditDepth == 0 && this.compoundEdit != null) {
                this.compoundEdit.end();
                super.fireUndoableEditUpdate(new UndoableEditEvent(this, this.compoundEdit));
                this.compoundEdit = null;
            }
        }
    }

    @Override
    protected void fireUndoableEditUpdate(UndoableEditEvent e) {
        if (this.compoundEditDepth == 0) {
            super.fireUndoableEditUpdate(e);
        } else {
            if (this.compoundEdit == null) {
                this.compoundEdit = new CompoundEdit();
            }
            this.compoundEdit.addEdit(e.getEdit());
        }
    }

    public void setDocumentTitle(String title) {
        try {
            String titleHTML = "<title></title>";
            Element defaultRoot = this.getDefaultRootElement();
            Element head = Util.findElementDown(HTML.Tag.HEAD.toString(), defaultRoot);
            if (head != null) {
                Element tElem;
                Element pImpl = Util.findElementDown(HTML.Tag.IMPLIED.toString(), head);
                if (pImpl != null && (tElem = Util.findElementDown(HTML.Tag.TITLE.toString(), pImpl)) == null) {
                    this.insertBeforeEnd(pImpl, "<title></title>");
                }
            } else {
                Element body = Util.findElementDown(HTML.Tag.BODY.toString(), defaultRoot);
                this.insertBeforeStart(body, "<head><title></title></head>");
            }
            this.putProperty("title", title);
        }
        catch (Exception e) {
            Util.errMsg(null, "An exception occurred while trying to insert the title", e);
        }
    }

    public String getDocumentTitle() {
        Object title = this.getProperty("title");
        if (title != null) {
            return title.toString();
        }
        return null;
    }

    public void insertStyleRef() {
        try {
            String styleRef = "  <link rel=stylesheet type=\"text/css\" href=\"" + DocumentPane.DEFAULT_STYLE_SHEET_NAME + "\">";
            Element defaultRoot = this.getDefaultRootElement();
            Element head = Util.findElementDown(HTML.Tag.HEAD.toString(), defaultRoot);
            if (head != null) {
                Element pImpl = Util.findElementDown(HTML.Tag.IMPLIED.toString(), head);
                if (pImpl != null) {
                    Element link = Util.findElementDown(HTML.Tag.LINK.toString(), pImpl);
                    if (link != null) {
                        this.setOuterHTML(link, styleRef);
                    } else {
                        this.insertBeforeEnd(pImpl, styleRef);
                    }
                }
            } else {
                Element body = Util.findElementDown(HTML.Tag.BODY.toString(), defaultRoot);
                this.insertBeforeStart(body, "<head>" + styleRef + "</head>");
            }
        }
        catch (Exception e) {
            Util.errMsg(null, "An exception occurred while trying to insert the style sheet reference link", e);
        }
    }

    public boolean hasStyleRef() {
        return this.getStyleRef() != null;
    }

    public String getStyleRef() {
        Object href;
        String linkName = null;
        Element link = Util.findElementDown(HTML.Tag.LINK.toString(), this.getDefaultRootElement());
        if (link != null && (href = link.getAttributes().getAttribute(HTML.Attribute.HREF)) != null) {
            linkName = href.toString();
        }
        return linkName;
    }

    @Override
    public HTMLEditorKit.ParserCallback getReader(int pos) {
        Object desc = this.getProperty("stream");
        if (desc instanceof URL) {
            this.setBase((URL)desc);
        }
        SHTMLReader reader = new SHTMLReader(pos, this.getLength() == 0);
        return reader;
    }

    @Override
    public Element getParagraphElement(int pos) {
        return this.getParagraphElement(pos, this.inSetParagraphAttributes);
    }

    public Element getParagraphElement(int pos, boolean noPImplied) {
        Element element;
        if (noPImplied) {
            for (element = super.getParagraphElement(pos); element != null && element.getName().equalsIgnoreCase("p-implied"); element = element.getParentElement()) {
            }
        }
        return element;
    }

    public int getLastDocumentPosition() {
        int length = this.getLength();
        boolean suffixLength = true;
        return length > 1 ? length - 1 : length;
    }

    @Override
    public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
        this.startCompoundEdit();
        super.setParagraphAttributes(offset, length, s, replace);
        this.inSetParagraphAttributes = true;
        super.setParagraphAttributes(offset, length, s, replace);
        this.inSetParagraphAttributes = false;
        this.endCompoundEdit();
    }

    public void removeParagraphAttributes(int offset, int length) {
        this.startCompoundEdit();
        int i = offset;
        while (i < offset + length) {
            int endOffset;
            Element paragraphElement = super.getParagraphElement(i);
            this.removeParagraphAtributes(paragraphElement);
            i = endOffset = paragraphElement.getEndOffset();
        }
        this.endCompoundEdit();
    }

    private void removeParagraphAtributes(Element paragraphElement) {
        if (paragraphElement != null && paragraphElement.getName().equalsIgnoreCase("p-implied")) {
            this.removeParagraphAtributes(paragraphElement.getParentElement());
            return;
        }
        StringWriter writer = new StringWriter();
        SHTMLWriter htmlStartWriter = new SHTMLWriter((Writer)writer, this);
        try {
            htmlStartWriter.writeStartTag(paragraphElement.getName(), null);
            htmlStartWriter.writeChildElements(paragraphElement);
            htmlStartWriter.writeEndTag(paragraphElement.getName());
            this.setOuterHTML(paragraphElement, writer.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private SimpleAttributeSet getEndingAttributeSet() {
        SimpleAttributeSet set = new SimpleAttributeSet();
        if (Util.preferenceIsTrue("gray_row_below_end")) {
            StyleConstants.setBackground(set, Color.GRAY);
        }
        return set;
    }

    public File getImageDirectory() {
        return SHTMLDocument.getImageDirectory(this.getBase());
    }

    public static File getImageDirectory(URL base) {
        try {
            return new File(new URL(base, SHTMLDocument.getImageDirectoryName(base)).getPath());
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getImageDirectoryName() {
        return SHTMLDocument.getImageDirectoryName(this.getBase());
    }

    public static String getImageDirectoryName(URL documentUrl) {
        if (documentUrl == null) {
            throw new UnknownDocumentBaseException(Util.getResourceString("unknownBaseUrlImageInsertionError"));
        }
        String path = documentUrl.getPath();
        int filenameStart = path.lastIndexOf(47) + 1;
        int filenameEnd = path.lastIndexOf(46);
        if (filenameEnd < filenameStart) {
            filenameEnd = path.length();
        }
        if (filenameStart < filenameEnd) {
            return path.substring(filenameStart, filenameEnd) + "_files";
        }
        throw new UnknownDocumentBaseException(Util.getResourceString("unknownBaseUrlImageInsertionError"));
    }

    public class SHTMLReader
    extends HTMLDocument.HTMLReader {
        SHTMLCharacterAction characterAction;
        AttributeSet styleAttributes;
        boolean inSpan;
        final boolean newDocument;
        private boolean inBody;
        private int inPreLevel;
        private boolean isParagraphTag;

        public SHTMLReader(int offset, boolean newDocument) {
            super(SHTMLDocument.this, offset, 0, 0, null);
            this.characterAction = new SHTMLCharacterAction();
            this.inSpan = false;
            this.inPreLevel = 0;
            this.newDocument = newDocument;
            this.inBody = false;
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attributeSet, int pos) {
            if (tag == HTML.Tag.BODY) {
                this.inBody = true;
            } else if (this.inBody) {
                this.isParagraphTag = this.isParagraphTag(tag);
                if (this.isParagraphTag) {
                    if (HTML.Tag.PRE.equals(tag)) {
                        ++this.inPreLevel;
                        if (this.inPreLevel > 1) {
                            return;
                        }
                    } else if (this.inPreLevel >= 1) {
                        return;
                    }
                }
            }
            if (tag == HTML.Tag.SPAN && !SHTMLDocument.this.keepSpanTag) {
                this.handleStartSpan(attributeSet);
            } else {
                super.handleStartTag(tag, attributeSet, pos);
                if (tag == HTML.Tag.FONT) {
                    this.charAttr.removeAttribute(tag);
                }
            }
        }

        private boolean isParagraphTag(HTML.Tag t) {
            if (paragraphElements == null) {
                paragraphElements = new HashSet();
                Object[] elementList = new Object[]{HTML.Tag.BLOCKQUOTE, HTML.Tag.DIR, HTML.Tag.DIV, HTML.Tag.DL, HTML.Tag.DT, HTML.Tag.FRAMESET, HTML.Tag.H1, HTML.Tag.H2, HTML.Tag.H3, HTML.Tag.H4, HTML.Tag.H5, HTML.Tag.H6, HTML.Tag.HR, HTML.Tag.LI, HTML.Tag.MENU, HTML.Tag.OL, HTML.Tag.P, HTML.Tag.PRE, HTML.Tag.TABLE, HTML.Tag.TD, HTML.Tag.TH, HTML.Tag.TR, HTML.Tag.UL};
                for (int i = 0; i < elementList.length; ++i) {
                    paragraphElements.add(elementList[i]);
                }
            }
            return paragraphElements.contains(t);
        }

        private void handleStartSpan(MutableAttributeSet attributeSet) {
            if (attributeSet.isDefined(HTML.Attribute.STYLE)) {
                String styleAttributeValue = (String)attributeSet.getAttribute(HTML.Attribute.STYLE);
                attributeSet.removeAttribute(HTML.Attribute.STYLE);
                this.styleAttributes = SHTMLDocument.this.getStyleSheet().getDeclaration(styleAttributeValue);
                attributeSet.addAttributes(this.styleAttributes);
            } else {
                this.styleAttributes = null;
            }
            SHTMLCharacterAction action = this.characterAction;
            if (action != null) {
                this.inSpan = true;
                ((HTMLDocument.HTMLReader.TagAction)action).start(HTML.Tag.SPAN, attributeSet);
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == HTML.Tag.SPAN && !SHTMLDocument.this.keepSpanTag) {
                if (this.inSpan) {
                    this.handleEndTag(t, pos);
                } else {
                    this.handleStartTag(t, a, pos);
                }
            } else {
                super.handleSimpleTag(t, a, pos);
            }
        }

        @Override
        public void handleEndTag(HTML.Tag tag, int pos) {
            if (tag == HTML.Tag.BODY) {
                this.inBody = false;
                if (this.newDocument) {
                    super.handleStartTag(HTML.Tag.P, SHTMLDocument.this.getEndingAttributeSet(), pos);
                    super.handleText(" ".toCharArray(), pos);
                    super.handleEndTag(HTML.Tag.P, pos);
                }
                super.handleEndTag(tag, pos);
            } else if (tag == HTML.Tag.SPAN && !SHTMLDocument.this.keepSpanTag) {
                this.handleEndSpan();
            } else {
                if (HTML.Tag.PRE.equals(tag) && this.inPreLevel > 0) {
                    --this.inPreLevel;
                }
                if (this.inPreLevel == 0 || !this.isParagraphTag(tag)) {
                    super.handleEndTag(tag, pos);
                }
            }
        }

        @Override
        public void handleComment(char[] data, int pos) {
            if (this.newDocument) {
                super.handleComment(data, pos);
            }
        }

        private void handleEndSpan() {
            SHTMLCharacterAction action = this.characterAction;
            if (action != null) {
                this.inSpan = false;
                ((HTMLDocument.HTMLReader.TagAction)action).end(HTML.Tag.SPAN);
            }
        }

        class SHTMLCharacterAction
        extends HTMLDocument.HTMLReader.CharacterAction {
            SHTMLCharacterAction() {
                super(SHTMLReader.this);
            }

            @Override
            public void start(HTML.Tag tag, MutableAttributeSet attr) {
                SHTMLReader.this.pushCharacterStyle();
                if (attr.isDefined(HTMLEditorKit.ParserCallback.IMPLIED)) {
                    attr.removeAttribute(HTMLEditorKit.ParserCallback.IMPLIED);
                }
                SHTMLReader.this.charAttr.addAttribute(tag, attr.copyAttributes());
                if (SHTMLReader.this.styleAttributes != null) {
                    SHTMLReader.this.charAttr.addAttributes(SHTMLReader.this.styleAttributes);
                }
                if (SHTMLReader.this.charAttr.isDefined(HTML.Tag.SPAN)) {
                    SHTMLReader.this.charAttr.removeAttribute(HTML.Tag.SPAN);
                }
                SHTMLReader.this.charAttr = (MutableAttributeSet)new AttributeMapper(SHTMLReader.this.charAttr).getMappedAttributes(2);
            }

            @Override
            public void end(HTML.Tag t) {
                SHTMLReader.this.popCharacterStyle();
            }
        }
    }

    @FunctionalInterface
    public static interface ThrowingRunnable<T extends Exception> {
        public void run() throws T;
    }
}

