/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.SHTMLWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;

class HTMLText {
    private String htmlText;
    private String plainText;
    private final Vector clipText = new Vector(0);
    private final Vector clipAttr = new Vector(0);
    private boolean stringRepresentation = false;

    public HTMLText() {
    }

    public HTMLText(String htmlText, String plainText) {
        this.htmlText = htmlText;
        this.plainText = plainText;
        this.stringRepresentation = true;
    }

    public void copyHTML(SHTMLEditorPane src, int start, int length) throws BadLocationException, IOException {
        SHTMLDocument doc = src.getDocument();
        if (((DefaultStyledDocument)doc).getParagraphElement(start).equals(((DefaultStyledDocument)doc).getParagraphElement(start + length))) {
            this.stringRepresentation = false;
            this.clearStyledText();
            this.copyStyledText(src);
        } else {
            this.stringRepresentation = true;
            StringWriter sw = new StringWriter();
            SHTMLWriter w = new SHTMLWriter((Writer)sw, doc, start, length);
            Element first = ((DefaultStyledDocument)doc).getParagraphElement(start);
            Element last = doc.getCharacterElement(start + length);
            w.write(first, last);
            this.htmlText = sw.getBuffer().toString();
            this.plainText = doc.getText(start, length);
        }
    }

    public void pasteHTML(Document document, int position) throws BadLocationException, IOException {
        if (!this.stringRepresentation) {
            int nrTextChunks = this.getClipTextSize();
            for (int i = 0; i < nrTextChunks; ++i) {
                String text = this.getCharactersAt(i);
                document.insertString(position, text, this.getCharacterAttributes(i));
                position += text.length();
            }
        }
    }

    public String splitPaste(SHTMLDocument doc, Element characterElement, Element paragraphElement, int targetPosition, String pastedHtml, boolean pastedHTMLHasParagraphTags) {
        StringWriter sw = new StringWriter();
        SHTMLWriter w = new SHTMLWriter((Writer)sw, doc);
        String paragraphElementAdjustedName = paragraphElement.getName();
        boolean impliedParagraph = paragraphElementAdjustedName.equalsIgnoreCase("p-implied");
        if (impliedParagraph) {
            paragraphElementAdjustedName = "p";
        }
        try {
            int count = paragraphElement.getElementCount();
            if (!impliedParagraph || pastedHTMLHasParagraphTags) {
                w.writeStartTag(paragraphElementAdjustedName, paragraphElement.getAttributes());
            }
            for (int elementIdx = 0; elementIdx < count; ++elementIdx) {
                Element element = paragraphElement.getElement(elementIdx);
                if (element.equals(characterElement)) {
                    SHTMLWriter htmlStartWriter = new SHTMLWriter((Writer)sw, doc, element.getStartOffset(), targetPosition - element.getStartOffset());
                    htmlStartWriter.write(element);
                    if (pastedHTMLHasParagraphTags) {
                        w.writeEndTag(paragraphElementAdjustedName);
                    }
                    sw.write(pastedHtml);
                    if (pastedHTMLHasParagraphTags) {
                        w.writeStartTag(paragraphElementAdjustedName, paragraphElement.getAttributes());
                    }
                    SHTMLWriter htmlEndWriter = new SHTMLWriter((Writer)sw, doc, targetPosition, element.getEndOffset() - targetPosition);
                    htmlEndWriter.write(element);
                    continue;
                }
                w.write(element);
            }
            if (!impliedParagraph || pastedHTMLHasParagraphTags) {
                w.writeEndTag(paragraphElementAdjustedName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sw.getBuffer().toString();
    }

    private void copyStyledText(SHTMLEditorPane src) throws BadLocationException {
        SHTMLDocument doc = src.getDocument();
        int selStart = src.getSelectionStart();
        int selEnd = src.getSelectionEnd();
        ElementIterator eli = new ElementIterator(doc);
        Element elem = eli.first();
        while (elem != null) {
            int eStart = elem.getStartOffset();
            int eEnd = elem.getEndOffset();
            if (elem.getName().equalsIgnoreCase("content") && eEnd >= selStart && eStart <= selEnd) {
                this.clipAttr.addElement(elem.getAttributes());
                if (eStart < selStart) {
                    if (eEnd > selEnd) {
                        this.clipText.addElement(src.getText(selStart, selEnd - selStart));
                    } else {
                        this.clipText.addElement(src.getText(selStart, eEnd - selStart));
                    }
                } else if (eEnd > selEnd) {
                    this.clipText.addElement(src.getText(eStart, selEnd - eStart));
                } else {
                    this.clipText.addElement(src.getText(eStart, eEnd - eStart));
                }
            }
            elem = eli.next();
        }
    }

    private int getClipTextSize() {
        return this.clipText.size();
    }

    private AttributeSet getCharacterAttributes(int chunkNo) {
        return (AttributeSet)this.clipAttr.elementAt(chunkNo);
    }

    private String getCharactersAt(int chunkNo) {
        return (String)this.clipText.elementAt(chunkNo);
    }

    private void clearStyledText() {
        this.clipText.clear();
        this.clipAttr.clear();
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.stringRepresentation) {
            text.append(this.plainText);
        } else {
            for (int i = 0; i < this.clipText.size(); ++i) {
                text.append((String)this.clipText.elementAt(i));
            }
        }
        return text.toString();
    }

    public static boolean containsParagraphTags(String htmlText) {
        return htmlText.matches("(?ims).*<(blockquote|dir|div|dl|dt|frameset|h1|h2|h3|h4|h5|h6|hr|li|menu|ol|p|pre|table|td|th|tr|ul).*?>.*");
    }

    public boolean isOneCellInOneRow() {
        if (this.htmlText.matches("(?ims).*</td>.*<td.*")) {
            return false;
        }
        if (this.htmlText.matches("(?ims).*</tr>.*<tr.*")) {
            return false;
        }
        return this.htmlText.matches("(?ims).*<table.*");
    }

    public boolean usesStringRepresenation() {
        return this.stringRepresentation;
    }

    public String getHTMLText() {
        return this.htmlText;
    }
}

