/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.Util;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;

class EffectPanel
extends JPanel
implements AttributeComponent {
    JRadioButton uLine;
    JRadioButton strike;
    JRadioButton noLine = new JRadioButton(Util.getResourceString("noLineLabel"));
    private Object originalValue;
    private int setValCount = 0;
    String selection = "none";

    public EffectPanel() {
        super(new GridLayout(3, 1, 3, 3));
        this.uLine = new JRadioButton(Util.getResourceString("uLineLabel"));
        this.strike = new JRadioButton(Util.getResourceString("strikeLabel"));
        ButtonGroup effectGroup = new ButtonGroup();
        effectGroup.add(this.noLine);
        effectGroup.add(this.uLine);
        effectGroup.add(this.strike);
        this.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("effectLabel")));
        Font font = UIManager.getFont("TextField.font");
        this.uLine.setFont(font);
        this.strike.setFont(font);
        this.noLine.setFont(font);
        this.add(this.noLine);
        this.add(this.uLine);
        this.add(this.strike);
    }

    @Override
    public AttributeSet getValue(boolean includeUnchanged) {
        if (includeUnchanged) {
            return this.getAttributes();
        }
        return this.getValue();
    }

    private AttributeSet getAttributes() {
        SimpleAttributeSet set = new SimpleAttributeSet();
        this.selection = "none";
        if (this.uLine.isSelected()) {
            this.selection = "underline";
            StyleConstants.setUnderline(set, true);
        } else if (this.strike.isSelected()) {
            this.selection = "line-through";
            StyleConstants.setStrikeThrough(set, true);
        }
        Util.styleSheet().addCSSAttribute(set, CSS.Attribute.TEXT_DECORATION, this.selection);
        return set;
    }

    @Override
    public AttributeSet getValue() {
        AttributeSet set = this.getAttributes();
        if (this.originalValue == null && !this.selection.equalsIgnoreCase("none") || this.originalValue != null && !this.originalValue.toString().equalsIgnoreCase(this.selection)) {
            return set;
        }
        return new SimpleAttributeSet();
    }

    @Override
    public boolean setValue(AttributeSet a) {
        boolean success = false;
        if (a.isDefined(CSS.Attribute.TEXT_DECORATION)) {
            String value = a.getAttribute(CSS.Attribute.TEXT_DECORATION).toString();
            if (value.equalsIgnoreCase("underline")) {
                this.uLine.setSelected(true);
                if (++this.setValCount < 2) {
                    this.originalValue = "underline";
                }
                success = true;
            } else if (value.equalsIgnoreCase("line-through")) {
                this.strike.setSelected(true);
                if (++this.setValCount < 2) {
                    this.originalValue = "line-through";
                }
                success = true;
            } else {
                this.noLine.setSelected(true);
            }
        } else {
            this.noLine.setSelected(true);
        }
        return success;
    }
}

