/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.launcher;

import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.freeplane.api.Controller;
import org.freeplane.api.HeadlessMapCreator;
import org.freeplane.launcher.Utils;
import org.knopflerfish.framework.Main;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;

public class Launcher {
    private static final String FREEPLANE_JAVA_OPTION_FILE = "FREEPLANE_JAVA_OPTION_FILE";
    private static final String DEFAULT_FREEPLANE_OPTION_FILE_NAME = "system.properties";
    private static final String DISABLE_SECURITY_MANAGER_PROPERTY = "org.freeplane.main.application.FreeplaneSecurityManager.disable";
    private static final String JAVA_HEADLESS_PROPERTY = "java.awt.headless";
    private static final String BASEDIRECTORY_PROPERTY = "org.freeplane.basedirectory";
    private static final String JAVA_VERSION = System.getProperty("java.version");
    private final File freeplaneInstallationDirectory;
    private int argCount;
    private boolean disableSecurityManager;
    private boolean freeplaneLaunched;
    private static AtomicBoolean launcherCreated = new AtomicBoolean(false);
    private Framework framework;

    public static void main(String[] args) {
        Launcher.checkForCompatibleJavaVersion();
        Launcher.workAroundForDataFlavorComparator_JDK8130242();
        Launcher.disableUiScalingIfNotMacOs();
        new Launcher().launchWithoutUICheck(args);
    }

    private static void disableUiScalingIfNotMacOs() {
        if (!System.getProperty("os.name").startsWith("Mac")) {
            System.setProperty("sun.java2d.uiScale", "1");
        }
    }

    private static void checkForCompatibleJavaVersion() {
        Launcher.exitOnNonCompatibleJavaVersion("10");
    }

    private static void exitOnNonCompatibleJavaVersion(String version) {
        if (JAVA_VERSION.startsWith(version) && JAVA_VERSION.length() > version.length() && 0 <= "._".indexOf(JAVA_VERSION.charAt(version.length()))) {
            JOptionPane optionPane = new JOptionPane("Freeplane is not compatible with java " + version + ", exiting", 0);
            JDialog dialog = optionPane.createDialog("Incompatible JRE version");
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
            System.exit(0);
        }
    }

    public static Launcher createForInstallation(File freeplaneInstallationDirectory) {
        System.setProperty(BASEDIRECTORY_PROPERTY, freeplaneInstallationDirectory.getPath());
        return new Launcher(freeplaneInstallationDirectory);
    }

    public static Launcher create() {
        return new Launcher();
    }

    private Launcher() {
        this(Launcher.getFreeplaneInstallationDirectory());
    }

    public HeadlessMapCreator launchHeadless() {
        System.setProperty(JAVA_HEADLESS_PROPERTY, "true");
        return this.launchWithoutUICheck(new String[0]);
    }

    public Controller launchWithUI(String[] args) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new RuntimeException("UI can not run in a headless graphics environment");
        }
        Controller controller = this.launchWithoutUICheck(args);
        this.waitUntilUIStarts();
        return controller;
    }

    private void waitUntilUIStarts() {
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                for (int i = 0; i < 10; ++i) {
                    Thread.sleep(10L);
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        if (this.framework != null) {
            try {
                this.framework.stop();
            }
            catch (BundleException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Launcher disableSecurityManager() {
        this.disableSecurityManager = true;
        return this;
    }

    public Launcher userDirectory(File userDirectory) {
        return this.userDirectory(userDirectory.getAbsolutePath());
    }

    public Launcher userDirectory(String userDirectory) {
        System.setProperty("org.freeplane.userfpdir", userDirectory);
        System.setProperty("org.freeplane.old_userfpdir", userDirectory);
        return this;
    }

    private Launcher(File freeplaneInstallationDirectory) {
        Launcher.ensureSingleInstance();
        this.freeplaneInstallationDirectory = freeplaneInstallationDirectory;
        this.loadJavaSystemProperties();
        this.argCount = 0;
        this.disableSecurityManager = Boolean.getBoolean(DISABLE_SECURITY_MANAGER_PROPERTY);
    }

    private void loadJavaSystemProperties() {
        File propertyFile;
        String optionFileFromEnvironment = System.getenv(FREEPLANE_JAVA_OPTION_FILE);
        File file = propertyFile = optionFileFromEnvironment != null ? new File(optionFileFromEnvironment) : new File(this.freeplaneInstallationDirectory, DEFAULT_FREEPLANE_OPTION_FILE_NAME);
        if (propertyFile.canRead()) {
            System.out.println("Load system properties from installation specific file " + propertyFile.getAbsolutePath());
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(propertyFile));){
                System.getProperties().load(input);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void ensureSingleInstance() {
        if (!launcherCreated.compareAndSet(false, true)) {
            throw new IllegalStateException("Launcher instance already created");
        }
    }

    private static File getFreeplaneInstallationDirectory() {
        File frameworkDir;
        if (Utils.isDefineNotSet(BASEDIRECTORY_PROPERTY)) {
            frameworkDir = Utils.getPathToJar(Launcher.class);
        } else {
            try {
                frameworkDir = new File(System.getProperty(BASEDIRECTORY_PROPERTY)).getCanonicalFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return frameworkDir;
    }

    private static void workAroundForDataFlavorComparator_JDK8130242() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.7.") || javaVersion.startsWith("1.8.")) {
            System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        }
    }

    private Controller launchWithoutUICheck(String[] args) {
        if (this.freeplaneLaunched) {
            throw new IllegalStateException("Freeplane already launched");
        }
        this.freeplaneLaunched = true;
        this.setDefines();
        if (!this.disableSecurityManager) {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkConnect(String pHost, int pPort, Object pContext) {
                    if (pContext != null) {
                        super.checkConnect(pHost, pPort, pContext);
                    } else {
                        super.checkConnect(pHost, pPort);
                    }
                }
            });
        }
        this.setArgProperties(args);
        Controller controller = this.startFramework();
        return controller;
    }

    private void setDefines() {
        Utils.setDefine("org.knopflerfish.framework.readonly", "true");
        Utils.setDefine("org.knopflerfish.gosg.jars", "reference:file:" + this.getAbsolutePath("core") + '/');
        Utils.setDefine("org.freeplane.user.dir", System.getProperty("user.dir"));
        Utils.setDefine(BASEDIRECTORY_PROPERTY, this.getAbsolutePath());
        System.setProperty("user.dir", this.getAbsolutePath());
        Utils.setDefineIfNeeded("org.freeplane.globalresourcedir", this.getAbsolutePath("resources"));
        Utils.setDefineIfNeeded("java.security.policy", this.getAbsolutePath("freeplane.policy"));
        Utils.setDefine("org.osgi.framework.storage", this.getAbsolutePath("fwdir"));
    }

    private Controller startFramework() {
        String[] args = new String[]{"-xargs", this.getAbsolutePath("props.xargs"), "-xargs", this.getAbsolutePath("init.xargs"), "-bg"};
        Main main = new Main();
        System.out.println(main.bootText);
        this.framework = main.start(args);
        BundleContext bundleContext = this.framework.getBundleContext();
        ServiceReference<Controller> controller = bundleContext.getServiceReference(Controller.class);
        if (controller == null) {
            return null;
        }
        Controller service = bundleContext.getService(controller);
        return service;
    }

    private String getAbsolutePath() {
        return this.freeplaneInstallationDirectory.getAbsolutePath();
    }

    private String getAbsolutePath(String relativePath) {
        return new File(this.freeplaneInstallationDirectory, relativePath).getAbsolutePath();
    }

    private void setArgProperties(String[] args) {
        for (String arg : args) {
            this.setArgumentProperty(arg);
        }
    }

    private void setArgumentProperty(String arg) {
        String propertyName = "org.freeplane.param" + ++this.argCount;
        System.setProperty(propertyName, arg);
    }
}

