/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.osgi;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.main.application.ApplicationResourceController;
import org.freeplane.main.application.CommandLineOptions;
import org.freeplane.main.application.CommandLineParser;
import org.freeplane.main.application.FreeplaneGUIStarter;
import org.freeplane.main.application.FreeplaneStarter;
import org.freeplane.main.application.SingleInstanceManager;
import org.freeplane.main.application.protocols.freeplaneresource.Handler;
import org.freeplane.main.headlessmode.FreeplaneHeadlessStarter;
import org.freeplane.main.mindmapmode.stylemode.ExtensionInstaller;
import org.freeplane.main.mindmapmode.stylemode.SModeControllerFactory;
import org.freeplane.main.osgi.ConnectionHandler;
import org.freeplane.main.osgi.DataHandler;
import org.freeplane.main.osgi.DelegatingUrlHandlerService;
import org.freeplane.main.osgi.IControllerExtensionProvider;
import org.freeplane.main.osgi.IModeControllerExtensionProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;

class ActivatorImpl
implements BundleActivator {
    private static final String JAVA_HEADLESS_PROPERTY = "java.awt.headless";
    private FreeplaneStarter starter;

    ActivatorImpl() {
    }

    private String[] getCallParameters() {
        String param;
        LinkedList<String> parameters = new LinkedList<String>();
        int i = 1;
        while ((param = System.getProperty("org.freeplane.param" + i, null)) != null) {
            if (!param.equals("")) {
                parameters.add(param);
            }
            ++i;
        }
        String[] array = parameters.toArray(new String[parameters.size()]);
        return array;
    }

    public void start(BundleContext context) throws Exception {
        try {
            String userDirectory = System.getProperty("org.freeplane.user.dir");
            if (userDirectory != null) {
                System.setProperty("user.dir", userDirectory);
            }
            this.startFramework(context);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        catch (Error e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void loadPlugins(BundleContext context) {
        String installationBaseDir = ApplicationResourceController.INSTALLATION_BASE_DIRECTORY;
        File baseDir = new File(installationBaseDir).getAbsoluteFile();
        LinkedList<Bundle> loadedPlugins = new LinkedList<Bundle>();
        this.loadPlugins(context, new File(baseDir, "plugins"), loadedPlugins);
        String freeplaneUserDirectory = Compat.getApplicationUserDirectory();
        this.loadPlugins(context, new File(freeplaneUserDirectory), loadedPlugins);
        for (Bundle plugin : loadedPlugins) {
            try {
                plugin.start();
                System.out.println("Started: " + plugin.getLocation() + " (id#" + plugin.getBundleId() + ")");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadPlugins(BundleContext context, File file, List<Bundle> loadedPlugins) {
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        File manifest = new File(file, "META-INF/MANIFEST.MF");
        if (manifest.exists()) {
            try (FileInputStream manifestContent = new FileInputStream(manifest);){
                Manifest bundleManifest = new Manifest(manifestContent);
                String name = bundleManifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (name == null) {
                    return;
                }
                Bundle[] bundles = context.getBundles();
                for (int i = 0; i < bundles.length; ++i) {
                    Bundle installedBundle = bundles[i];
                    if (!installedBundle.getSymbolicName().equals(name)) continue;
                    System.out.println("Bundle " + name + " already installed");
                    return;
                }
                String location = "reference:file:" + file.getAbsolutePath();
                Bundle bundle = context.installBundle(location);
                System.out.println("Installed: " + location + " (id#" + bundle.getBundleId() + ")");
                loadedPlugins.add(bundle);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        File[] childFiles = file.listFiles();
        for (int i = 0; i < childFiles.length; ++i) {
            File child = childFiles[i];
            this.loadPlugins(context, child, loadedPlugins);
        }
    }

    private void startFramework(final BundleContext context) {
        CommandLineOptions options;
        this.registerClasspathUrlHandler(context, "freeplaneresource", (ConnectionHandler)new Handler());
        this.registerClasspathUrlHandler(context, "data", new DataHandler());
        if (null == System.getProperty("org.freeplane.core.dir.lib", null)) {
            File root = new File(ApplicationResourceController.RESOURCE_BASE_DIRECTORY).getAbsoluteFile().getParentFile();
            try {
                String rootUrl = root.toURI().toURL().toString();
                if (!rootUrl.endsWith("/")) {
                    rootUrl = rootUrl + "/";
                }
                String libUrl = rootUrl + "core/org.freeplane.core/lib/";
                System.setProperty("org.freeplane.core.dir.lib", libUrl);
            }
            catch (MalformedURLException rootUrl) {
                // empty catch block
            }
        }
        if ((options = CommandLineParser.parse((String[])this.getCallParameters())).isNonInteractive()) {
            System.setProperty(JAVA_HEADLESS_PROPERTY, "true");
        }
        Compat.setIsApplet((boolean)false);
        this.starter = this.createStarter(options);
        SingleInstanceManager singleInstanceManager = new SingleInstanceManager(this.starter, GraphicsEnvironment.isHeadless());
        singleInstanceManager.start(options);
        if (singleInstanceManager.isSlave()) {
            LogUtils.info((String)"opened files in master - exiting now");
            System.exit(0);
        } else if (singleInstanceManager.isMasterPresent()) {
            this.starter.setDontLoadLastMaps();
        }
        this.loadPlugins(context);
        final Controller controller = this.starter.createController();
        controller.getViewController().invokeLater(new Runnable(){

            @Override
            public void run() {
                ActivatorImpl.this.starter.createModeControllers(controller);
                ActivatorImpl.this.installControllerExtensions(context, controller, options);
                if ("true".equals(System.getProperty("org.freeplane.exit_on_start", null))) {
                    controller.fireStartupFinished();
                    controller.getViewController().getMainThreadExecutorService().shutdown();
                    System.exit(0);
                    return;
                }
                Bundle[] bundles = context.getBundles();
                HashSet<String> plugins = new HashSet<String>();
                for (Bundle bundle : bundles) {
                    if (bundle.getState() != 32) continue;
                    plugins.add(bundle.getSymbolicName());
                }
                FilterController.getController((Controller)controller).loadDefaultConditions();
                ActivatorImpl.this.starter.buildMenus(controller, plugins);
                ActivatorImpl.this.starter.createFrame();
            }
        });
    }

    private void installControllerExtensions(BundleContext context, Controller controller, CommandLineOptions options) {
        OsgiExtentionInstaller osgiExtentionInstaller = new OsgiExtentionInstaller(context, options);
        SModeControllerFactory.getInstance().setExtensionInstaller((ExtensionInstaller)osgiExtentionInstaller);
        osgiExtentionInstaller.installExtensions(controller);
    }

    public FreeplaneStarter createStarter(CommandLineOptions options) {
        if (GraphicsEnvironment.isHeadless()) {
            return new FreeplaneHeadlessStarter(options);
        }
        return new FreeplaneGUIStarter(options);
    }

    private void registerClasspathUrlHandler(BundleContext context, String protocol, ConnectionHandler handler) {
        Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
        properties.put("url.handler.protocol", new String[]{protocol});
        context.registerService(URLStreamHandlerService.class.getName(), (Object)new DelegatingUrlHandlerService(handler), properties);
    }

    public void stop(BundleContext context) throws Exception {
        this.starter.stop();
        Bundle[] bundles = context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            if (bundle.getState() < 32 || !bundle.getSymbolicName().startsWith("org.freeplane.plugin.")) continue;
            try {
                bundle.stop();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class OsgiExtentionInstaller
    implements ExtensionInstaller {
        private final BundleContext context;
        private final CommandLineOptions options;

        public OsgiExtentionInstaller(BundleContext context, CommandLineOptions options) {
            this.context = context;
            this.options = options;
        }

        public void installExtensions(Controller controller) {
            try {
                ServiceReference[] controllerProviders = this.context.getServiceReferences(IControllerExtensionProvider.class.getName(), null);
                if (controllerProviders != null) {
                    for (int i = 0; i < controllerProviders.length; ++i) {
                        ServiceReference controllerProvider = controllerProviders[i];
                        IControllerExtensionProvider service = (IControllerExtensionProvider)this.context.getService(controllerProvider);
                        service.installExtension(controller, this.options);
                        this.context.ungetService(controllerProvider);
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
            try {
                Set modes = controller.getModes();
                for (String modeName : modes) {
                    ServiceReference[] modeControllerProviders = this.context.getServiceReferences(IModeControllerExtensionProvider.class.getName(), "(mode=" + modeName + ")");
                    if (modeControllerProviders == null) continue;
                    ModeController modeController = controller.getModeController(modeName);
                    Controller.getCurrentController().selectModeForBuild(modeController);
                    for (int i = 0; i < modeControllerProviders.length; ++i) {
                        ServiceReference modeControllerProvider = modeControllerProviders[i];
                        IModeControllerExtensionProvider service = (IModeControllerExtensionProvider)this.context.getService(modeControllerProvider);
                        service.installExtension(modeController, this.options);
                        this.context.ungetService(modeControllerProvider);
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
            }
        }
    }
}

