/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.mindmapmode.stylemode;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.StyleFactory;
import org.freeplane.features.styles.StyleTranslatedObject;

public class NewUserStyleAction
extends AFreeplaneAction {
    private final boolean copySelectionStyle;
    private static final long serialVersionUID = 1L;

    public NewUserStyleAction(boolean copySelectionStyle) {
        super(copySelectionStyle ? "NewUserStyleFromSelectionAction" : "NewUserStyleAction");
        this.copySelectionStyle = copySelectionStyle;
    }

    public void actionPerformed(ActionEvent e) {
        NodeModel userStyleParentNode;
        IStyle style;
        String styleName = JOptionPane.showInputDialog(UITools.getCurrentRootComponent(), (Object)TextUtils.getText((String)"enter_new_style_name"));
        if (styleName == null) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        NodeModel selectedNode = controller.getSelection().getSelected();
        MapModel map = controller.getMap();
        final MapStyleModel styleModel = MapStyleModel.getExtension((MapModel)map);
        if (null != styleModel.getStyleNode(style = StyleFactory.create((String)styleName))) {
            UITools.errorMessage((Object)TextUtils.getText((String)"style_already_exists"));
            return;
        }
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        final NodeModel newNode = new NodeModel(map);
        newNode.setUserObject((Object)style);
        if (this.copySelectionStyle) {
            Controller.getCurrentModeController().copyExtensions((Object)LogicalStyleKeys.NODE_STYLE, selectedNode, newNode);
            Controller.getCurrentModeController().copyExtensions((Object)MIconController.Keys.ICONS, selectedNode, newNode);
        }
        if ((userStyleParentNode = styleModel.getStyleNodeGroup(map, "styles.user-defined")) == null) {
            userStyleParentNode = new NodeModel(map);
            userStyleParentNode.setUserObject((Object)new StyleTranslatedObject("styles.user-defined"));
            mapController.insertNode(userStyleParentNode, map.getRootNode(), false);
        }
        mapController.insertNode(newNode, userStyleParentNode, false);
        mapController.select(newNode);
        IActor actor = new IActor(){

            public void undo() {
                styleModel.removeStyleNode(newNode);
            }

            public String getDescription() {
                return "NewStyle";
            }

            public void act() {
                styleModel.addStyleNode(newNode);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }
}

