/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.IPropertyControlCreator;
import org.freeplane.core.resources.components.OptionPanelBuilder;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.CaseSensitiveFileNameExtensionFilter;
import org.freeplane.core.ui.FileOpener;
import org.freeplane.core.ui.components.JFreeplaneCustomizableFileChooser;
import org.freeplane.core.ui.components.OptionalDontShowMeAgainDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.DocuMapAttribute;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.url.IMapInputStreamConverter;
import org.freeplane.features.url.MapVersionInterpreter;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.DroppedMindMapOpener;
import org.freeplane.features.url.mindmapmode.ExportBranchAction;
import org.freeplane.features.url.mindmapmode.FileRevisionsDialog;
import org.freeplane.features.url.mindmapmode.ImportBranchAction;
import org.freeplane.features.url.mindmapmode.ImportExplorerFavoritesAction;
import org.freeplane.features.url.mindmapmode.ImportFolderStructureAction;
import org.freeplane.features.url.mindmapmode.ImportLinkedBranchAction;
import org.freeplane.features.url.mindmapmode.ImportLinkedBranchWithoutRootAction;
import org.freeplane.features.url.mindmapmode.NewMapAction;
import org.freeplane.features.url.mindmapmode.NewMapFromTemplateAction;
import org.freeplane.features.url.mindmapmode.OpenAction;
import org.freeplane.features.url.mindmapmode.OpenCurrentMapDirAction;
import org.freeplane.features.url.mindmapmode.OpenURLMapAction;
import org.freeplane.features.url.mindmapmode.OpenUserDirAction;
import org.freeplane.features.url.mindmapmode.RevertAction;
import org.freeplane.features.url.mindmapmode.SaveAction;
import org.freeplane.features.url.mindmapmode.SaveAsAction;
import org.freeplane.features.url.mindmapmode.TemplateChooser;
import org.freeplane.features.url.mindmapmode.TemplateManager;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.n3.nanoxml.XMLParseException;
import org.freeplane.view.swing.features.filepreview.MindMapPreviewWithOptions;

public class MFileManager
extends UrlManager
implements IMapViewChangeListener {
    public static final String STANDARD_TEMPLATE = "standard_template";
    private static final String DEFAULT_SAVE_DIR_PROPERTY = "default_save_dir";
    private static final String BACKUP_EXTENSION = "bak";
    static final String BACKUP_DIR = ".backup";
    private static final int DEBUG_OFFSET = 0;
    private static final javax.swing.filechooser.FileFilter MINDMAP_FILE_FILTER = new CaseSensitiveFileNameExtensionFilter("mm", TextUtils.getText((String)"mindmaps_desc"));
    private static final String BACKUP_FILE_NUMBER = "backup_file_number";
    private static File singleBackupDirectory;

    private File[] findFileRevisions(final File file, File backupDir, final AlternativeFileMode mode) {
        String fileExtensionPattern = mode == AlternativeFileMode.ALL ? "(bak|autosave)" : "autosave";
        final Pattern pattern = Pattern.compile("^" + Pattern.quote(MFileManager.backupFileName(file)) + "\\.+\\d+\\." + fileExtensionPattern);
        if (backupDir.exists()) {
            File[] fileList = backupDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    String name = f.getName();
                    return pattern.matcher(name).matches() && f.isFile() && (mode == AlternativeFileMode.ALL || f.lastModified() > file.lastModified() - 0L);
                }
            });
            return fileList;
        }
        return new File[0];
    }

    private static String backupFileName(File file) {
        if (singleBackupDirectory == null) {
            return file.getName();
        }
        return file.getName() + "." + file.hashCode();
    }

    private static void backupFile(File file, int backupFileNumber, String extension) {
        File backupFile;
        if (backupFileNumber == 0) {
            return;
        }
        File backupDir = MFileManager.backupDir(file);
        backupDir.mkdir();
        if (backupDir.exists() && !(backupFile = MFileManager.renameBackupFiles(backupDir, file, backupFileNumber, extension)).exists()) {
            MFileManager.performBackup(file, backupFile);
        }
    }

    private static void performBackup(File file, File backupFile) {
        try {
            FileUtils.copyFile((File)file, (File)backupFile);
            backupFile.setLastModified(file.lastModified());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static File backupDir(File file) {
        if (singleBackupDirectory != null) {
            return singleBackupDirectory;
        }
        if (file == null) {
            return new File(ResourceController.getResourceController().getFreeplaneUserDirectory(), BACKUP_DIR);
        }
        return new File(file.getParentFile(), BACKUP_DIR);
    }

    static File createBackupFile(File backupDir, File file, int number, String extension) {
        return new File(backupDir, MFileManager.backupFileName(file) + '.' + number + '.' + extension);
    }

    static File renameBackupFiles(File backupDir, File file, int backupFileNumber, String extension) {
        File newFile;
        if (backupFileNumber == 0) {
            return null;
        }
        int i = backupFileNumber + 1;
        while ((newFile = MFileManager.createBackupFile(backupDir, file, i, extension)).exists()) {
            newFile.delete();
            ++i;
        }
        i = backupFileNumber;
        while (!(newFile = MFileManager.createBackupFile(backupDir, file, i, extension)).exists() && --i != 0) {
        }
        if (i < backupFileNumber) {
            return MFileManager.createBackupFile(backupDir, file, i + 1, extension);
        }
        for (i = 1; i < backupFileNumber; ++i) {
            newFile = MFileManager.createBackupFile(backupDir, file, i, extension);
            File oldFile = MFileManager.createBackupFile(backupDir, file, i + 1, extension);
            newFile.delete();
            if (oldFile.renameTo(newFile)) continue;
            return null;
        }
        return MFileManager.createBackupFile(backupDir, file, backupFileNumber, extension);
    }

    public MFileManager() {
        super(new File(MFileManager.getDefaultSaveDirFromPrefs()));
    }

    private static String getDefaultSaveDirFromPrefs() {
        return ResourceController.getResourceController().getProperty(DEFAULT_SAVE_DIR_PROPERTY);
    }

    protected void init() {
        super.init();
        this.createActions();
        this.createPreferences();
        if (ResourceController.getResourceController().getBooleanProperty("single_backup_directory")) {
            String value = ResourceController.getResourceController().getProperty("single_backup_directory_path");
            String freeplaneUserDirectory = ResourceController.getResourceController().getFreeplaneUserDirectory();
            value = TextUtils.replaceAtBegin((String)value, (String)"{freeplaneuserdir}", (String)freeplaneUserDirectory);
            singleBackupDirectory = new File(value);
        }
    }

    private void createPreferences() {
        MModeController modeController = (MModeController)Controller.getCurrentModeController();
        OptionPanelBuilder optionPanelBuilder = modeController.getOptionPanelBuilder();
        optionPanelBuilder.addCreator("Environment/load", new IPropertyControlCreator(){

            public IPropertyControl createControl() {
                Set<String> charsets = Charset.availableCharsets().keySet();
                LinkedList<String> charsetList = new LinkedList<String>(charsets);
                charsetList.addFirst("JVMdefault");
                LinkedList<String> charsetTranslationList = new LinkedList<String>(charsets);
                charsetTranslationList.addFirst(TextUtils.getText((String)"OptionPanel.default"));
                return new ComboProperty(this.getPropertyName(), charsetList, charsetTranslationList);
            }

            public String getPropertyName() {
                return "default_charset";
            }
        }, 0);
        optionPanelBuilder.addCreator("Environment/files/skip_template_selection", new IPropertyControlCreator(){

            public IPropertyControl createControl() {
                TreeSet<String> templates = TemplateManager.INSTANCE.collectAvailableMapTemplates();
                ComboProperty comboProperty = new ComboProperty(this.getPropertyName(), templates, templates);
                comboProperty.setEditable(true);
                return comboProperty;
            }

            public String getPropertyName() {
                return MFileManager.STANDARD_TEMPLATE;
            }
        }, -1);
    }

    private void backup(File file) {
        if (file == null) {
            return;
        }
        int backupFileNumber = ResourceController.getResourceController().getIntProperty(BACKUP_FILE_NUMBER, 0);
        MFileManager.backupFile(file, backupFileNumber, BACKUP_EXTENSION);
    }

    private void createActions() {
        Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController();
        controller.addAction((AFreeplaneAction)new OpenAction());
        controller.addAction((AFreeplaneAction)new OpenURLMapAction());
        controller.addAction((AFreeplaneAction)new NewMapAction());
        File userTemplates = TemplateManager.INSTANCE.defaultUserTemplateDir();
        userTemplates.mkdir();
        modeController.addAction((AFreeplaneAction)new NewMapFromTemplateAction("new_map_from_user_templates"));
        modeController.addAction((AFreeplaneAction)new SaveAction());
        modeController.addAction((AFreeplaneAction)new SaveAsAction());
        modeController.addAction((AFreeplaneAction)new ExportBranchAction());
        modeController.addAction((AFreeplaneAction)new ImportBranchAction());
        modeController.addAction((AFreeplaneAction)new ImportLinkedBranchAction());
        modeController.addAction((AFreeplaneAction)new ImportLinkedBranchWithoutRootAction());
        modeController.addAction((AFreeplaneAction)new ImportExplorerFavoritesAction());
        modeController.addAction((AFreeplaneAction)new ImportFolderStructureAction());
        modeController.addAction((AFreeplaneAction)new RevertAction());
        modeController.addAction((AFreeplaneAction)new OpenCurrentMapDirAction());
        modeController.addAction((AFreeplaneAction)new OpenUserDirAction());
    }

    public JFreeplaneCustomizableFileChooser getMindMapFileChooser() {
        final JFreeplaneCustomizableFileChooser fileChooser = super.getFileChooserNotFollowingDirectoryChanges();
        File mapsDirectory = fileChooser.getCurrentDirectory();
        File templateDir = TemplateManager.INSTANCE.defaultStandardTemplateDir();
        File userTemplateDir = TemplateManager.INSTANCE.defaultUserTemplateDir();
        MindMapDirectoryFilter maps = new MindMapDirectoryFilter(MindmapDirectory.MINDMAPS, mapsDirectory);
        MindMapDirectoryFilter templates = new MindMapDirectoryFilter(MindmapDirectory.TEMPLATES, templateDir);
        MindMapDirectoryFilter userTemplates = new MindMapDirectoryFilter(MindmapDirectory.USER_TEMPLATES, userTemplateDir);
        fileChooser.addChoosableFileFilter((javax.swing.filechooser.FileFilter)maps);
        fileChooser.setFileFilter((javax.swing.filechooser.FileFilter)maps);
        fileChooser.addChoosableFileFilter((javax.swing.filechooser.FileFilter)templates);
        fileChooser.addChoosableFileFilter((javax.swing.filechooser.FileFilter)userTemplates);
        fileChooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                javax.swing.filechooser.FileFilter filter = fileChooser.getFileFilter();
                if (!(filter instanceof MindMapDirectoryFilter)) {
                    return;
                }
                File newDirectory = ((MindMapDirectoryFilter)filter).directory;
                if (!fileChooser.getCurrentDirectory().equals(newDirectory)) {
                    fileChooser.setCurrentDirectory(newDirectory);
                }
            }
        });
        fileChooser.addPropertyChangeListener("directoryChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (fileChooser.getDialogType() == 0) {
                    this.resetNonExistingFileName();
                }
            }

            private void resetNonExistingFileName() {
                FileChooserUI ui = fileChooser.getUI();
                if (ui instanceof BasicFileChooserUI) {
                    BasicFileChooserUI basicUi = (BasicFileChooserUI)ui;
                    File newSelectedFile = new File(fileChooser.getCurrentDirectory(), basicUi.getFileName());
                    if (!newSelectedFile.exists()) {
                        basicUi.setFileName("");
                    }
                }
            }
        });
        return fileChooser;
    }

    public javax.swing.filechooser.FileFilter getFileFilter() {
        return MINDMAP_FILE_FILTER;
    }

    private String getFileNameProposal(MapModel map) {
        String rootText = TextController.getController().getPlainTransformedTextWithoutNodeNumber(map.getRootNode());
        rootText = FileUtils.validFileNameOf((String)rootText);
        return rootText;
    }

    public URI getLinkByFileChooser(MapModel map) {
        File file = map.getFile();
        if (file == null && LinkController.getLinkType() == 1) {
            JOptionPane.showMessageDialog(Controller.getCurrentController().getViewController().getCurrentRootComponent(), TextUtils.getText((String)"not_saved_for_link_error"), "Freeplane", 2);
            return null;
        }
        JFreeplaneCustomizableFileChooser chooser = this.getFileChooser();
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileSelectionMode(2);
        int returnVal = chooser.showOpenDialog(Controller.getCurrentController().getViewController().getCurrentRootComponent());
        if (returnVal != 0) {
            return null;
        }
        File input = chooser.getSelectedFile();
        return LinkController.toLinkTypeDependantURI((File)file, (File)input);
    }

    @Deprecated
    public void loadAndLock(URL url, MapModel map) throws FileNotFoundException, IOException, XMLParseException, URISyntaxException {
        File file = Compat.urlToFile((URL)url);
        if (file == null) {
            this.loadCatchExceptions(url, map);
        } else {
            this.lock(map, file);
            if (file.length() != 0L) {
                this.setFile(map, file);
                NodeModel root = this.loadTree(map, file);
                assert (map.getRootNode() == root);
            }
            if (map.getRootNode() == null) {
                map.createNewRoot();
            }
        }
    }

    public void lock(MapModel map, File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(TextUtils.format((String)"file_not_found", (Object[])new Object[]{file.getPath()}));
        }
        if (!Files.isReadable(file.toPath())) {
            throw new FileNotFoundException(TextUtils.format((String)"file_not_accessible", (Object[])new Object[]{file.getPath()}));
        }
        if (!file.canWrite()) {
            map.setReadOnly(true);
        }
        try {
            String lockingUser = this.tryToLock(map, file);
            if (lockingUser != null) {
                UITools.informationMessage((Component)Controller.getCurrentController().getViewController().getCurrentRootComponent(), (String)TextUtils.format((String)"map_locked_by_open", (Object[])new Object[]{file.getName(), lockingUser}));
                map.setReadOnly(true);
            }
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
            UITools.informationMessage((Component)Controller.getCurrentController().getViewController().getCurrentRootComponent(), (String)TextUtils.format((String)"locking_failed_by_open", (Object[])new Object[]{file.getName()}));
            map.setReadOnly(true);
        }
    }

    public URL getAlternativeURL(URL url, AlternativeFileMode mode) {
        try {
            File file = Compat.urlToFile((URL)url);
            if (file == null) {
                return url;
            }
            File alternativeFile = this.getAlternativeFile(file, mode);
            if (alternativeFile != null) {
                return Compat.fileToUrl((File)alternativeFile);
            }
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public File getAlternativeFile(File file, AlternativeFileMode mode) {
        boolean success;
        File[] revisions = this.findFileRevisions(file, MFileManager.backupDir(file), mode);
        if (revisions.length == 0 && mode == AlternativeFileMode.AUTOSAVE) {
            return file;
        }
        FileRevisionsDialog newerFileRevisionsFoundDialog = new FileRevisionsDialog(file, revisions, mode);
        File selectedFile = newerFileRevisionsFoundDialog.getSelectedFile();
        if (file.equals(selectedFile) && !(success = file.setLastModified(System.currentTimeMillis()))) {
            LogUtils.warn((String)("Unable to set the last modification time for " + file));
        }
        return selectedFile;
    }

    public NodeModel loadTree(MapModel map, File file) throws XMLParseException, IOException {
        try {
            NodeModel rootNode = this.loadTreeImpl(map, file);
            return rootNode;
        }
        catch (Exception ex) {
            String errorMessage = "Error while parsing file:" + file;
            LogUtils.warn((String)errorMessage, (Throwable)ex);
            NodeModel result = new NodeModel(map);
            map.setRoot(result);
            result.setText(errorMessage);
            return result;
        }
    }

    /*
     * Exception decompiling
     */
    private NodeModel loadTreeImpl(MapModel map, File f) throws FileNotFoundException, IOException, XMLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Reader openInputStream(File file, InputStream sequencedInput, MapVersionInterpreter versionInterpreter) throws IOException, FileNotFoundException {
        Reader reader;
        if (versionInterpreter.needsConversion) {
            int showResult = OptionalDontShowMeAgainDialog.show((String)"really_convert_to_current_version", (String)"convert_to_current_version", (OptionalDontShowMeAgainDialog.MessageType)OptionalDontShowMeAgainDialog.MessageType.ONLY_OK_SELECTION_IS_STORED);
            IMapInputStreamConverter isConverter = versionInterpreter.getMapInputStreamConverter();
            reader = showResult != 0 || isConverter == null ? new InputStreamReader(sequencedInput, StandardCharsets.UTF_8) : isConverter.getConvertedStream(file);
        } else {
            reader = new InputStreamReader(sequencedInput, StandardCharsets.UTF_8);
        }
        return reader;
    }

    @Deprecated
    public void loadHyperlink(Hyperlink relative) {
        MapModel map = Controller.getCurrentController().getMap();
        if (!(map != null && map.getURL() != null || (relative.toString().startsWith("#") || relative.getUri().isAbsolute()) && !relative.getUri().isOpaque())) {
            Controller.getCurrentController().getViewController().out("You must save the current map first!");
            boolean result = ((MFileManager)UrlManager.getController()).save(map);
            if (!result) {
                return;
            }
        }
        super.loadHyperlink(relative);
    }

    public void open() {
        JFreeplaneCustomizableFileChooser chooser = this.getMindMapFileChooser();
        chooser.setMultiSelectionEnabled(true);
        int returnVal = chooser.showOpenDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent());
        if (returnVal != 0) {
            return;
        }
        File[] selectedFiles = chooser.getSelectedFiles();
        for (int i = 0; i < selectedFiles.length; ++i) {
            File theFile = selectedFiles[i];
            try {
                Controller.getCurrentModeController().getMapController().openMap(Compat.fileToUrl((File)theFile));
                continue;
            }
            catch (Exception ex) {
                this.handleLoadingException(ex);
                break;
            }
        }
        Controller.getCurrentController().getMapViewManager().setMapTitles();
    }

    public MapModel newMapFromDefaultTemplate() {
        return AccessController.doPrivileged(new PrivilegedAction<MapModel>(){
            private boolean follow = false;
            private File chosenFile;

            private void chooseTemplateFile() {
                ResourceController resourceController = ResourceController.getResourceController();
                boolean skipTemplateSelection = resourceController.getBooleanProperty("skip_template_selection");
                if (skipTemplateSelection) {
                    this.chosenFile = MFileManager.this.defaultTemplateFile();
                    this.follow = resourceController.getBooleanProperty("follow_mind_map_by_default");
                } else {
                    TemplateChooser templateChooser = new TemplateChooser();
                    this.chosenFile = templateChooser.chosenTemplateFile();
                    this.follow = templateChooser.isConnectChecked();
                }
            }

            @Override
            public MapModel run() {
                this.chooseTemplateFile();
                return this.chosenFile != null ? MFileManager.this.openUntitledMap(this.chosenFile, this.follow) : null;
            }
        });
    }

    public File defaultTemplateFile() {
        String userDefinedTemplateFilePath = ResourceController.getResourceController().getProperty(STANDARD_TEMPLATE);
        return TemplateManager.INSTANCE.existingTemplateFile(userDefinedTemplateFilePath);
    }

    public MapModel openUntitledMap(final File startFile, final boolean startFollow) {
        return AccessController.doPrivileged(new PrivilegedAction<MapModel>(){

            @Override
            public MapModel run() {
                boolean follow;
                File file;
                if (startFile == null) {
                    file = MFileManager.this.getLastCurrentDir();
                    follow = false;
                } else if (startFile.isDirectory()) {
                    JFreeplaneCustomizableFileChooser chooser = MFileManager.this.getMindMapFileChooser();
                    MindMapPreviewWithOptions previewWithOptions = new MindMapPreviewWithOptions((JFileChooser)chooser);
                    if (startFollow) {
                        previewWithOptions.selectFollows();
                    }
                    previewWithOptions.associateAlways();
                    chooser.setAccessory((JComponent)previewWithOptions);
                    Stream.of(chooser.getChoosableFileFilters()).filter(filter -> filter instanceof MindMapDirectoryFilter).map(MindMapDirectoryFilter.class::cast).filter(filter -> filter.directory.equals(startFile)).findFirst().ifPresent(arg_0 -> 7.lambda$run$2((JFileChooser)chooser, arg_0));
                    chooser.setCurrentDirectory(startFile);
                    int returnVal = chooser.showOpenDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent());
                    if (returnVal != 0) {
                        return null;
                    }
                    file = chooser.getSelectedFile();
                    follow = previewWithOptions.isFollowChecked();
                } else {
                    file = startFile;
                    follow = startFollow;
                }
                try {
                    MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
                    MapModel map = mapController.newMap(Compat.fileToUrl((File)file), follow);
                    return map;
                }
                catch (Exception e) {
                    MFileManager.this.handleLoadingException(e);
                    return null;
                }
            }

            private static /* synthetic */ void lambda$run$2(JFileChooser chooser, MindMapDirectoryFilter filter) {
                chooser.setFileFilter(filter);
            }
        });
    }

    public boolean save(MapModel map) {
        if (map == null || map.isSaved()) {
            return true;
        }
        if (map.getURL() == null || map.isReadOnly()) {
            return this.saveAs(map);
        }
        return this.save(map, map.getFile());
    }

    public boolean save(MapModel map, File file) {
        if (file == null) {
            return this.saveAs(map);
        }
        try {
            String lockingUser;
            if (null == map.getExtension(BackupFlag.class)) {
                map.addExtension((IExtension)new BackupFlag());
                this.backup(file);
            }
            if ((lockingUser = this.tryToLock(map, file)) != null) {
                UITools.informationMessage((Component)Controller.getCurrentController().getViewController().getCurrentRootComponent(), (String)TextUtils.format((String)"map_locked_by_save_as", (Object[])new Object[]{file.getName(), lockingUser}));
                return false;
            }
        }
        catch (Exception e) {
            UITools.informationMessage((Component)Controller.getCurrentController().getViewController().getCurrentRootComponent(), (String)TextUtils.format((String)"locking_failed_by_save_as", (Object[])new Object[]{file.getName()}));
            return false;
        }
        if (file.exists() && !file.canWrite()) {
            JOptionPane.showMessageDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent(), TextUtils.format((String)"SaveAs_toReadonlyMsg", (Object[])new Object[]{file}), TextUtils.getText((String)"SaveAs_toReadonlyTitle"), 2);
            return false;
        }
        URL urlBefore = map.getURL();
        this.setFile(map, file);
        boolean saved = this.saveInternal((MMapModel)map, file, false);
        if (!saved) {
            return false;
        }
        map.updateLastKnownFileModificationTime();
        map.setReadOnly(false);
        URL urlAfter = map.getURL();
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        if (!urlAfter.equals(urlBefore)) {
            mapController.fireMapChanged(new MapChangeEvent((Object)this, map, (Object)"map_url", (Object)urlBefore, (Object)urlAfter, false));
        }
        mapController.setSaved(map, true);
        return true;
    }

    public boolean saveAs(MapModel map) {
        int overwriteMap;
        JFreeplaneCustomizableFileChooser chooser = this.getMindMapFileChooser();
        File mapFile = map.getFile();
        if (mapFile == null || mapFile.getParentFile() == null) {
            File defaultFile = new File(this.getFileNameProposal(map) + ".mm");
            chooser.setSelectedFile(defaultFile);
        } else {
            chooser.setSelectedFile(mapFile);
        }
        chooser.setDialogTitle(TextUtils.getText((String)"SaveAsAction.text"));
        int returnVal = chooser.showSaveDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent());
        if (returnVal != 0) {
            return false;
        }
        File f = chooser.getSelectedFile();
        String ext = FileUtils.getExtension((String)f.getName());
        if (!ext.equals("mm")) {
            f = new File(f.getParent(), f.getName() + ".mm");
        }
        if (f.exists() && (overwriteMap = JOptionPane.showConfirmDialog(Controller.getCurrentController().getMapViewManager().getMapViewComponent(), TextUtils.getText((String)"map_already_exists"), "Freeplane", 0)) != 0) {
            return false;
        }
        File oldFile = mapFile;
        if (oldFile != null) {
            oldFile = oldFile.getAbsoluteFile();
        }
        if (!f.getAbsoluteFile().equals(oldFile)) {
            if (null != map.getExtension(BackupFlag.class)) {
                map.removeExtension(BackupFlag.class);
            }
            if (null != map.getExtension(DocuMapAttribute.class)) {
                map.removeExtension(DocuMapAttribute.class);
            }
            map.setReadOnly(false);
        }
        if (this.save(map, f)) {
            Controller.getCurrentController().getMapViewManager().updateMapViewName();
            return true;
        }
        return false;
    }

    boolean saveInternal(MMapModel map, File file, boolean isInternal) {
        try {
            if (map.getTimerForAutomaticSaving() != null) {
                map.getTimerForAutomaticSaving().stop();
            }
            this.writeToFile(map, file);
            map.scheduleTimerForAutomaticSaving();
            return true;
        }
        catch (IOException e) {
            String message = TextUtils.format((String)"save_failed", (Object[])new Object[]{file.getName()});
            if (!isInternal) {
                UITools.errorMessage((Object)message);
                LogUtils.warn((String)message, (Throwable)e);
            } else {
                Controller.getCurrentController().getViewController().out(message);
            }
        }
        catch (Exception e) {
            LogUtils.severe((String)"Error in MapModel.save(): ", (Throwable)e);
        }
        map.scheduleTimerForAutomaticSaving();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void writeToFile(MapModel map, File file) throws FileNotFoundException, IOException {
        FileLock lock = null;
        try (FileOutputStream out = new FileOutputStream(file);){
            boolean lockedByOtherApplication = false;
            try {
                lock = out.getChannel().tryLock();
                lockedByOtherApplication = lock == null;
            }
            catch (Exception e) {
                LogUtils.warn((String)e.getMessage(), (Throwable)e);
            }
            if (lockedByOtherApplication) {
                throw new IOException("can not obtain file lock for " + file);
            }
            BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            Controller.getCurrentModeController().getMapController().getMapWriter().writeMapAsXml(map, (Writer)fileout, MapWriter.Mode.FILE, true, false);
        }
        finally {
            if (lock != null && lock.isValid()) {
                lock.release();
            }
        }
    }

    public void setFile(MapModel map, File file) {
        try {
            URL url = Compat.fileToUrl((File)file);
            this.setURL(map, url);
        }
        catch (MalformedURLException e) {
            LogUtils.severe((Throwable)e);
        }
    }

    @Deprecated
    public String tryToLock(MapModel map, File file) throws Exception {
        String lockingUser = ((MMapModel)map).getLockManager().tryToLock(file);
        String lockingUserOfOldLock = ((MMapModel)map).getLockManager().popLockingUserOfOldLock();
        if (lockingUserOfOldLock != null) {
            UITools.informationMessage((Component)UITools.getCurrentRootComponent(), (String)TextUtils.format((String)"locking_old_lock_removed", (Object[])new Object[]{file.getName(), lockingUserOfOldLock}));
        }
        return lockingUser;
    }

    public void afterViewCreated(Component oldView, Component newView) {
        if (newView != null) {
            FileOpener fileOpener = new FileOpener("mm", (FileOpener.Listener)new DroppedMindMapOpener());
            new DropTarget(newView, (DropTargetListener)fileOpener);
        }
    }

    public static MFileManager getController(ModeController modeController) {
        return (MFileManager)modeController.getExtension(UrlManager.class);
    }

    public static enum AlternativeFileMode {
        ALL,
        AUTOSAVE;

    }

    private static class MindMapDirectoryFilter
    extends javax.swing.filechooser.FileFilter {
        final File directory;
        final String description;

        MindMapDirectoryFilter(MindmapDirectory mindmapDirectory, File directory) {
            this.directory = directory;
            this.description = TextUtils.getText((String)mindmapDirectory.key) + " (*.mm)";
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = FileUtils.getExtension((String)f.getName());
            if (extension != null) {
                return extension.equals("mm");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    static enum MindmapDirectory {
        MINDMAPS("mindmaps_desc"),
        TEMPLATES("template_dir"),
        USER_TEMPLATES("user_template_dir");

        final String key;

        private MindmapDirectory(String key) {
            this.key = key;
        }
    }

    private static class BackupFlag
    implements IExtension {
        private BackupFlag() {
        }
    }
}

