/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.NumberProperty;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeModel;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

public class EdgeWidthControlGroup
implements ControlGroup {
    private static final String THINNEST_TEXT = TextUtils.getText((String)"thinnest");
    private static final String EDGE_WIDTH = "edgewidth";
    private RevertingProperty mSetEdgeWidth;
    private NumberProperty mEdgeWidth;
    private EdgeWidthChangeListener propertyChangeListener;

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetEdgeWidth = new RevertingProperty();
        this.mEdgeWidth = new NumberProperty(EDGE_WIDTH, 0, 100, 1);
        this.mEdgeWidth.configureNames(Collections.singletonMap(THINNEST_TEXT, 0));
        this.propertyChangeListener = new EdgeWidthChangeListener(this.mSetEdgeWidth, (IPropertyControl)this.mEdgeWidth);
        this.mSetEdgeWidth.addPropertyChangeListener(this.propertyChangeListener);
        this.mEdgeWidth.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mEdgeWidth.appendToForm(formBuilder);
        this.mSetEdgeWidth.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    private class EdgeWidthChangeListener
    extends ControlGroupChangeListener {
        public EdgeWidthChangeListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MEdgeController styleController = (MEdgeController)Controller.getCurrentModeController().getExtension(EdgeController.class);
            styleController.setWidth(node, enabled ? Integer.parseInt(EdgeWidthControlGroup.this.mEdgeWidth.getValue()) : -1);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            EdgeController edgeController = EdgeController.getController();
            EdgeModel edgeModel = EdgeModel.getModel((NodeModel)node);
            int width = edgeModel != null ? edgeModel.getWidth() : -1;
            int viewWidth = edgeController.getWidth(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            EdgeWidthControlGroup.this.mSetEdgeWidth.setValue(width != -1);
            EdgeWidthControlGroup.this.mEdgeWidth.setValue(Integer.toString(viewWidth));
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, EdgeWidthControlGroup.this.mSetEdgeWidth);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)EdgeWidthControlGroup.this.mEdgeWidth);
        }
    }
}

