/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.presentations.mindmapmode.Slide;

class UndoableSlide {
    private final ModeController controller;
    private final MapModel mapModel;
    private final Slide slide;

    public static UndoableSlide of(Slide slide) {
        return new UndoableSlide(Controller.getCurrentModeController(), Controller.getCurrentController().getMap(), slide);
    }

    public UndoableSlide(ModeController controller, MapModel mapModel, Slide slide) {
        this.controller = controller;
        this.mapModel = mapModel;
        this.slide = slide;
    }

    public void setName(final String name) {
        final String oldName = this.slide.getName();
        if (name.equals(oldName)) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setName";
            }

            public void act() {
                UndoableSlide.this.slide.setName(name);
            }

            public void undo() {
                UndoableSlide.this.slide.setName(oldName);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void setSelectedNodeIds(final Set<String> selectedNodeIds) {
        final Set<String> oldSelectedNodeIds = this.slide.getSelectedNodeIds();
        if (selectedNodeIds.equals(oldSelectedNodeIds)) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setSelectedNodeIds";
            }

            public void act() {
                UndoableSlide.this.slide.setSelectedNodeIds(selectedNodeIds);
            }

            public void undo() {
                UndoableSlide.this.slide.setSelectedNodeIds(oldSelectedNodeIds);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void addSelectedNodeIds(Collection<String> selectedNodeIds) {
        final HashSet<String> newSelectedNodeIds = new HashSet<String>(selectedNodeIds);
        newSelectedNodeIds.removeAll(this.slide.getSelectedNodeIds());
        if (newSelectedNodeIds.isEmpty()) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "addSelectedNodeIds";
            }

            public void act() {
                UndoableSlide.this.slide.addSelectedNodeIds(newSelectedNodeIds);
            }

            public void undo() {
                UndoableSlide.this.slide.removeSelectedNodeIds(newSelectedNodeIds);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void removeSelectedNodeIds(Collection<String> selectedNodeIds) {
        final HashSet<String> removedNodeIds = new HashSet<String>(selectedNodeIds);
        removedNodeIds.retainAll(this.slide.getSelectedNodeIds());
        if (removedNodeIds.isEmpty()) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "removeSelectedNodeIds";
            }

            public void act() {
                UndoableSlide.this.slide.removeSelectedNodeIds(removedNodeIds);
            }

            public void undo() {
                UndoableSlide.this.slide.addSelectedNodeIds(removedNodeIds);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void setPlacedNodeId(final String placedNodeId) {
        final String oldPlacedNodeId = this.slide.getPlacedNodeId();
        if (placedNodeId == oldPlacedNodeId || placedNodeId != null && placedNodeId.equals(oldPlacedNodeId)) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setPlacedNodeId";
            }

            public void act() {
                UndoableSlide.this.slide.setPlacedNodeId(placedNodeId);
            }

            public void undo() {
                UndoableSlide.this.slide.setPlacedNodeId(oldPlacedNodeId);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void setPlacedNodePosition(final IMapSelection.NodePosition placedNodePosition) {
        final IMapSelection.NodePosition oldPlacedNodePosition = this.slide.getPlacedNodePosition();
        if (oldPlacedNodePosition == placedNodePosition) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setPlacesNodeAtMargin";
            }

            public void act() {
                UndoableSlide.this.slide.setPlacedNodePosition(placedNodePosition);
            }

            public void undo() {
                UndoableSlide.this.slide.setPlacedNodePosition(oldPlacedNodePosition);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void setChangesZoom(final boolean changeZoom) {
        final boolean oldChangesZoom = this.slide.changesZoom();
        if (changeZoom == oldChangesZoom) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setChangesZoom";
            }

            public void act() {
                UndoableSlide.this.slide.setChangesZoom(changeZoom);
            }

            public void undo() {
                UndoableSlide.this.slide.setChangesZoom(oldChangesZoom);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void setZoom(final float zoom) {
        final float oldZoom = this.slide.getZoom();
        if (zoom == oldZoom) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setChangesZoom";
            }

            public void act() {
                UndoableSlide.this.slide.setZoom(zoom);
            }

            public void undo() {
                UndoableSlide.this.slide.setZoom(oldZoom);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void setShowsOnlySpecificNodes(final boolean showOnlySpecificNodes) {
        final boolean oldShowsOnlySpecificNodes = this.slide.showsOnlySpecificNodes();
        if (showOnlySpecificNodes == oldShowsOnlySpecificNodes) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setShowsOnlySpecificNodes";
            }

            public void act() {
                UndoableSlide.this.slide.setShowsOnlySpecificNodes(showOnlySpecificNodes);
            }

            public void undo() {
                UndoableSlide.this.slide.setShowsOnlySpecificNodes(oldShowsOnlySpecificNodes);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void setShowsAncestors(final boolean showAncestors) {
        final boolean oldShowsAncestors = this.slide.showsAncestors();
        if (showAncestors == oldShowsAncestors) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setShowsAncestors";
            }

            public void act() {
                UndoableSlide.this.slide.setShowsAncestors(showAncestors);
            }

            public void undo() {
                UndoableSlide.this.slide.setShowsAncestors(oldShowsAncestors);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void setShowsDescendants(final boolean showDescendants) {
        final boolean oldShowsDescendants = this.slide.showsDescendants();
        if (showDescendants == oldShowsDescendants) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setShowsDescendants";
            }

            public void act() {
                UndoableSlide.this.slide.setShowsDescendants(showDescendants);
            }

            public void undo() {
                UndoableSlide.this.slide.setShowsDescendants(oldShowsDescendants);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void setFilterCondition(final ASelectableCondition filterCondition) {
        final ASelectableCondition oldFilterCondition = this.slide.getFilterCondition();
        if (filterCondition == oldFilterCondition) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setFilterCondition";
            }

            public void act() {
                UndoableSlide.this.slide.setFilterCondition(filterCondition);
            }

            public void undo() {
                UndoableSlide.this.slide.setFilterCondition(oldFilterCondition);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void setCurrentFoldedNodeIDs() {
        final Collection<String> currentFoldedNodeIds = this.slide.getCurrentFoldedNodeIds();
        final Set<String> oldFoldedNodeIds = this.slide.getFoldedNodeIds();
        final boolean foldedNodes = this.slide.foldsNodes();
        if (currentFoldedNodeIds == oldFoldedNodeIds && foldedNodes) {
            return;
        }
        IActor actor = new IActor(){

            public String getDescription() {
                return "setCurrentFoldedNodeIDs";
            }

            public void act() {
                UndoableSlide.this.slide.setFoldedNodeIDs(currentFoldedNodeIds);
            }

            public void undo() {
                if (foldedNodes) {
                    UndoableSlide.this.slide.setFoldedNodeIDs(oldFoldedNodeIds);
                } else {
                    UndoableSlide.this.slide.unsetFoldsNodes();
                }
            }
        };
        this.controller.execute(actor, this.mapModel);
    }

    public void unsetFoldsNodes() {
        boolean foldedNodes = this.slide.foldsNodes();
        if (!foldedNodes) {
            return;
        }
        final Set<String> oldFoldedNodeIds = this.slide.getFoldedNodeIds();
        IActor actor = new IActor(){

            public String getDescription() {
                return "unsetFoldsNodes";
            }

            public void act() {
                UndoableSlide.this.slide.unsetFoldsNodes();
            }

            public void undo() {
                UndoableSlide.this.slide.setFoldedNodeIDs(oldFoldedNodeIds);
            }
        };
        this.controller.execute(actor, this.mapModel);
    }
}

