/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.note.mindmapmode;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.note.NoteStyleAccessor;
import org.freeplane.features.note.mindmapmode.EditNoteInDialogAction;
import org.freeplane.features.note.mindmapmode.NoteDialogStarter;
import org.freeplane.features.note.mindmapmode.NoteManager;
import org.freeplane.features.note.mindmapmode.NotePanel;
import org.freeplane.features.note.mindmapmode.RemoveNoteAction;
import org.freeplane.features.note.mindmapmode.SelectNoteAction;
import org.freeplane.features.note.mindmapmode.SetNoteWindowPosition;
import org.freeplane.features.note.mindmapmode.ShowHideNoteAction;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.SetBooleanMapPropertyAction;

public class MNoteController
extends NoteController {
    public static final String RESOURCES_REMOVE_NOTES_WITHOUT_QUESTION = "remove_notes_without_question";
    public static final String RESOURCES_USE_DEFAULT_FONT_FOR_NOTES_TOO = "resources_use_default_font_for_notes_too";
    public static final String RESOURCES_USE_MARGIN_TOP_ZERO_FOR_NOTES = "resources_use_margin_top_zero_for_notes";
    static final String RESOURCES_USE_SPLIT_PANE = "use_split_pane";
    private static NotePanel notePanel;
    private final NoteManager noteManager;
    private final Set<String> noteContentTypes;
    private MModeController modeController;

    public static MNoteController getController() {
        return (MNoteController)NoteController.getController();
    }

    public MNoteController(MModeController modeController) {
        this.modeController = modeController;
        modeController.registerExtensionCopier(new ExtensionCopier());
        this.noteManager = new NoteManager(this);
        this.noteContentTypes = new LinkedHashSet<String>();
        this.noteContentTypes.add("auto");
        this.noteContentTypes.add("html");
        this.createActions(modeController);
    }

    private void createActions(ModeController modeController) {
        modeController.addAction((AFreeplaneAction)new SelectNoteAction(this));
        modeController.addAction((AFreeplaneAction)new ShowHideNoteAction(this));
        modeController.addAction((AFreeplaneAction)new EditNoteInDialogAction());
        modeController.addAction((AFreeplaneAction)new SetNoteWindowPosition("top"));
        modeController.addAction((AFreeplaneAction)new SetNoteWindowPosition("left"));
        modeController.addAction((AFreeplaneAction)new SetNoteWindowPosition("right"));
        modeController.addAction((AFreeplaneAction)new SetNoteWindowPosition("bottom"));
        modeController.addAction((AFreeplaneAction)new RemoveNoteAction(this));
        modeController.addAction((AFreeplaneAction)new SetBooleanMapPropertyAction("show_note_icons"));
    }

    public boolean addNoteContentType(String e) {
        return this.noteContentTypes.add(e);
    }

    public String[] getNoteContentTypes() {
        return (String[])this.noteContentTypes.stream().toArray(String[]::new);
    }

    void hideNotesPanel() {
        this.noteManager.saveNote();
        notePanel.setVisible(false);
        Controller.getCurrentModeController().getController().getViewController().removeSplitPane();
        ResourceController.getResourceController().setProperty(RESOURCES_USE_SPLIT_PANE, "false");
    }

    protected void onWrite(MapModel map) {
        ModeController modeController = Controller.getCurrentModeController();
        Controller controller = modeController.getController();
        IMapSelection selection = controller.getSelection();
        if (selection == null || notePanel == null) {
            return;
        }
        NodeModel selected = selection.getSelected();
        this.noteManager.saveNote(selected);
    }

    public void setNoteText(NodeModel node, String newText) {
        if ("".equals(newText)) {
            this.setNoteText(node, null);
            return;
        }
        String oldText = NoteModel.getNoteText((NodeModel)node);
        if (oldText == newText || null != oldText && oldText.equals(newText)) {
            return;
        }
        NoteModel oldNote = NoteModel.getNote((NodeModel)node);
        NoteModel newNote = oldNote == null ? new NoteModel() : oldNote.copy();
        newNote.setText(newText);
        this.setNote(node, oldNote, newNote, "setNoteText");
    }

    public void setNoteContentType(NodeModel node, String newContentType) {
        String oldContentType = NoteModel.getNoteContentType((NodeModel)node);
        if (oldContentType == newContentType || null != oldContentType && oldContentType.equals(newContentType)) {
            return;
        }
        NoteModel oldNote = NoteModel.getNote((NodeModel)node);
        NoteModel newNote = oldNote == null ? new NoteModel() : oldNote.copy();
        newNote.setContentType(newContentType);
        this.setNote(node, oldNote, newNote, "setNoteContentType");
    }

    private void setNote(final NodeModel node, final NoteModel oldNote, final NoteModel newNote, final String description) {
        IActor actor = new IActor(){

            public void act() {
                this.setNote(newNote);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"note_text", (Object)oldNote, (Object)newNote);
            }

            public String getDescription() {
                return description;
            }

            public void undo() {
                this.setNote(oldNote);
                Controller.getCurrentModeController().getMapController().nodeChanged(node, (Object)"note_text", (Object)newNote, (Object)oldNote);
            }

            private void setNote(NoteModel note) {
                IMapSelection selection;
                if (note == null || note.isEmpty()) {
                    node.removeExtension(NoteModel.class);
                } else {
                    node.putExtension((IExtension)note);
                }
                if (MNoteController.this.noteManager != null && (selection = Controller.getCurrentController().getSelection()) != null && node.equals(selection.getSelected())) {
                    MNoteController.this.noteManager.updateEditor();
                }
            }
        };
        Controller.getCurrentModeController().execute(actor, node.getMap());
    }

    private boolean shouldUseSplitPane() {
        return "true".equals(ResourceController.getResourceController().getProperty(RESOURCES_USE_SPLIT_PANE));
    }

    void showNotesPanel() {
        if (notePanel == null) {
            notePanel = new NotePanel(this.noteManager, new NoteDocumentListener());
            this.noteManager.updateEditor();
        }
        ResourceController.getResourceController().setProperty(RESOURCES_USE_SPLIT_PANE, "true");
        Controller.getCurrentModeController().getController().getViewController().insertComponentIntoSplitPane((JComponent)notePanel);
        notePanel.setVisible(true);
        notePanel.revalidate();
    }

    void setDefaultStyle(NodeModel node) {
        ModeController modeController = Controller.getCurrentModeController();
        NoteStyleAccessor noteStyleAccessor = new NoteStyleAccessor(modeController, node, 1.0f, false);
        String noteCssRule = noteStyleAccessor.getNoteCSSStyle();
        notePanel.updateColors(noteStyleAccessor.getNoteForeground(), noteStyleAccessor.getNoteBackground());
        StringBuilder cssBuilder = new StringBuilder("body {").append(noteCssRule).append("}\n");
        if (ResourceController.getResourceController().getBooleanProperty(RESOURCES_USE_MARGIN_TOP_ZERO_FOR_NOTES)) {
            cssBuilder.append("p {margin-top:0;}\n");
        }
        notePanel.updateStyleSheet(cssBuilder.toString(), noteStyleAccessor.getNoteStyleSheet());
    }

    public void stopEditing() {
        if (this.isEditing()) {
            this.noteManager.saveNote();
            this.modeController.forceNewTransaction();
        }
    }

    boolean isEditing() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focusOwner != null && notePanel != null && SwingUtilities.isDescendingFrom(focusOwner, notePanel);
    }

    void setFocusToMap() {
        Controller controller = Controller.getCurrentModeController().getController();
        NodeModel node = controller.getSelection().getSelected();
        controller.getMapViewManager().getComponent(node).requestFocusInWindow();
    }

    public void shutdownController() {
        Controller.getCurrentModeController().getMapController().removeNodeSelectionListener((INodeSelectionListener)this.noteManager);
        Controller.getCurrentController().getMapViewManager().removeMapSelectionListener((IMapSelectionListener)this.noteManager);
        if (notePanel == null) {
            return;
        }
        notePanel.getActionMap().remove("jumpToMapAction");
        if (this.shouldUseSplitPane()) {
            this.hideNotesPanel();
            notePanel = null;
        }
    }

    public void startupController() {
        ModeController modeController = Controller.getCurrentModeController();
        if (this.shouldUseSplitPane()) {
            this.showNotesPanel();
        }
        modeController.getMapController().addNodeSelectionListener((INodeSelectionListener)this.noteManager);
        Controller.getCurrentController().getMapViewManager().addMapSelectionListener((IMapSelectionListener)this.noteManager);
    }

    boolean isNoteEditorShowing() {
        return ResourceController.getResourceController().getBooleanProperty(RESOURCES_USE_SPLIT_PANE);
    }

    public void setShowNotesInMap(MapModel model, boolean show) {
        MapStyle.getController().setProperty(model, "show_notes_in_map", Boolean.toString(show));
    }

    public void editNoteInDialog(NodeModel nodeModel) {
        new NoteDialogStarter().editNoteInDialog(nodeModel);
    }

    NotePanel getNotePanel() {
        return notePanel;
    }

    private static class ExtensionCopier
    implements IExtensionCopier {
        private ExtensionCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            NoteModel fromNote = NoteModel.getNote((NodeModel)from);
            if (fromNote == null) {
                return;
            }
            String contentType = fromNote.getContentType();
            if (contentType == null) {
                return;
            }
            NoteModel oldNote = NoteModel.getNote((NodeModel)to);
            NoteModel newNote = oldNote == null ? new NoteModel() : oldNote.copy();
            newNote.setContentType(contentType);
            to.putExtension((IExtension)newNote);
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            NoteModel fromNote = NoteModel.getNote((NodeModel)from);
            if (fromNote == null) {
                return;
            }
            String contentType = fromNote.getContentType();
            if (contentType == null) {
                return;
            }
            NoteModel newNote = fromNote.copy();
            newNote.setContentType(null);
            from.putExtension((IExtension)newNote);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            NoteModel whichNote = NoteModel.getNote((NodeModel)which);
            if (whichNote == null || whichNote.getContentType() == null) {
                return;
            }
            this.remove(key, from);
        }
    }

    final class NoteDocumentListener
    implements DocumentListener {
        NoteDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.docEvent();
        }

        private void docEvent() {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner == null || !SwingUtilities.isDescendingFrom(focusOwner, notePanel)) {
                return;
            }
            ModeController modeController = Controller.getCurrentModeController();
            MapController mapController = modeController.getMapController();
            MapModel map = modeController.getController().getMap();
            if (map != null) {
                mapController.setSaved(map, false);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.docEvent();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.docEvent();
        }
    }
}

