/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.FirstGroupNodeFlag;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryLevels;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.SummaryNodeFlag;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.url.MapVersionInterpreter;

public class SummaryNodeMapUpdater
implements IMapLifeCycleListener {
    private final MMapController mapController;
    private final MModeController modeController;

    public SummaryNodeMapUpdater(MModeController modeController, MMapController mapController) {
        this.modeController = modeController;
        this.mapController = mapController;
    }

    public void onCreate(MapModel map) {
        MapVersionInterpreter mapXmlVersionInterpreter = (MapVersionInterpreter)map.getExtension(MapVersionInterpreter.class);
        if (mapXmlVersionInterpreter == null || mapXmlVersionInterpreter.version < 6) {
            this.modeController.deactivateUndo((MMapModel)map);
            this.updateSummaryNodes(map.getRootNode(), map.getRootNode());
        }
    }

    private void updateSummaryNodes(NodeModel rootNode, NodeModel parentNode) {
        NodeModel[] nodes;
        for (NodeModel node : nodes = parentNode.getChildren().toArray(new NodeModel[0])) {
            SummaryLevels summaryLevels = null;
            if (SummaryNode.isFirstGroupNode((NodeModel)node)) {
                if (summaryLevels == null) {
                    summaryLevels = new SummaryLevels(rootNode, parentNode);
                }
                if (summaryLevels.findSummaryNode(node.getIndex()) == null) {
                    node.removeExtension(FirstGroupNodeFlag.class);
                }
            }
            if (SummaryNode.isSummaryNode((NodeModel)node)) {
                NodeModel groupBeginNode;
                if (summaryLevels == null) {
                    summaryLevels = new SummaryLevels(rootNode, parentNode);
                }
                if ((groupBeginNode = summaryLevels.findGroupBeginNode(parentNode.previousNodeIndex(rootNode, node.getIndex(), node.isLeft(rootNode)))) == null) {
                    node.removeExtension(SummaryNodeFlag.class);
                } else {
                    if (!groupBeginNode.containsExtension(FirstGroupNodeFlag.class)) {
                        if (SummaryNode.isSummaryNode((NodeModel)groupBeginNode)) {
                            groupBeginNode.addExtension((IExtension)FirstGroupNodeFlag.FIRST_GROUP);
                        } else {
                            NodeModel newFirstGroupNode = this.mapController.addNewNode(groupBeginNode.getParentNode(), groupBeginNode.getIndex(), groupBeginNode.getSide());
                            newFirstGroupNode.addExtension((IExtension)FirstGroupNodeFlag.FIRST_GROUP);
                        }
                    }
                    if (node.isFolded() || !node.hasChildren() || !node.getText().isEmpty()) {
                        node.removeExtension(SummaryNodeFlag.class);
                        NodeModel newParent = this.mapController.addNewNode(node.getParentNode(), node.getIndex(), node.getSide());
                        newParent.addExtension((IExtension)SummaryNodeFlag.SUMMARY);
                        if (SummaryNode.isFirstGroupNode((NodeModel)node)) {
                            node.removeExtension(FirstGroupNodeFlag.class);
                            newParent.addExtension((IExtension)FirstGroupNodeFlag.FIRST_GROUP);
                        }
                        this.mapController.moveNodeAndItsClones(node, newParent, 0);
                    }
                }
            } else if (SummaryNode.isFirstGroupNode((NodeModel)node) && (node.hasChildren() || !node.getText().isEmpty())) {
                NodeModel newFirstGroupNode = this.mapController.addNewNode(node.getParentNode(), node.getIndex(), node.getSide());
                node.removeExtension(FirstGroupNodeFlag.class);
                newFirstGroupNode.addExtension((IExtension)FirstGroupNodeFlag.FIRST_GROUP);
            }
            this.updateSummaryNodes(rootNode, node);
        }
    }
}

